<?php
/*
 * Moderation panel for checking all posts, images, tours, classifieds, comments. Shown in the header.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$get_moderate_page = isset($_GET['moderation-page']) ? $_GET['moderation-page'] : '';

$pages = array(
	'profiles' => esc_html__( 'Profiles', 'datebook' ),
	'images' => esc_html__( 'Images', 'datebook' ),
	'comments' => esc_html__( 'Comments', 'datebook' ),
	'classifieds' => esc_html__( 'Classifieds', 'datebook' ),
	'tours' => esc_html__( 'Tours', 'datebook' ),
	'reports' => esc_html__( 'Reports', 'datebook' )
);

$home_url = home_url();

?>

<div class="datebook-moderation-panel stylish-color">
	<div class="container">

		<strong class="text-white"><?php esc_html_e( 'Moderation', 'datebook' ); ?>:</strong> 

		<?php foreach ($pages as $page_url => $page_title): ?>

			<a class="btn btn-sm shadow-none <?php echo (($get_moderate_page == $page_url) ? 'btn-primary' : 'btn-light'); ?>" href="<?php echo esc_url($home_url . '/?datebook-moderation=yes&moderation-page=' . $page_url); ?>"><?php echo $page_title; ?> <span class="ml-1 shadow-none badge <?php echo (($get_moderate_page == $page_url) ? 'badge-light' : 'badge-dark'); ?>">0</span></a>

		<?php endforeach; ?>

	</div>
</div>