<?php
/**
 * The default template for displaying Countries list
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


global $wpdb, $datebook_field_titles;

$table_name = strtolower($wpdb->prefix) . 'datebook_countries'; // do not forget about tables prefix

// Get all countries or regions
// Define $items array
if ($show_empty_countries == 1) {
	$counter = " AND counter >= %d";
} else {
	$counter = " AND counter > %d";
}

// notice that last argument is ARRAY_A, so we will retrieve array
$query = "SELECT * FROM " . $table_name . " WHERE parent_id = %d AND active = %d " . $counter . " ORDER BY slug ASC";

$countries_and_cities_array = $wpdb->get_results($wpdb->prepare($query, 0, 1, 0), ARRAY_A);


if(count($countries_and_cities_array) == 1){

	$countries_and_cities_array = $wpdb->get_results($wpdb->prepare($query, $countries_and_cities_array[0]['id'], 1, 0), ARRAY_A);

}


if($countries_and_cities_array) {

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	
	$place_url = add_query_arg( array(
		'action' => 'searchprofiles'
	), get_permalink(of_get_option('search_results_page')) );

	if (of_get_option('gender_allowed') != '') {
		$allowed_gender = of_get_option('gender_allowed');
	}
	
	// Add custom Genders
	if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {
		$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

		foreach ($allowed_gender_other_array as $key => $value ){
			$allowed_gender[] = 1;
		}
	}

	$count_genders = count( array_keys( $allowed_gender, 1 )); // count active genders

	$count_items = $count_country = $count_region = $count_city = 0;

	$search_title = '';

	$search_item = 'country';

	foreach($countries_and_cities_array as $key => $value){

		if ($value['level'] == 0) {
			$count_country++;
		} else if ($value['level'] == 1) {
			$count_region++;
		} else if ($value['level'] == 2) {
			$count_city++;
		}

	}

	if($count_country > 0){
		$search_title .= esc_html__( 'Countries', 'datebook' );
		$search_item = 'country';
	} else if($count_region > 0){
		$search_title .= esc_html__( 'Regions', 'datebook' );
		$search_item = 'region';
	} else if($count_city > 0){
		$search_title .= esc_html__( 'Cities', 'datebook' );
		$search_item = 'city';
	}

?>

	<div class="datebook-custom-card card w-100 mb-3 datebook-countries-map">
			<div class="card-body">

				<?php if ($shortcode == 0) { ?>

					<h2 class="datebook-front-title text-center"><span><?php echo esc_html($search_title); ?></span></h2>

				<?php } ?>

				<div class="datebook-countries">
					<div class="row">

					<?php

					foreach($countries_and_cities_array as $key => $value){

						$count_items++;

						$place_id = $value['id'];

						// Country name in database is serialized. Let's unserialized it
						$value['name'] = maybe_unserialize( $value['name'] );

						// if foreign language do not exist, then show title in English (en_US)
						$name = isset($value['name'][DATEBOOK_WPLANG]) ? $value['name'][DATEBOOK_WPLANG] : $value['name']['en_US'];

						if($with_flags == 1){
							$flag_url = isset($value['flag_url']) && $value['flag_url'] != '' ? $value['flag_url'] : DATEBOOK_URL . 'assets/images/flags/' . $value['slug'] . '.svg';
							$county_flag = '<img class="mr-1 datebook-country-flag-icon" src="' . esc_url($flag_url) . '" alt="' . $name .'" width="20" height="20"  /> ';
						} else {
							$county_flag = '';
						}

						// Option 1 - Fast Profile Links
						if ($genders == 1) {

							echo '<div class="col-6 col-lg-3 col-md-3 col-sm-3 mb-3 datebook-subcountry datebook-subcountry-header">';
							// show country name
							echo '<h6>' . $county_flag . '<a class="datebook-subcountry" href="'.esc_url($place_url.'&'.$search_item.'='.$place_id).'">'.esc_attr($name).'</a> ';

							if ($quantity == 1) {
								echo '<span class="text-muted small">' . $value['counter'] . '</span>';
							}

							echo '</h6>';

							// show fast women / men gender links
							if(isset($datebook_gender_titles) && is_array($datebook_gender_titles) && !empty($datebook_gender_titles)){
								foreach ($datebook_gender_titles as $gender => $gender_name) {

									if(isset($allowed_gender[$gender]) && $allowed_gender[$gender] == 1){

										if ($gender == 1) {
											$gender_class = 'fa fa-venus';
											$gender_title = esc_html__( 'Women', 'datebook' );
											$gender_img = 1;
										} else if ($gender == 2) {
											$gender_class = 'fa fa-mars';
											$gender_title = esc_html__( 'Men', 'datebook' );
											$gender_img = 1;
										} else {
											$gender_class = '';
											$gender_title = esc_html__( $gender_name, 'datebook' );
											$gender_img = 0;
										}

										if ($gender_img == 0) {
											echo '<a class="small grey-text btn-gender" href="'.esc_url($place_url.'&'.$search_item.'='.$place_id.'&gender='.$gender).'" title="'.esc_attr($gender_title).'">' . esc_attr($gender_title) . '</a> ';
										} else {
											echo '<a class="small grey-text btn-gender" href="'.esc_url($place_url.'&'.$search_item.'='.$place_id.'&gender='.$gender).'" title="'.esc_attr($gender_title).'">';
											echo '<i class="'.esc_attr($gender_class).' mr-1"></i>';
											echo esc_attr($gender_title);
											echo '</a> ';
										}
									}
								}
							}

							echo '</div>';

						} else {

							// Option 2 - No fast women / men gender links
							echo '<div class="col-lg-3 col-md-3 col-sm-3 mb-2 datebook-subcountry-noheader">';
							echo $county_flag . '<a class="datebook-subcountry" href="'.esc_url($place_url.'&'.$search_item.'='.$place_id).'">'.esc_attr($name).'</a>';
							echo '</div>';

						}

						if ($count_items % 4) { } else {
							echo '<div class="datebook-clear5 visible-md-block visible-sm-block visible-lg-block"></div>';
						}

					}

					?>

					</div>
				</div>
			</div>
		</div>

<?php }