<?php
/**
 * The default template for displaying Matching percent table
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


global $wpdb, $datebook_field_titles;

if ($display_matching_place == 1 || $display_matching_place == 3) {

?>

<div class="datebook-custom-card card border border-primary shadow-0 w-100 mb-3 datebook-profile-matching">
	<div class="card-body">
		<h5 class="card-title"><?php echo esc_html__( 'This member matches your profile', 'datebook' ); ?>: <?php echo absint($percent_friendly); ?>%</h5>

		<?php if ($split_progress_on_levels == 1) { ?>

		<div class="progress">
			<div class="progress-bar" role="progressbar" style="width: <?php echo absint($percent_friendly); ?>%;" aria-valuenow="<?php echo absint($percent_friendly); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo absint($percent_friendly); ?>%</div>
		</div>

		<?php

		} else if ($split_progress_on_levels == 2) {

			if($percent_friendly >= $matching_level_excellent){
				$percent_friendly = $percent_friendly;
				$percent_class = 'bg-success';
			} else if($percent_friendly >= $matching_level_very_good){
				$percent_friendly = $percent_friendly;
				$percent_class = '';
			} else if($percent_friendly >= $matching_level_good){
				$percent_friendly = $percent_friendly;
				$percent_class = 'bg-info';
			} else if($percent_friendly >= $matching_level_fair){
				$percent_friendly = $percent_friendly;
				$percent_class = 'bg-warning';
			} else {
				$percent_friendly = $percent_friendly;
				$percent_class = 'bg-danger';
			}

			?>

			<div class="progress">
				<div class="progress-bar <?php echo esc_attr($percent_class); ?>" role="progressbar" style="width: <?php echo absint($percent_friendly); ?>%" aria-valuenow="<?php echo absint($percent_friendly); ?>" aria-valuemin="0" aria-valuemax="100"></div>
			</div>

		<?php } else { ?>

			<?php if($percent_friendly == 0){ ?>

			<div class="progress">
				<div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
			</div>

			<?php } else { ?>

			<div class="progress">
				<div class="progress-bar" role="progressbar" style="width: <?php echo absint($percent_friendly); ?>%" aria-valuenow="<?php echo absint($percent_friendly); ?>" aria-valuemin="0" aria-valuemax="100"></div>
			</div>
			
			<?php } ?>

		<?php } ?>

	</div>
</div>

<?php } else if ($display_matching_place == 2) { ?>

	<span class="btn btn-outline-primary rounded m-0 p-1 float-right shadow-none" title="<?php echo esc_html__( 'This member matches your profile', 'datebook' ); ?>: <?php echo absint($percent_friendly); ?>%" data-toggle="tooltip" data-placement="top" data-original-title="<?php echo esc_html__( 'This member matches your profile', 'datebook' ); ?>: <?php echo absint($percent_friendly); ?>%">
		<?php echo absint($percent_friendly); ?>%
	</span>

<?php }