<?php
/**
 * Create pages for Classified ads displayed by category on Classifieds page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-classifieds' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-classifieds' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="datebook-custom-card card mb-3 datebook-classifieds-page">
			<div class="card-body">

				<?php echo DateBook_Classifieds_Page::return_classifieds_page(); ?>

			</div>
		</div>
	</div>
	
	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>
	
	<div class="col-lg-3 col-md-3 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-classifieds' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-classifieds');
			}
			
			?>

		</div>
	</div>
	
	<?php endif; ?>

</div>
<!-- /content -->