<?php
/**
 * Primary menu
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$datebook_navbar_toggler_align = 'm-auto';

if($is_front_page == 1 && of_get_option('primary_menu_align_front') == 'right' || ($is_front_page == 0 && of_get_option('primary_menu_align_other') == 'right')){
	$primary_menu_align = ' ml-auto';
} else if(($is_front_page == 1 && of_get_option('primary_menu_align_front') == 'center') || ($is_front_page == 0 && of_get_option('primary_menu_align_other') == 'center')){
	$primary_menu_align = ' m-auto';
} else if(($is_front_page == 1 && of_get_option('primary_menu_align_front') == 'left') || ($is_front_page == 0 && of_get_option('primary_menu_align_other') == 'right')){
	$primary_menu_align = ' mr-auto';
} else {
	$primary_menu_align = ' m-auto';
}

$logo_insidemenu_exists = (($is_front_page == 1 && of_get_option( 'logo_position_front' ) == 'insidemenu') || ($is_front_page == 0 && of_get_option( 'logo_position_other' ) == 'insidemenu')) ? 1 : 0;

$primary_menu_exists = (has_nav_menu('datebook-primary-menu-' . DATEBOOK_WPLANG)) ? 1 : 0;

$use_menu_exists = (($is_front_page == 1 && of_get_option( 'user_menu_position_front' ) == 'inprimarymenu') || ($is_front_page == 0 && of_get_option( 'user_menu_position_other' ) == 'inprimarymenu')) ? 1 : 0;


if ($logo_insidemenu_exists == 1 || $primary_menu_exists == 1 || $use_menu_exists == 1) {

	$return_user_menu = '';
	if ($use_menu_exists == 1) {
		$return_user_menu = DateBook_Menu::return_user_menu();
	}

?>

<div class="datebook-primary-menu-container">
	<nav class="navbar navbar-expand-lg navbar-dark shadow-none datebook-primary-menu-subcontainer<?php echo esc_attr($primary_menu_align); ?>">
		<div class="container">

		<?php if ($logo_insidemenu_exists == 1) {
		
			include DateBook_Template_Loader::locate( 'pages/header-logo' );
		
			$datebook_navbar_toggler_align = '';
		}
	
		if ($primary_menu_exists == 1) {

		?>

			<button class="navbar-toggler pl-3 pr-3 <?php echo esc_attr($datebook_navbar_toggler_align); ?>" type="button" data-toggle="collapse" data-target="#navbarPrimarymenu" aria-controls="navbarPrimarymenu" aria-expanded="false" aria-label="<?php esc_html_e( 'Menu', 'datebook' ); ?>"><i class="fas fa-bars"></i></button>

			<div class="collapse navbar-collapse datebook-primary-menu-class" id="navbarPrimarymenu">

			<?php

			wp_nav_menu(array(
				'theme_location'  => 'datebook-primary-menu-' . DATEBOOK_WPLANG,
				'container'       => 'div',
				'container_id'    => 'datebook-primary-menu-' . DATEBOOK_WPLANG,
				'container_class' => 'datebook-primary-menu',
				'menu_id'         => false,
				'menu_class'      => 'navbar-nav m-auto',
				'depth'           => 2,
				'fallback_cb'     => 'bs4navwalker::fallback',
				'walker'          => new bs4navwalker()
			));

			?>

			</div>
		
		<?php }

		if ($use_menu_exists == 1) {

			echo '<span class="d-none d-lg-block datebook-user-menu-small">';
			echo $return_user_menu;
			echo '</span>';

		}

		?>

		</div>
	</nav>

	<?php

	if ($use_menu_exists == 1) {

		echo '<span class="d-block d-lg-none">';
		echo $return_user_menu;
		echo '</span>';

	}

	?>
	
</div>

<?php }