<?php
/*
 * Profile Messages Menu
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

$page_id = absint(get_the_ID());

?>

<!-- Nav tabs -->
<div class="datebook-profilepage">

	<ul class="nav nav-pills datebook-standard-tabs datebook-profile-tabs datebook-message-tabs" id="pills-tab" role="tablist">

		<li class="nav-item"><a class="nav-link<?php if ($page_id == of_get_option('my_messages_page')) {echo ' active'; } ?>" href="<?php echo esc_url(get_permalink(of_get_option('my_messages_page')));?>"><?php echo esc_html__( 'Contacts', 'datebook' );?> <span class="badge badge-pill badge-light shadow-none datebook-badge-info datebook-messages-counter"><?php echo absint($allowed_contacts); ?></span></a> </li>

		<?php

		$enable_favorite_profiles = of_get_option('enable_favorite_profiles');

		if (isset($enable_favorite_profiles['1']) && $enable_favorite_profiles['1'] == '1'){

		?>

		<li class="nav-item"><a class="nav-link<?php if ($page_id == of_get_option('my_favorites_page')) {echo ' active'; } ?>" href="<?php echo esc_url(get_permalink(of_get_option('my_favorites_page'))); ?>"><?php echo esc_html__( 'Favorites', 'datebook' );?> <span class="badge badge-pill badge-light shadow-none datebook-badge-info datebook-favorite-counter"><?php echo absint($favorite_contacts);?></span></a></li>

		<?php } ?>

		<?php if (of_get_option('enable_blacklisted_profiles') == '1') { ?>

			<li class="nav-item"><a class="nav-link<?php if ($page_id == of_get_option('my_blacklist_page')) {echo ' active'; } ?>" href="<?php echo esc_url(get_permalink(of_get_option('my_blacklist_page'))); ?>"><?php echo esc_html__( 'Blacklist', 'datebook' );?> <span class="badge badge-pill badge-light shadow-none datebook-badge-info datebook-blacklist-counter"><?php echo absint($blacklist_contacts); ?></span></a></li>

		<?php } ?>

	</ul>
</div>

<div class="datebook-clear20"></div>

<p><?php echo esc_attr($what_message_text); ?></p>