<?php
/*
 * Verification form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_field_titles, $datebook_alert_error, $datebook_alert_text, $datebook_image_sizes;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

?>

<div class="datebook-custom-card card">
	<div class="card-body">

	<h2><?php echo esc_html__('Verification', 'datebook'); ?></h2>
	
	<hr />

	<div class="mb-3 datebook-photocontainer">

		<?php if (is_user_logged_in()) { ?>

		<div class="datebook-upload-photos-form tooltip-demo">

			<p><?php echo esc_html__( 'Increase the credibility of your account. It is recommended to upload a copy of your passport, state ID, driver\'s license or homemade photo. You must have in your hands a paper with the words', 'datebook' ); ?> "<?php bloginfo('name'); ?>".</p>
			<p><?php echo esc_html__( 'After verification, your profile will get the "Verified" status.', 'datebook' ); ?></p>
			<p><?php echo esc_html__( 'All photos are private and will not be published!', 'datebook' ); ?></p>

			<div class="card border mb-3 datebook-transparent">
				<div id="datebook-images-panel" class="card-body">

					<p>

					<?php esc_html_e( 'You can upload 1 photo only', 'datebook' ); ?>. 
					
					<?php

					if ( !function_exists( 'wp_max_upload_size' ) ) {
						require_once ABSPATH . WPINC . '/media.php';
					}
					
					$datebook_max_upload_size = of_get_option('allowed_max_image_size') > 0 ? absint(of_get_option('allowed_max_image_size')) : wp_max_upload_size();
					
					echo 'Max image size: ' . esc_attr(size_format($datebook_max_upload_size));
					
					$datebook_allowed_extensions = of_get_option('allowed_file_extensions') ? esc_attr(of_get_option('allowed_file_extensions')) : '';
				
					if ( $datebook_allowed_extensions ) {

						echo ' <span class="badge badge-pill badge-info" data-toggle="tooltip" data-placement="right" data-original-title="' . esc_html__( 'Allowed image extensions', 'datebook' ) . ': ' . $datebook_allowed_extensions . '">?</span>';

					}
					
					?>
					
					</p>

					<hr />

					<form id="datebook-imageform" enctype="multipart/form-data" name='imageform' method="post" action="<?php echo esc_url(get_permalink(of_get_option('my_verification_page'))); ?>">

						<input id="datebook-realphoto" type="hidden" name="realphoto" value="1" />
						<input type="hidden" name="datebook_image_upload" value="upload" />

						<div class="input-group mb-3">
							<div class="custom-file">
								<input type="file" class="custom-file-input datebook-file datebook-image-submit" id="datebook-images" name="images">
								<label class="custom-file-label" for="datebook-images" aria-describedby="datebook-fileaddon"><?php esc_html_e( 'Select an image', 'datebook' ); ?></label>
							</div>
							<div class="input-group-append">
								<button id="datebook-fileaddon" class="input-group-text btn-primary border-0" type="submit" name="datebook_image_upload"><?php esc_html_e( 'Upload', 'datebook' ); ?></button>
							</div>
						</div>

					</form>

					<div class="datebook-clear10"></div>

					<div id="datebook-uploaded-images" class="progress">
						<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="display: none; width: 100%" id="datebook-loader"><?php esc_html_e( 'Image uploading ...', 'datebook' ); ?></div>
					</div>
				
					<div id="datebook-error-div"> </div>

					<div class="datebook-clear20"></div>

					<div class="datebook-img-popup"></div>

					<?php

					$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );							

					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					$verification_phototitle = isset($datebook_get_data[DATEBOOK_VERIFICATION_CONFIRM_PHOTO]) ? $datebook_get_data[DATEBOOK_VERIFICATION_CONFIRM_PHOTO] : 0;

					if ($verification_phototitle > 0) {

						$post = get_post($verification_phototitle);

						$upload_folder = isset($datebook_get_data['upload_folder']) ? $datebook_get_data['upload_folder'] : '';

						$upload_dir = wp_upload_dir();
						$targetPath = $upload_dir['basedir'] . '/' . $upload_folder . '/' . $post->post_title;

						$photo_url = explode('.', $post->post_title);

						$thumbnail_url = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_profile']['width'] . 'x' . $datebook_image_sizes['image_profile']['height']) . '.' . $photo_url[1];

						if (!file_exists($upload_dir['basedir'] . '/' . $upload_folder . '/' . $thumbnail_url)) {
							$image = wp_get_image_editor($targetPath);
							if ( ! is_wp_error( $image ) ) {
								$image->resize( $datebook_image_sizes['image_profile']['width'], $datebook_image_sizes['image_profile']['height'], true );
								$image->save($upload_dir['basedir'] . '/' . $upload_folder . '/' . $thumbnail_url);
							}
						}

						$big_thumbnail_url = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'] . 'x' . $datebook_image_sizes['image_big']['height']) . '.' . $photo_url[1];

						if (!file_exists($upload_dir['basedir'] . '/' . $upload_folder . '/' . $big_thumbnail_url)) {
							$image = wp_get_image_editor($targetPath);
							if ( ! is_wp_error( $image ) ) {
								$image->resize( $datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height'], true );
								$image->save($upload_dir['basedir'] . '/' . $upload_folder . '/' . $big_thumbnail_url);
							}
						}

						$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_url;
						$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url;


						echo '<div id="' . absint($post->ID) . '" class="datebook-verificationphoto">';
						echo '<span class="">';
						echo '<a class="datebook-frontphoto d-inline-block" href="' . esc_url($big_thumbnail_url) . '" data-lightbox="example-1" data-gallery=""><img class="thumbnail" src="' . esc_url($thumbnail_url) . '" alt="" width="' . esc_attr($datebook_image_sizes['image_profile']['width']) . '" height="' . esc_attr($datebook_image_sizes['image_profile']['height']) . '" /></a>';
						echo '<div class="datebook-clear5"></div>';
						echo '<input type="hidden" id="datebook-img-single-id" value="' . absint($post->ID) . '" />';
						echo '<input type="button" class="btn btn-sm btn-grey" name="img_real_id" id="datebook-img-real-id" value="' . esc_html__( 'Delete', 'datebook' ) . '" />';
						echo '</span>';
						echo '</div>'."\n";

					} ?>

				</div>
			</div>
		</div>

		<?php

		} else {

			esc_html_e( 'You need to login or register to upload photos', 'datebook' );

		}
		?>

	</div>
</div>
</div>