<?php
/*
 * Panel under the Search form that offers to select Subsciption plan
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h2><?php esc_html_e( 'Select a subscription plan', 'datebook' ); ?>!</h2>

		<hr />

		<div class="row">
			<div class="col-lg-7 col-md-7 col-sm-7">

				<?php

				global $period_list_array;

				$subscription_ends = DateBook_Utilities::datebook_date_i18n(2, strtotime('+' . $period_long_number_top_position . ' ' . $period_list_array[$period_long_top_position], time()), false);

				echo '<p>';
				echo esc_html__( 'Your profile will be placed in Top position until', 'datebook' ) . ' ' . esc_attr($subscription_ends);
				echo '</p>';
			
				?>

				<form method="post" action="<?php echo esc_url(get_permalink(of_get_option('my_upgrade_page'))); ?>" target="_top">
					<input type="hidden" name="action" value="payment_page">
					<input type="hidden" name="payment_page" value="2">
					<input type="hidden" name="subscriptionplan" value="<?php echo esc_attr($value['slug']); ?>">

					<p>

					<?php

					if(isset($value['price']) && is_array($value['price'])) {

						echo '<select name="subscriptionplan_price">';

						foreach($value['price'] as $key => $price){

							$value['price'] = isset($price) && $price > 0 ? DateBook_Profile_Subscription::datebook_format_money($price) : esc_html__( 'Free', 'datebook' );

							echo '<option value="' . $key . '">';

							echo esc_attr($value['price']);

							if(isset($value['register_period'][$key]) && is_array($value['register_period'])) {

								$register_period_out = isset($value['register_period_number'][$key]) && $value['register_period_number'][$key] > 0 ? DateBook_Utilities::datebook_plural_text($value['register_period_number'][$key], $value['register_period'][$key]) : esc_html__( 'Unlimited', 'datebook' );

								echo ' - ' . esc_attr($register_period_out);

							}

							echo '</option>';

						}

						echo '</select>';

					}

					?>

					</p>

					<div class="datebook-clear5"></div>

					<?php 

					echo '<button type="submit" name="submit" class="btn btn-primary">' . esc_html__( 'Select', 'datebook' ) . '</button>';

					?>

				</form>

			</div>
		</div>
	</div>
</div>