<?php
/*
 * Search form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$datebook_topsuggest_bg = '';

$bg_topsuggest_image = of_get_option('bg_topsuggest_image');

if ($bg_topsuggest_image) {

	$datebook_topsuggest_bg = 'style="background: #000 url(' . esc_url($bg_topsuggest_image) . ') no-repeat center center; background: -ms-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -moz-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -o-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-gradient(linear, left top, left bottom, color-stop(0, rgba(0, 0, 0, 0.1)), color-stop(100, rgba(255, 255, 255, 0.4))) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: linear-gradient(to bottom, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover;}"';
			
}

?>

<div class="datebook-custom-card card card-image text-white border-0 mb-3" <?php echo $datebook_topsuggest_bg; ?>>

	<div class="card-body" style="max-width: 80%;">

		<h5 class="card-title mb-0"><?php esc_html_e( 'Move your profile to Top position', 'datebook' ); ?> <button class="btn btn-sm btn-info p-1 pl-3 pr-3" type="button" data-toggle="collapse" data-target="#collapseTopOfferOnSearch" aria-expanded="false" aria-controls="collapseTopOfferOnSearch"><?php esc_html_e( 'show', 'datebook' ); ?></button></h5>
		<div class="collapse mt-3" id="collapseTopOfferOnSearch">
			<h6 class="card-subtitle mb-2"><?php esc_html_e( 'You can attract more attention to your profile by moving it to Top Position. It will appear at the top of search results.', 'datebook' ); ?></h6>
			<p><?php esc_html_e( 'Visit your subsciption panel and select some Subscription plan which includes Top position feature.', 'datebook' ); ?></p>
			<a href="<?php echo esc_url(get_permalink(of_get_option('my_upgrade_page'))); ?>" class="btn btn-sm btn-primary"><?php esc_html_e( 'Go to Subscription panel', 'datebook' ); ?></a>
		</div>

	</div>
</div>