<?php
/**
 * Template part for displaying Tour page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

?>

<div class="datebook-custom-card card mb-3 datebook-search-front">
	<div class="card-header">

		<h3 class="datebook-label-title"><?php esc_html_e( 'Show tours', 'datebook' ); ?></h3>

	</div>
	<div class="card-body">

		<form action="<?php echo esc_url(get_permalink(get_the_ID())); ?>" method="post">
			<div class="form-row">
				<div class="col-lg-7 col-md-7 col-sm-12 pt-2 pb-2">
					<div class="btn-group d-flex btn-group-toggle" data-toggle="buttons">
				
					<?php

					$search_period = 0;
					if (isset($_REQUEST['period'])) {
						$search_period = sanitize_text_field($_REQUEST['period']);
					}

					foreach ($datebook_tours_happening_titles as $key => $period_name) {

						$period_selected = '';
						$period_checked = '';
						$period_icon = '';

						if ($key == 1) {
							$period_icon = 'fa-suitcase';
						} else if ($key == 2) {
							$period_icon = 'fa-clock';
						}

						if ($search_period > 0) {

							if ($key == $search_period) {
								$period_selected = ' active';
								$period_checked = 'checked';
							}

						} else {

							if ($key == 1) {
								$period_selected = ' active';
								$period_checked = 'checked';
							} else if ($key == 2) {
								$period_selected = '';
								$period_checked = '';
							}
						}

						echo '<label class="btn btn-sm btn-secondary w-100 '.esc_attr($period_selected).'"><i class="fa '.esc_attr($period_icon).' fa-lg mr-2"></i> <input type="radio" name="period" value="'.sanitize_key($key).'" '.esc_attr($period_checked).' /> '.esc_html__( $period_name, 'datebook' ) . '</label>';

					}

					?>

					</div>
				</div>

				<div class="col-lg-3 col-md-3 col-sm-12 pt-3 pb-2">

					<?php

					$search_countrycity = '';
					$city_id = '';
					$region_id = '';
					$country_id = '';

					$search_location = 0;

					if(isset($_REQUEST['city']) && $_REQUEST['city'] > 0){
						$search_location = $_REQUEST['city'];
						$deep_level = 1;
					} else if(isset($_REQUEST['region']) && $_REQUEST['region'] > 0){
						$search_location = $_REQUEST['region'];
						$deep_level = 2;
					} else if(isset($_REQUEST['country']) && $_REQUEST['country'] > 0){
						$search_location = $_REQUEST['country'];
						$deep_level = 3;
					}

					if($search_location > 0){

						$term_data = DateBook_Utilities::datebook_get_term_by('id', $search_location, $deep_level);

						$city_title = isset($term_data->city) ? $term_data->city : '';
						$city_id = isset($term_data->city_id) ? $term_data->city_id : '';

						$region_title = isset($term_data->region) ? $term_data->region : '';
						$region_id = isset($term_data->region_id) ? $term_data->region_id : '';

						$country_title = isset($term_data->country) ? $term_data->country : '';
						$country_id = isset($term_data->country_id) ? $term_data->country_id : '';

						if ($city_title){
							$search_countrycity .= $city_title . ', ';
						}

						if ($region_title){
							$search_countrycity .= $region_title . ', ';
						}

						if ($country_title){
							$search_countrycity .= $country_title;
						}

					}

					$search_countrycity = (isset($_REQUEST['countrycity']) ? $_REQUEST['countrycity'] : esc_html__( 'Location', 'datebook' ));
					$search_country = (isset($_REQUEST['country']) ? $_REQUEST['country'] : null);
					$search_region = (isset($_REQUEST['region']) ? $_REQUEST['region'] : null);
					$search_city = (isset($_REQUEST['city']) ? $_REQUEST['city'] : null);
					
					$show_empty_countries = of_get_option('search_show_empty_countries') ? 1 : 0;

					?>

					<input id="datebook-locationcountry" name="country" type="hidden" value="<?php echo esc_attr($search_country);?>" />
					<input id="datebook-locationregion" name="region" type="hidden" value="<?php echo esc_attr($search_region);?>" />
					<input id="datebook-locationcity" name="city" type="hidden" value="<?php echo esc_attr($search_city);?>" />

					<input id="datebook-onecountry" name="onecountry" type="hidden" value="0" />

					<input id="datebook-location" class="form-control form-control-sm" type="text" name="countrycity" value="<?php echo esc_attr($search_countrycity);?>" aria-label="<?php esc_html_e( 'Location', 'datebook' ); ?>" data-toggle="modal" data-target="#dbmodalcountriespanel" placeholder="<?php esc_html_e( 'Location', 'datebook' ); ?>" all-locations="<?php echo esc_attr($show_empty_countries); ?>" post-type="tour" readonly />

					<?php echo DateBook_Search::datebook_countries_popup('tour', $show_empty_countries, 0, 'tour'); ?>

				</div>

				<div class="col-lg-2 col-md-2 col-sm-12 pt-3 pb-2">

					<button type="submit" class="btn btn-sm btn-warning btn-block m-0 btn-search"><?php esc_html_e( 'Search', 'datebook' ); ?></button>

				</div>
			</div>

		</form>

	</div>
</div>