// Detect visitor's timezone and set a cookie
function setCookie(cname, cvalue, exdays) {
	var d = new Date();
	d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
	var expires = "expires="+d.toUTCString();
	document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
	var name = cname + "=";
	var ca = document.cookie.split(';');
	for(var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') {
			c = c.substring(1);
		}
		if (c.indexOf(name) == 0) {
			return c.substring(name.length, c.length);
		}
	}
	return "";
}

function checkCookie() {
	var timezone_offset_minutes = getCookie("datebook_visitor_timezone_set");
	if (timezone_offset_minutes == "") {
		var timezone_offset_minutes = new Date().getTimezoneOffset();
		// Timezone difference in minutes such as 330 or -360 or 0
		timezone_offset_minutes = timezone_offset_minutes == 0 ? 0 : -timezone_offset_minutes;
		if (timezone_offset_minutes != "" && timezone_offset_minutes != null) {
			setCookie("datebook_visitor_timezone_set", timezone_offset_minutes, 1);
		}
	}
}
checkCookie();

// Show Social buttons on Profile page
function datebook_socialbutton(url, website) {

	"use strict";

	if (website === "twitter") {
		window.open(url, "socialwindow", "height=300,width=500,resizable=1,scrollbars=yes");
		} else {
		window.open(url, "socialwindow", "height=500,width=800,resizable=1,scrollbars=yes");
	}
}
function datebook_pinterestbutton() {

	"use strict";

	var e = document.createElement('script');
	e.setAttribute('type', 'text/javascript');
	e.setAttribute('charset', 'UTF-8');
	e.setAttribute('src', '//assets.pinterest.com/js/pinmarklet.js?r=' + Math.random() * 99999999);
	document.body.appendChild(e);
}



jQuery(document).ready(function($) {

	"use strict";
	
	// Check quantity of days in month in registration form
	$(document).on('change', '#datebook-dateday, #datebook-datemonth, #datebook-dateyear', function() {

		var day = $('#datebook-dateday').val();
		var month = $('#datebook-datemonth').val();
		var year = $('#datebook-dateyear').val();

		var days = new Date(year, month, 0).getDate();
		
		if(day > days){

			$('#datebook-dateday').prop('selectedIndex', '');

		}

	});

	
	$(document).mouseup(function (e) {
		var popup = $(".js-irs-0");
		if (!$('#datebook-agebox').is(e.target) && !$('#datebook-agerange').is(e.target) && !popup.is(e.target) && popup.has(e.target).length === 0) {
			popup.fadeOut(300);
		}
	});


	// Show profile details when mouse hover on Search page
	$(document).on('mouseenter mouseleave', '.datebook-profiles', function() {
		$(this).find('.datebook-search-profile-body.over').slideToggle('slow');
	});
	
	$(document).on('click', '.datebook-search-profile-body', function() {
		window.location = $(this).find("a").attr("href");
		return false;
	});


	// Show Chat Form on Profile page
	$(document).on('click', '#datebook-chatpopup', function() {

		var windowObjectReference = null;

		var w = datebook_chat_window.datebook_chat_width;
		var h = datebook_chat_window.datebook_chat_height;

		var left = (screen.width/2)-(w/2);
		var top = (screen.height/2)-(h/2);
		var strWindowFeatures = 'left='+left+',top='+top+',screenX=100,screenY=100,width='+w+',height='+h+',resizable,scrollbars,status';

		var strWindowName = 'datebookchat';

		var strUrl = $(this).attr('href');

		if(windowObjectReference === null || windowObjectReference.closed) {
			windowObjectReference = window.open(strUrl, strWindowName, strWindowFeatures);
			windowObjectReference.focus();
		} else {
			windowObjectReference.focus();
		}

	});


	$(document).on('click', '.datebook-emailpopup', function() {
		$('#datebook-profilecontact').slideToggle('fast');
		$(this).toggleClass("act");
		if ($(this).hasClass('act')) {
			$(this).find('span').html('&#x25B2;');
		} else {
			$(this).find('span').html('&#x25BC;');
		}
	});


	// Limit Characters in Profile desciption on Profile page
	$(document).on('click', '.datebook-openabout', function() {
		$( "#datebook-mainaboutme" ).toggleClass('datebook-main-reveal datebook-main-unreveal');
	});
	$(document).on('click', '.datebook-closeabout', function() {
		$( "#datebook-mainaboutme" ).toggleClass('datebook-main-unreveal datebook-main-reveal');
	});
	

	// Limit Characters in Comment Form on Profile page
	$("#datebook-comment-description").keyup(function() {
		var charlimit = 400;
		var box = $(this).val();
		var main = box.length * 100;
		var value = (main / charlimit);
		var count = charlimit - box.length;
		var boxremove = box.substring(0, charlimit);
		var ourtextarea = $(this);
		
		if (box.length <= charlimit) {
			$('#datebook-count').html(count + " characters left");
			$("#datebook-comment-description");
			$('#datebook-progressslide').animate({
				"width": value + '%'
				},
			1);
		} else {
			$('#datebook-comment-description').val(boxremove);
			ourtextarea.scrollTop(ourtextarea[0].scrollHeight - ourtextarea.height());
		}
		
		return false;
	});
	
	$('.form-control').each(function() {
		$(this).keyup(function() {

			var charlimit = $(this).parent().parent().find('.label').attr('data-textlimit');

			if(charlimit > 0){

				var box = $(this).val();
				var count = charlimit - box.length;
				var boxremove = box.substring(0, charlimit);
				var ourtextarea = $(this);

				if (box.length <= charlimit) {
					$(this).parent().parent().find('.label').html(count);
				} else {
					$(this).val(boxremove);
					ourtextarea.scrollTop(ourtextarea[0].scrollHeight - ourtextarea.height());
				}
			}
		
			return false;

		});
	});


	// Prevent from double registration
	$('form#datebook-registration-form').on('submit', function() {
		$('button[type=submit]', this).attr('disabled', 'disabled');
	});


	// Set cookie for language
	function datebook_language(value) {

		var name = 'datebook_language';
		var expires = '';
		var days = 365;

       	var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
   	    expires = "expires=" + date.toUTCString();
    	document.cookie = name + "=" + value + ";" + expires + "; path=/";
		
		location.reload();
	
	}

	// Change language in dropdown
	$(document).on('change', '#datebook-language', function() {

		var value = $(this).val();

		datebook_language(value);

	});

	// Change language in list
	$(document).on('click', '.datebook-language', function() {

		var value = $(this).attr('data-id');

		datebook_language(value);

	});

	
	// Confirmation modal window
	$(document).on('click', '.datebook-confirm-action', function() {

		var id = $(this).attr('profile-id');
		var title = $(this).attr('title');
		var confirmtext = $(this).attr('confirmtext');
		var canceltext = $(this).attr('canceltext');
		var doaction = $(this).attr('do-action');
		var whatpage = $(this).attr('what-page');

		var htmlpanel = '';

		if(title){

			htmlpanel += '<div class="white p-3 datebook-popup-animate fadeInDown shadow-lg rounded text-center">';
			htmlpanel += '<div class="datebook-popup-title p-3">' + title + '</div>';
			htmlpanel += '<div class="datebook-popup-text">';

			htmlpanel += '<a class="btn btn-primary ' + doaction + '" data-profile-id="' + id + '" data-whatpage="' + whatpage + '" onClick="return false;" href="javascript:void(0)">' + confirmtext + '</a>';
			htmlpanel += '<a onClick="return false;" href="javascript:void(0)" class="btn btn-light">' + canceltext + '</a>';

			htmlpanel += '</div>';
			htmlpanel += '</div>';

		}

		DateBook.popup({
			position: 'top center',
			displayDelay: true,
			closeButton: false,
			closeOnClick: true,
			onClickUrl: '',
			sound: false,
			img: '',
			title: '',
			msg: '',
			divpanel: htmlpanel
		});

	});


	// drag
	var swiper = new Swiper('.swiper-container', {
		slidesPerView: 'auto',
		preventClicks: true,
		spaceBetween: 0,
		grabCursor: true,
		freeMode: true,
	});

	$(document).ready(function() {
		$("#datebook_show_password a").on('click', function(event) {
			event.preventDefault();
			if($('#datebook_show_password input').attr('type') === 'text'){
				$('#datebook_show_password input').attr('type', 'password');
				$('#datebook_show_password i').addClass('fa-eye-slash');
				$('#datebook_show_password i').removeClass('fa-eye');
			}else if($('#datebook_show_password input').attr('type') === 'password'){
				$('#datebook_show_password input').attr('type', 'text');
				$('#datebook_show_password i').removeClass('fa-eye-slash');
				$('#datebook_show_password i').addClass('fa-eye');
			}
		});
	});


	// Reset the search form fields
	$(document).on('click', '.datebook-reset-search', function() {

		$('#datebook-search-form').trigger("reset");
		
		//click Deselect All genders in Search form
		$('.bs-deselect-all').click();
		
		// For any case, empty region and city fields
		$("#datebook-locationcity").val('');
		$("#datebook-locationregion").val('');
		$("#datebook-locationcountry").val('');
		$("#datebook-location").val('');
		
		$(".datebook-search-gender").removeClass("active"); // Removes active class
		$('.datebook-gender').prop('checked', false); // Unchecks it

	});
	
	
});