<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Forms
 *
 * @class DateBook_Forms
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Forms {

	/**
	 * Get all custom fields
	 *
	 */
	public static function get_all_custom_fields($fieldvalue, $whatform = 'profile_form') {

		global $wp_locale_all, $datebook_reserved_fields;

		// get languages
		$languages_array = array();

		$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

		$languages = DateBook_Localization::datebook_all_available_language_files();

		foreach($languages as $language) {
			if($language['checked'] == 1){
				$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
			}
		}

		// Get custom fields
		$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

		// Get taxonomy
		$datebook_profiletypes = array();
		$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
		foreach ($profiletypes_array as $key => $value ){
			$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
		}
		$profiletypes = implode("\r\n", $datebook_profiletypes);

		foreach ($all_custom_fields as $key => $value) {
			if(isset($datebook_reserved_fields[$key])){
				$datebook_reserved_fields[$key] = array(
					'slug' => $key, 
					'type' => $whatform == 'search_form_other' && isset($datebook_reserved_fields[$key]['type_search']) && !empty($datebook_reserved_fields[$key]['type_search']) ? $datebook_reserved_fields[$key]['type_search'] : $datebook_reserved_fields[$key]['type'], 
					'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
					'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
					'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
					'active' => isset($value['active']) && $value['active'] > 0 ? 1 : (isset($key) ? 0 : (isset($datebook_reserved_fields[$key]['active']) && $datebook_reserved_fields[$key]['active'] > 0 ? 1 : 0)),
					'limittext' => $value['limittext']
				);

				foreach ( $languages_array as $language_key => $language_name ) {

					$value_name = $whatform == 'search_form_other' && isset($value['name_search_' . $language_key]) && !empty($value['name_search_' . $language_key]) ? 'name_search_' . $language_key : (isset($value['name_' . $language_key]) && !empty($value['name_' . $language_key]) ? 'name_' . $language_key : 'name_en_US');

					if (isset($value_name)) {
						$datebook_reserved_fields[$key][$value_name] =  $value[$value_name];
					}

					$value_field_items = $whatform == 'search_form_other' && isset($value['field_items_search_' . $language_key]) && !empty($value['field_items_search_' . $language_key]) ? 'field_items_search_' . $language_key : (isset($value['field_items_' . $language_key]) && !empty($value['field_items_' . $language_key]) ? 'field_items_' . $language_key : 'field_items_en_US');

					if (isset($value_field_items)) {
						if($key == 'profiletypereserved'){
							$datebook_reserved_fields[$key][$value_field_items] =  $profiletypes;
						} else {
							$datebook_reserved_fields[$key][$value_field_items] =  $value[$value_field_items];
						}
					}
				}
			}
		}

		// Merge custom and reserved fields
		$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);
		
		$get_custom_field_array = isset($get_profile_custom_fields[$fieldvalue]) ? $get_profile_custom_fields[$fieldvalue] : array();

		return $get_custom_field_array;

	}


	/**
	 * Renders fields in custom profile form
	 *
	 */
	public static function render_field_in($whatform, $value, $profile_form_data, $datebook_alert_error_exists = 0, $any_answer = 'no answer') {

		if(is_array($value)){

			$get_user_filled_fields = array();

			if (isset($profile_form_data[$value['slug']]) && isset($_POST[$value['slug']]) && $datebook_alert_error_exists == 1) {
				$get_user_filled_fields = $_POST[$value['slug']];
			} else if (isset($profile_form_data[$value['slug']])) {
				$get_user_filled_fields = $profile_form_data[$value['slug']];
			} else if (isset($_POST[$value['slug']])) {
				$get_user_filled_fields = $_POST[$value['slug']];
			} else if ($value['type'] == 'text' || $value['type'] == 'textarea') {
				$get_user_filled_fields = '';
			}

			// if foreign language do not exist, then show title in English (en_US)
			$value_field_items = $whatform == 'search_form_other' && isset($value['field_items_search_' . DATEBOOK_WPLANG]) && !empty($value['field_items_search_' . DATEBOOK_WPLANG]) ? $value['field_items_search_' . DATEBOOK_WPLANG] : (isset($value['field_items_' . DATEBOOK_WPLANG]) && !empty($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US']);

			$value['field_items'] = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

			$custom_field_data_required = isset($value['required']) && $value['required'] == 1 ? 1 : 0;

			$any_answer_title = $any_answer == 'any' || $whatform == 'search_form_other' ? esc_html__( 'Any', 'datebook' ) : esc_html__( 'No answer', 'datebook' );

			$value['type'] = $whatform == 'search_form_other' && isset($value['type_search']) && !empty($value['type_search']) ? $value['type_search'] : $value['type'];

			switch ( $value['type'] ) {

				case 'text': ?>

					<input name="<?php echo esc_attr($value['slug']); ?>" type="text" value="<?php if (isset($get_user_filled_fields)) { echo esc_textarea($get_user_filled_fields); } ?>" class="form-control" />
                    
				<?php 

				break;

				case 'textarea' : 

				?>

					<textarea id="datebook-<?php echo esc_attr($value['slug']); ?>" name="<?php echo esc_attr($value['slug']); ?>" rows="3" cols="42" class="form-control"><?php if (isset($get_user_filled_fields)) { echo esc_textarea($get_user_filled_fields); } ?></textarea>

				<?php

				break;

				case 'select':

				?>

					<select id="datebook-<?php echo esc_attr($value['slug']); ?>" class="custom-select" name="<?php echo esc_attr($value['slug']); ?>">
						<option value="0"><?php echo esc_attr($any_answer_title); ?></option>

						<?php 

						foreach ($value['field_items'] as $key => $val) {

							$key = $key + 1;

							$selected_field = '';

							if(isset($get_user_filled_fields)){
								if( $get_user_filled_fields == $key ) {
									$selected_field = ' selected="selected"';
								}
							}

						?>

						<option value="<?php echo sanitize_key($key); ?>" <?php echo esc_attr($selected_field); ?>><?php echo esc_attr($val); ?></option>

					<?php } ?>

					</select>

				<?php 

				break;

				case 'multiselect-single':

				?>

					<select id="datebook-<?php echo esc_attr($value['slug']); ?>" class="form-control custom-select" name="<?php echo esc_attr($value['slug']); ?>" size="5">
						<option value="0"><?php echo esc_attr($any_answer_title); ?></option>

						<?php 

						foreach ($value['field_items'] as $key => $val) {

							$key = $key + 1;

							$selected_field = '';

							if(isset($get_user_filled_fields)){
								if( $get_user_filled_fields == $key ) {
									$selected_field = ' selected="selected"';
								}
							}

						?>

						<option value="<?php echo sanitize_key($key); ?>" <?php echo esc_attr($selected_field); ?>><?php echo esc_attr($val); ?></option>

					<?php } ?>

					</select>

				<?php 

				break;

				case 'multiselect':

				?>

					<select id="datebook-<?php echo esc_attr($value['slug']); ?>" class="custom-select" name="<?php echo esc_attr($value['slug']); ?>[]" multiple>
						<option value="0"><?php echo esc_attr($any_answer_title); ?></option>

						<?php 

						foreach ($value['field_items'] as $key => $val) {

							$key = $key + 1;

							$selected_field = '';

							if(isset($get_user_filled_fields) && is_array($get_user_filled_fields)){
								if( in_array($key, $get_user_filled_fields) ) {
									$selected_field = ' selected="selected"';
								}
							}


						?>

						<option value="<?php echo sanitize_key($key); ?>" <?php echo esc_attr($selected_field); ?>><?php echo esc_attr($val); ?></option>

					<?php } ?>

					</select>

				<?php 

				break;

				case 'checkbox':
				
				$key = 0;

				?>
								
					<div class="checkbox">
					
					<input id="datebook-<?php echo esc_attr($value['slug']); ?><?php echo sanitize_key($key); ?>" type="hidden" name="<?php echo esc_attr($value['slug']); ?>[]" value="<?php echo esc_attr($key); ?>" />

					<?php 

					foreach ($value['field_items'] as $key => $val) {

						$key = $key + 1;

						$selected_field = '';

						if(isset($get_user_filled_fields) && is_array($get_user_filled_fields)){
							if( in_array($key, $get_user_filled_fields) ) {
								$selected_field = ' checked';
							}
						}

					?>
					
					<div class="custom-control custom-checkbox">
						<input type="checkbox" class="custom-control-input" id="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>" name="<?php echo esc_attr($value['slug']); ?>[]" value="<?php echo esc_attr($key); ?>" <?php echo esc_attr($selected_field); ?> />
						<label class="custom-control-label" for="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>"><?php echo esc_attr($val); ?></label>
					</div>

					<?php } ?>

					</div>

				<?php 

				break;

				case 'radio':
				
				$key = 0;

				?>
								
					<div class="radio">

					<?php if($custom_field_data_required == 0){ ?>

					<div class="custom-control custom-radio">
						<input type="radio" id="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>" name="<?php echo esc_attr($value['slug']); ?>" value="<?php echo esc_attr($key); ?>" class="custom-control-input" checked="checked" /> 
						<label class="custom-control-label" for="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>"><?php echo esc_attr($any_answer_title); ?></label>
					</div>

					<?php } ?>

					<?php 
					
					foreach ($value['field_items'] as $key => $val) {
						
						$key = $key + 1;
						
						$selected_field = '';
						
						if(isset($get_user_filled_fields)){
							if( $get_user_filled_fields == $key ) {
								$selected_field = ' checked';
							}
						}

					?>
					
					<div class="custom-control custom-radio">
						<input type="radio" id="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>" name="<?php echo esc_attr($value['slug']); ?>" value="<?php echo esc_attr($key); ?>" <?php echo esc_attr($selected_field); ?> class="custom-control-input" /> 
						<label class="custom-control-label" for="datebook-<?php echo esc_attr($value['slug']); ?><?php echo esc_attr($key); ?>"><?php echo esc_attr($val); ?></label>
					</div>

					<?php } ?>

					</div>

				<?php 

				break;

			} // end switch

		}
		
	}


	/**
	 * Renders fields in custom profile form
	 *
	 */
	public static function render_field_out($whatform, $value, $profile_edit_form_data, $custom_field_title) {

		$show_field_layout = $show_fields = '';

		if(is_array($value)){

			$get_user_filled_fields = array();

			if (isset($profile_edit_form_data[$value['slug']])) {
				$get_user_filled_fields = $profile_edit_form_data[$value['slug']];
			}


			if((is_array($get_user_filled_fields) && count($get_user_filled_fields) > 0) || (is_numeric($get_user_filled_fields) && $get_user_filled_fields > 0) || (is_string($get_user_filled_fields) && strlen($get_user_filled_fields) > 0)) {

				// if foreign language do not exist, then show title in English (en_US)
				$value_field_items = $whatform == 'search_form_other' && isset($value['field_items_search_' . DATEBOOK_WPLANG]) && !empty($value['field_items_search_' . DATEBOOK_WPLANG]) ? $value['field_items_search_' . DATEBOOK_WPLANG] : (isset($value['field_items_' . DATEBOOK_WPLANG]) && !empty($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US']);


				$new_value = array();
				if(is_array($value_field_items)){

					$value['field_items'] = $value_field_items;
					
					$add_key = 0;

				} else {

					$value['field_items'] = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

					$add_key = 1;

				}

				$value['type'] = $whatform == 'search_form_other' && isset($value['type_search']) && !empty($value['type_search']) ? $value['type_search'] : $value['type'];
				
				switch($value['type']){

					case 'text':

						if(!empty($profile_edit_form_data[$value['slug']])) {

							$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

							$show_field_layout .= '<div class="clear"></div><span>';
						
							//$show_field_layout .= '<span class="text-italic">';

							$show_field_layout .= esc_attr($profile_edit_form_data[$value['slug']]);

							//$show_field_layout .= '</span>';
						
							$show_field_layout .= '</span><div class="datebook-clear20"></div>';

						}

					break;

					case 'textarea' : 
				
						if(!empty($profile_edit_form_data[$value['slug']])) {

							$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

							$show_field_layout .= '<div class="clear"></div><span>';

							//$show_field_layout .= '<span class="text-italic">';

							$show_field_layout .= wpautop(esc_textarea($profile_edit_form_data[$value['slug']]));

							//$show_field_layout .= '</span>';

							$show_field_layout .= '</span><div class="datebook-clear20"></div>';

						}

					break;

					case 'select':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {
							
								$key = $key + $add_key;

								if(isset($get_user_filled_fields)){
									if( $get_user_filled_fields == $key ) {
										$show_fields .= esc_attr($val);
									}
								}
						
							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

								$show_field_layout .= '<div class="clear"></div><span>';

								$show_field_layout .= $show_fields;

								$show_field_layout .= '</span><div class="datebook-clear20"></div>';

							}
						}

					break;

					case 'multiselect-single':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {
							
								$key = $key + $add_key;

								if(isset($get_user_filled_fields)){
									if( $get_user_filled_fields == $key ) {
										$show_fields .= esc_attr($val);
									}
								}
						
							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

								$show_field_layout .= '<div class="clear"></div><span>';

								$show_field_layout .= $show_fields;

								$show_field_layout .= '</span><div class="datebook-clear20"></div>';

							}
						}

					break;

					case 'multiselect':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {

								$key = $key + $add_key;

								if(is_array($get_user_filled_fields) && in_array($key, $get_user_filled_fields) ) {

									$show_fields .= '&#8212; ' . esc_attr($val) . '<br />';

								}

							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

								$show_field_layout .= '<div class="clear"></div><span>';

								$show_field_layout .= $show_fields;

								$show_field_layout .= '</span><div class="datebook-clear20"></div>';
								
							}
						}

					break;

					case 'checkbox':

						if(isset($profile_edit_form_data[$value['slug']]) && count($profile_edit_form_data[$value['slug']]) > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && is_array($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {

								$key = $key + $add_key;

								if( in_array($key, $get_user_filled_fields) ) {

									$show_fields .= '&#8212; ' . esc_attr($val) . '<br />';

								}

							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

								$show_field_layout .= '<div class="clear"></div><span>';

								$show_field_layout .= $show_fields;

								$show_field_layout .= '</span><div class="datebook-clear20"></div>';
								
							}
						}

					break;

					case 'radio':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {
						
							foreach ($value['field_items'] as $key => $val) {
							
								$key = $key + $add_key;

								if(isset($get_user_filled_fields)){

									if( $get_user_filled_fields == $key ) {

										$show_fields .= esc_attr($val);

									}
								}
							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout .= '<strong>' . esc_attr($custom_field_title) . ':</strong>';

								$show_field_layout .= '<div class="clear"></div><span>';

								$show_field_layout .= $show_fields;

								$show_field_layout .= '</span><div class="datebook-clear20"></div>';
								
							}
						}

					break;

				} // end switch

			}

		}

		return $show_field_layout;

	}


	/**
	 * Renders and show filled fields in profile
	 *
	 */
	public static function show_filled_fields($whatform, $profile_edit_form_data, $currentauth_id, $current_user_id) {

		global $wp_locale_all, $datebook_reserved_fields;

		$general_layout = $main_layout = '';
		
		$count_all_fields = 0;
		
		//Get profile form array
		$get_profile_form_fields = get_option('datebook_profile_form');
		$get_profile_form_fields = isset($get_profile_form_fields[$whatform]) ? $get_profile_form_fields[$whatform] : ($get_profile_form_fields ? $get_profile_form_fields : array());

		if(is_array($get_profile_form_fields)){

			if (is_user_logged_in() && isset($currentauth_id) && $currentauth_id > 0 && $currentauth_id == $current_user_id) {

				$main_layout .= '<div class="row"><div class="col-lg-12 col-md-12 col-sm-12 text-right">';
							
				$main_layout .= '<a class="btn btn-secondary btn-blue-grey btn-sm" href="' . esc_url(get_permalink(of_get_option('my_edit_profile_page'))) . '"><i class="fas fa-edit"></i> ' . esc_html__( 'Edit', 'datebook' ) . '</a>';

				$main_layout .= '</div></div>';
							
			}

			// get languages
			$languages_array = array();

			$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

			$languages = DateBook_Localization::datebook_all_available_language_files();

			foreach($languages as $language) {
				if($language['checked'] == 1){
					$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
				}
			}

			// Get custom fields
			$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

			$datebook_profiletypes = array();
			$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
			foreach ($profiletypes_array as $key => $value ){
				$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
			}
			$profiletypes = implode("\r\n", $datebook_profiletypes);

			foreach ($all_custom_fields as $key => $value) {
				if(isset($datebook_reserved_fields[$key])){
					//unset($all_custom_fields[$key]);
					$datebook_reserved_fields[$key] = array(
						'slug' => $key, 
						'type' => $whatform == 'search_form_other' && isset($datebook_reserved_fields[$key]['type_search']) && !empty($datebook_reserved_fields[$key]['type_search']) ? $datebook_reserved_fields[$key]['type_search'] : $datebook_reserved_fields[$key]['type'], 
						'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
						'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
						'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
						'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
						'limittext' => $value['limittext']
					);

					foreach ( $languages_array as $language_key => $language_name ) {

						$value_name = $whatform == 'search_form_other' && isset($value['name_search_' . $language_key]) && !empty($value['name_search_' . $language_key]) ? 'name_search_' . $language_key : (isset($value['name_' . $language_key]) && !empty($value['name_' . $language_key]) ? 'name_' . $language_key : 'name_en_US');

						if (isset($value_name)) {
							$datebook_reserved_fields[$key][$value_name] =  $value[$value_name];
						}

						$value_field_items = $whatform == 'search_form_other' && isset($value['field_items_search_' . $language_key]) && !empty($value['field_items_search_' . $language_key]) ? 'field_items_search_' . $language_key : (isset($value['field_items_' . $language_key]) && !empty($value['field_items_' . $language_key]) ? 'field_items_' . $language_key : 'field_items_en_US');

						if (isset($value_field_items)) {
							if($key == 'profiletypereserved'){
								$datebook_reserved_fields[$key][$value_field_items] =  $profiletypes;
							} else {
								$datebook_reserved_fields[$key][$value_field_items] =  $value[$value_field_items];
							}
						}
					}
				}
			}

			// Merge custom and reserved fields
			$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);

			foreach($get_profile_form_fields as $key => $value){

				if(isset($value['name']) && $value['name'] == 'row') {

					if(isset($value['quantity_columns']) && $value['quantity_columns'] == 1){
						$input_columns = 'onecolumnrow';
						$input_title = 'onecolumntitle';
					} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 2){
						$input_columns = 'twocolumnrow';
						$input_title = 'twocolumntitle';
					} else {
						$input_columns = 'threecolumnrow';
						$input_title = 'threecolumntitle';
					}

					$field_header = '';

					foreach($get_profile_custom_fields as $key => $field){

						if (isset($value['children'][0]['rowTitle']) && $value['children'][0]['rowTitle'] == $key) {

							$field['type'] = $whatform == 'search_form_other' && isset($field['type_search']) && !empty($field['type_search']) ? $field['type_search'] : $field['type'];

							if (isset($field['active']) && $field['active'] == 1 && isset($field['type']) && $field['type'] == 'title'){

								// if foreign language do not exist, then show title in English (en_US)
								$field['name'] = isset($field['name_' . DATEBOOK_WPLANG]) && !empty($field['name_' . DATEBOOK_WPLANG]) ? $field['name_' . DATEBOOK_WPLANG] : $field['name_en_US'];

								$field_header .= '<div class="row"><div class="col-lg-12 col-md-12 col-sm-12">';
								$field_header .= '<h2>' . esc_attr($field['name']) . '</h2>';
								$field_header .= '</div></div>';

							}
						}
					}

					$key = 0;

					$count_this_field = 0;

					$collect_fields = '<div class="row">';

					foreach ( $value['children'] as $key => $columns ) {

						if(isset($columns['name']) && $columns['name'] == 'column'){

							if(isset($value['quantity_columns']) && $value['quantity_columns'] == 1){

								$collect_fields .= '<div class="col-lg-12 col-md-12 col-sm-12">';

							} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 2){

								$collect_fields .= '<div class="col-lg-6 col-md-6 col-sm-6">';

							} else {

								$collect_fields .= '<div class="col-lg-4 col-md-4 col-sm-4">';

							}

							if(isset($columns['children'])){

								foreach($columns['children'] as $key => $column){

									if(isset($get_profile_custom_fields[$column['slug']]) && isset($get_profile_custom_fields[$column['slug']]['active']) && $get_profile_custom_fields[$column['slug']]['active'] == 1) {

										$custom_field_data = $get_profile_custom_fields[$column['slug']];

										// if foreign language do not exist, then show title in English (en_US)
										$custom_field_title = isset($custom_field_data['name_' . DATEBOOK_WPLANG]) && !empty($custom_field_data['name_' . DATEBOOK_WPLANG]) ? $custom_field_data['name_' . DATEBOOK_WPLANG] : $custom_field_data['name_en_US'];

										// Render field
										$render_fields = self::render_field_out($whatform, $custom_field_data, $profile_edit_form_data, $custom_field_title);

										if($render_fields){
											$count_this_field++;
											$collect_fields .= $render_fields;
										}

									}
								}
							}

							$collect_fields .= '</div>';

						}
					}

					$collect_fields .= '</div>';


					if($count_this_field > 0) {
						$count_all_fields++;
						$main_layout .= $field_header;
						$main_layout .= $collect_fields;
					}
				}
			}

			// Let's if user filled the form
			if($count_all_fields > 0) {

				// Show the filled fields
				$general_layout = $main_layout;

			} else {

				// If no filled fields the show message that user did not complete the profile yet
				$general_layout = DateBook_Template_Loader::load( 'profile/profile-form-not-completed' );

			}


		}

		return $general_layout;

	}


	/**
	 * Validate all input data from all forms: registration, settings
	 *
	 * @access public
	 */
	public static function validate_form($whatform) {

  		if ( isset( $_POST['change_profile_form'] ) && isset($_POST['action']) && $_POST['action'] == 'change') {

			// Make global    
			global $datebook_form_error, $wp_locale_all, $datebook_reserved_fields, $datebook_gender_titles, $datebook_sexualorientation_titles;

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}

			$datebook_field_titles = get_query_var( 'datebook_field_titles' );
			if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

			// instantiate the class
			$datebook_form_error = new WP_Error;

			$update_data = array();

			// If any field is left empty, add the error message to the error object
			$is_user_logged_in = is_user_logged_in() ? 1 : 0;

			// Check if any gateway is activated
			$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

			$enable_phone = $enable_website = 1;

			$profile_id = $profile_post_author = 0;
			
			$profile_title = '';

			if($current_user_id > 0){

				$current_user = get_userdata($current_user_id);
				$user_email = isset($current_user->user_email) ? $current_user->user_email : '';

				$update_data['user'] =  isset($current_user->user_login) ? $current_user->user_login : DateBook_Utilities::datebook_random_symbols(12);

				$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );
				$profile_post = get_post($profile_id);
				$profile_post_author = isset($profile_post->post_author) && $profile_post->post_author > 0 ? $profile_post->post_author : 0;
				$profile_title = isset($profile_post->post_title) && strlen($profile_post->post_title) > 0 ? $profile_post->post_title : '';

				//  Get all data of profile
				$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
				$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

				if ($profile_post_author != $current_user_id && $is_user_logged_in == 1) {

					$datebook_form_error->add( 'not_allowed', esc_html__( 'You are not allowed to edit this profile', 'datebook' ), 'has-error' );

				}

			} else {

				$update_data['user'] = DateBook_Utilities::datebook_random_symbols(12);

			}

			$update_data['profile_id'] = $profile_id > 0 ? $profile_id : 0;


			// Subscription plan
			if (isset($_POST['subscriptionplan']) && strlen($_POST['subscriptionplan']) > 1) {

				$update_data['subscriptionplan'] = wp_trim_words(sanitize_text_field(wp_strip_all_tags($_POST['subscriptionplan'])), 200, '');
				$update_data['subscriptionplan_price'] = $_POST['subscriptionplan_price'];

			}



			// get languages
			$languages_array = array();

			$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

			$languages = DateBook_Localization::datebook_all_available_language_files();

			foreach($languages as $language) {
				if($language['checked'] == 1){
					$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
				}
			}


			// Get profile form
			$get_profile_form_fields = get_option('datebook_profile_form');
			$get_profile_form_fields = isset($get_profile_form_fields[$whatform]) ? $get_profile_form_fields[$whatform] : ($get_profile_form_fields ? $get_profile_form_fields : array());

			// Get custom fields
			$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

			$datebook_profiletypes = array();
			$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
			foreach ($profiletypes_array as $key => $value ){
				$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
			}
			$profiletypes = implode("\r\n", $datebook_profiletypes);

			foreach ($all_custom_fields as $key => $value) {
				if(isset($datebook_reserved_fields[$key])){
					//unset($all_custom_fields[$key]);
					$datebook_reserved_fields[$key] = array(
						'slug' => $key, 
						'type' => $whatform == 'search_form_other' && isset($datebook_reserved_fields[$key]['type_search']) && !empty($datebook_reserved_fields[$key]['type_search']) ? $datebook_reserved_fields[$key]['type_search'] : $datebook_reserved_fields[$key]['type'], 
						'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
						'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
						'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
						'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
						'limittext' => $value['limittext'],
						'countrycity_hierarchy' => $key == 'countrycity' ? ($whatform == 'search_form_other' ? (isset($value['countrycity_hierarchy_search']) && !empty($value['countrycity_hierarchy_search']) ? $value['countrycity_hierarchy_search'] : 3) : (isset($value['countrycity_hierarchy']) && !empty($value['countrycity_hierarchy']) ? $value['countrycity_hierarchy'] : 3)) : ''
					);

					foreach ( $languages_array as $language_key => $language_name ) {

						if (isset($value['name_' . $language_key])) {
							$datebook_reserved_fields[$key]['name_' . $language_key] =  $value['name_' . $language_key];
						}
						if (isset($value['field_items_' . $language_key])) {
							if($key == 'profiletypereserved'){
								$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $profiletypes;
							} else {
								$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $value['field_items_' . $language_key];
							}
						}
					}
				}
			}

			$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);

			// Form fields
			foreach($get_profile_form_fields as $key => $value){

				if(isset($value['name']) && $value['name'] == 'row') {

					$key = 0;

					if(isset($value['children']) && !empty($value['children']) && is_array($value['children'])){

						foreach ( $value['children'] as $key => $columns ) {

							if(isset($columns['name']) && $columns['name'] == 'column'){

								if(isset($columns['children'])){

									foreach ( $columns['children'] as $key => $value ) {

										if(isset($get_profile_custom_fields[$value['slug']]) && isset($get_profile_custom_fields[$value['slug']]['active']) && $get_profile_custom_fields[$value['slug']]['active'] == 1) {

											if($value['slug'] == 'profiletypereserved'){

												$term_id = 0;

												if($profile_id > 0){
													$term_list = wp_get_post_terms($profile_id, DATEBOOK_PROFILES_TAX, array('fields' => 'all'));
													$term_id = isset($term_list[0]->term_id) ? $term_list[0]->term_id : 0;
												}

												if(of_get_option('profiletype_order_in_registration') == 'profiletype_in_registration'){

													// Profile type
													if (isset($_POST['profiletypereserved']) && $_POST['profiletypereserved'] > 0) {
														$update_data['profiletypereserved'] = absint($_POST['profiletypereserved']);
													} else {

														$args = array(
															'name'					=> 'profiletypereserved',
															'hide_empty'			=> 0,
															'use_desc_for_title'	=> 0,
															'hierarchical'			=> true,
															'number'				=> NULL,
															'echo'					=> 0,
															'depth'					=> 1,
															'current_category'		=> 0,
															'hide_if_empty'			=> true,
															'pad_counts'			=> 0,
															'taxonomy'				=> DATEBOOK_PROFILES_TAX
														);

														if(!empty(wp_dropdown_categories($args))){
															$datebook_form_error->add( 'profiletypereserved', esc_html__( 'Select a type', 'datebook' ), 'has-error' );
														} else {
															if($term_id == 0){
																$datebook_form_error->add( 'profiletypereserved', esc_html__( 'Select a type', 'datebook' ), 'has-error' );
															}
															$update_data['profiletypereserved'] = $term_id;
														}
													}

												} else {

													if (isset($_POST['profiletypereserved']) && $_POST['profiletypereserved'] > 0) {
														$update_data['profiletypereserved'] = absint($_POST['profiletypereserved']);
													} else {

														if($term_id == 0){
															$datebook_form_error->add( 'profiletypereserved', esc_html__( 'Select a type', 'datebook' ), 'has-error' );
														}

														$update_data['profiletypereserved'] = $term_id;

													}
												}

											} else if($value['slug'] == 'profilename'){

												// Profile name
												$prohibit_name_change = $is_user_logged_in == 1 && of_get_option('prohibit_name_change') == 1 ? 1 : 0;
												if ($prohibit_name_change == 0){

													if (of_get_option('profile_name_type') < 3){

														if (!empty($_POST['profile_name']) && strlen($_POST['profile_name']) > 1) {

															$update_data['profile_name'] = $_POST['profile_name'];

															// Allow only letters and numbers
															if(of_get_option('what_characters_profilename') == 2){

																//$update_data['profile_name'] = preg_replace("/[^\s\P{L}]+/u", '', $update_data['profile_name']);
																$update_data['profile_name'] = preg_replace("/[^a-zA-Z\s]/", '', $update_data['profile_name']);

															} else if(of_get_option('what_characters_profilename') == 3){

																//$update_data['profile_name'] = preg_replace("/[^\s\p{L}\p{N}]+/u", ' ', $update_data['profile_name']);
																$update_data['profile_name'] = preg_replace("/[^a-zA-Z0-9\s]/", '', $update_data['profile_name']);

															}

															$characters_limit_profilename = of_get_option('characters_limit_profilename') ? of_get_option('characters_limit_profilename') : 1000;

															$update_data['profile_name'] = substr(sanitize_text_field($update_data['profile_name']), 0, $characters_limit_profilename);

														} else {

															$datebook_form_error->add( 'profile_name', esc_html__( 'Write your name', 'datebook' ), 'has-error' );

														}
													}
												} else {

													$characters_limit_profilename = of_get_option('characters_limit_profilename') ? of_get_option('characters_limit_profilename') : 1000;

													$update_data['profile_name'] = isset($profile_title) && strlen($profile_title) > 0 ? $profile_title : substr(sanitize_text_field($_POST['profile_name']), 0, $characters_limit_profilename);

												}

											} else if($value['slug'] == 'aboutyou'){

												$aboutyou_max_chars = isset($get_profile_custom_fields[$value['slug']]['limittext']) && $get_profile_custom_fields[$value['slug']]['limittext'] > 0 ? $get_profile_custom_fields[$value['slug']]['limittext'] : 1000000;
												$update_data['aboutyou'] = isset($_POST['aboutyou']) ? substr(implode( "\n", array_map( 'sanitize_textarea_field', explode( "\n", $_POST['aboutyou'] ) ) ), 0, $aboutyou_max_chars) : '';

												if (empty($update_data['aboutyou']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] == 1) {

													$datebook_form_error->add( 'aboutyou', esc_html__( 'You must write something about you', 'datebook' ), 'has-error' );

												}

											} else if($value['slug'] == 'countrycity'){

												if (isset($_POST['city']) && !empty($_POST['city']) && $_POST['city'] > 0) {

													$update_data['city'] = absint($_POST['city']);

													$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $update_data['city'] );

													$update_data['country'] = isset($_POST['country']) && $_POST['country'] > 0 ? absint($_POST['country']) : (isset($term_data->country_id) ? $term_data->country_id : 0);
													$update_data['region'] = isset($_POST['region']) && $_POST['region'] > 0 ? absint($_POST['region']) : (isset($term_data->region_id) ? $term_data->region_id : 0);

												} else if (empty($update_data['city']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0 && isset($get_profile_custom_fields[$value['slug']]['countrycity_hierarchy']) && $get_profile_custom_fields[$value['slug']]['countrycity_hierarchy'] == '3') {

													$datebook_form_error->add( 'city', esc_html__( 'Select your city', 'datebook' ), 'has-error' );

												} else if (isset($_POST['region']) && !empty($_POST['region']) && $_POST['region'] > 0) {

													$update_data['region'] = absint($_POST['region']);

													$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $update_data['region'] );

													$update_data['country'] = isset($_POST['country']) && $_POST['country'] > 0 ? absint($_POST['country']) : (isset($term_data->country_id) ? $term_data->country_id : 0);
													
												} else if (empty($update_data['region']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0 && isset($get_profile_custom_fields[$value['slug']]['countrycity_hierarchy']) && $get_profile_custom_fields[$value['slug']]['countrycity_hierarchy'] == '2') {

													$datebook_form_error->add( 'region', esc_html__( 'Select your region', 'datebook' ), 'has-error' );

												} else if (isset($_POST['country']) && !empty($_POST['country']) && $_POST['country'] > 0) {

													$update_data['country'] = absint($_POST['country']);

													$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $update_data['country'] );

													$update_data['country'] = isset($_POST['country']) && $_POST['country'] > 0 ? absint($_POST['country']) : (isset($term_data->country_id) ? $term_data->country_id : 0);

												} else if (empty($update_data['country']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0) {
													
													print_r($get_profile_custom_fields);//echo $get_profile_custom_fields['countrycity']['countrycity_hierarchy'];

													$datebook_form_error->add( 'country', esc_html__( 'Select your country', 'datebook' ), 'has-error' );

												}

											} else if($value['slug'] == 'birthdate'){

													$dateday = isset($datebook_get_data['dateday']) ? $datebook_get_data['dateday'] : 0;
													$datemonth = isset($datebook_get_data['datemonth']) ? $datebook_get_data['datemonth'] : 0;
													$dateyear = isset($datebook_get_data['dateyear']) ? $datebook_get_data['dateyear'] : 0;

													if ( $is_user_logged_in == 0 || ($is_user_logged_in == 1 && of_get_option('allow_edit_birthdate') == '1') || ($is_user_logged_in == 1 && $dateday < 1 && $datemonth < 1 && $dateyear < 1 && of_get_option('allow_edit_birthdate') != '1')) {

														$update_data['dateday'] = isset($_POST['dateday']) && $_POST['dateday'] > 0 ? absint($_POST['dateday']) : 0;
														$update_data['datemonth'] = isset($_POST['datemonth']) && $_POST['datemonth'] > 0 ? absint($_POST['datemonth']) : 0;
														$update_data['dateyear'] = isset($_POST['dateyear']) && $_POST['dateyear'] > 0 ? absint($_POST['dateyear']) : 0;

														if ($update_data['dateday'] > 0 && $update_data['datemonth'] > 0 && $update_data['dateyear'] > 0) {
															if ($update_data['dateday'] < 1 || $update_data['dateday'] > 31) {
																$datebook_form_error->add( 'dateday', esc_html__( 'The day from you date of birth is wrong', 'datebook' ), 'has-error' );
																unset($update_data['dateday']);
															}

															if ($update_data['datemonth'] < 1 || $update_data['datemonth'] > 12) {
																$datebook_form_error->add( 'datemonth', esc_html__( 'The month from you date of birth is wrong', 'datebook' ), 'has-error' );
																unset($update_data['datemonth']);
															}

															if (strlen($update_data['dateyear']) != '4') {
																$datebook_form_error->add( 'dateyear', esc_html__( 'The year from you date of birth is wrong', 'datebook' ), 'has-error' );
																unset($update_data['dateyear']);
															}

															$min_register_age = of_get_option('register_age_min') > 0 ? of_get_option('register_age_min') : 18;

															$age = floor((time() - strtotime($update_data['dateyear'].'-'.$update_data['datemonth'].'-'.$update_data['dateday']))/31556926);

															if ($age < $min_register_age) {
																$datebook_form_error->add( 'dateyear', sprintf( esc_html__( 'You must be at least %s years old to register on this site', 'datebook' ), $min_register_age ), 'has-error' );
																unset($update_data['dateyear']);
															}

														} else {

															if (isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0) {

																$datebook_form_error->add( 'birth', esc_html__( 'Select your date of birth', 'datebook' ), 'has-error' );

															}
														}
													}

											} else if($value['slug'] == 'gender'){

												if ($is_user_logged_in == 1){

													$gender_array = absint(get_post_meta($profile_id, 'gender', true));

													if (of_get_option('allow_edit_gender') == '1' || $gender_array == 0){

														$gender = isset($_POST['gender']) && !empty($_POST['gender']) && $_POST['gender'] > 0 ? absint($_POST['gender']) : 0;
													} else {

														$gender = absint(get_post_meta($profile_id, 'gender', true));

													}

												} else if ($is_user_logged_in == 0){

													$gender = isset($_POST['gender']) && !empty($_POST['gender']) && $_POST['gender'] > 0 ? absint($_POST['gender']) : 0;
												}


												if ($gender == 0){
													$update_data['gender'] = $gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
												} else {

													$update_data['gender'] = $gender;

												}

												if ($is_user_logged_in == 0 || ($is_user_logged_in == 1 && of_get_option('allow_edit_gender') == '1') || ($is_user_logged_in == 1 && isset($gender) && $gender < 1 && of_get_option('allow_edit_gender') != '1')){

													if ($gender > 0){

														$update_data['gender'] = $gender;

														if (!isset($datebook_gender_titles[$update_data['gender']])) {
															$datebook_form_error->add( 'gender', esc_html__( 'Choose your gender', 'datebook' ), 'has-error' );
															unset($update_data['gender']);
														}

													} else {

														$datebook_form_error->add( 'gender', esc_html__( 'Choose your gender', 'datebook' ), 'has-error' );

													}
												}

											} else if($value['slug'] == 'sexualorientation'){

												if (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != ''){

													if (isset($_POST['sexualorientation']) && !empty($_POST['sexualorientation'])){

														$update_data['sexualorientation'] = absint($_POST['sexualorientation']);

														if ($update_data['sexualorientation'] < 1 && !isset($datebook_sexualorientation_titles[$update_data['sexualorientation']]) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0) {

															$datebook_form_error->add( 'sexualorientation', esc_html__( 'Choose your sexual orientation', 'datebook' ), 'has-error' );
															unset($update_data['sexualorientation']);
														}
													
													} else if (empty($_POST['sexualorientation']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0) {
														$datebook_form_error->add( 'sexualorientation', esc_html__( 'Choose your sexual orientation', 'datebook' ), 'has-error' );
													}
												}

											} else if($value['slug'] == 'phone'){

												if (isset($_POST['phone']) && !empty($_POST['phone'])){

													$update_data['phone'] = preg_replace("/[^a-zA-Z0-9\-\s]/", '', wp_trim_words(sanitize_text_field(wp_strip_all_tags($_POST['phone'])), 50, ''));

												} else if (empty($_POST['phone']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0){

													$datebook_form_error->add( 'phone', esc_html__( 'Write your phone number', 'datebook' ), 'has-error' );

												} else {

													$update_data['phone'] = '';

												}

											} else if($value['slug'] == 'website'){

												if (isset($_POST['website']) && !empty($_POST['website']) && strlen($_POST['website']) > 1){

													$update_data['website'] = $_POST['website'];

													if (wp_http_validate_url($update_data['website'])){
														$update_data['website'] = wp_trim_words(esc_url($update_data['website']), 1000, '');
													} else {
														$datebook_form_error->add( 'website', esc_html__( 'Your website url seems to be wrong', 'datebook' ), 'has-error' );
													}

												} else if (empty($_POST['website']) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0){

													$datebook_form_error->add( 'website', esc_html__( 'Enter website url for your profile', 'datebook' ), 'has-error' );

												} else {

													$update_data['website'] = '';

												}

											} else if($value['slug'] == 'email'){

												if (of_get_option('registration_method') == 1 || of_get_option('registration_method') == 2) {

													if (empty($_POST['emailaddress'])) {

														$datebook_form_error->add( 'emailaddress', esc_html__( 'Write your email address', 'datebook' ), 'has-error' );

													} else {

														$update_data['emailaddress'] = sanitize_email($_POST['emailaddress']);

														if (!is_email($update_data['emailaddress'])){
															$datebook_form_error->add( 'emailaddress', esc_html__( 'Your email address seems to be wrong', 'datebook' ), 'has-error' );
														} else if (email_exists($update_data['emailaddress'])) {

															if ($is_user_logged_in == 1 && isset($current_user_id) && $current_user_id > 0){

																if (isset($user_email) && $update_data['emailaddress'] != $user_email){

																	$datebook_form_error->add( 'emailaddress', esc_html__( 'This email address is already registered', 'datebook' ), 'has-error' );
																}
															} else {

																$datebook_form_error->add( 'emailaddress', esc_html__( 'This email address is already registered', 'datebook' ), 'has-error' );

															}

															if (isset($profile_id) && $profile_id > 0) {
																$update_data['emailaddress'] = $user_email;
															}
														}
													}
												}

											} else if($value['slug'] == 'user'){

												if (of_get_option('registration_method') == 1) {

													$user = isset($current_user->user_login) && strlen($current_user->user_login) > 0 ? $current_user->user_login : '';

													if ( $is_user_logged_in == 0 || ($is_user_logged_in == 1 && strlen($user) < 1)) {

														if (isset($_POST['user']) && strlen($_POST['user']) > 0) {

															$update_data['user'] = sanitize_user($_POST['user'], true);

															$min_characters_username = of_get_option('min_characters_username') ? of_get_option('min_characters_username') : 4;
															$max_characters_username = of_get_option('max_characters_username') ? of_get_option('max_characters_username') : 30;

															if (strlen($update_data['user']) < $min_characters_username || strlen($update_data['user']) > $max_characters_username) {
																$datebook_form_error->add( 'user', sprintf( esc_html__( 'Your username must be between %1$s and %2$s characters', 'datebook' ), $min_characters_username, $max_characters_username ), 'has-error' );

															} else {

																if (username_exists($update_data['user'])) {
																	$datebook_form_error->add( 'user', esc_html__( 'This username already exists. Please select another one', 'datebook' ), 'has-error' );
																}
															}

														} else {

															$datebook_form_error->add( 'user', esc_html__( 'Create your username', 'datebook' ), 'has-error' );

														}
													}
												}

											} else if($value['slug'] == 'newpass'){

												if ($is_user_logged_in == 1 || (of_get_option('let_users_set_pass') == 1 && $is_user_logged_in == 0)) {

													if (isset($_POST['newpass']) && strlen($_POST['newpass']) > 0) {

														$min_characters_password = of_get_option('min_characters_password') ? of_get_option('min_characters_password') : 4;
														$max_characters_password = of_get_option('max_characters_password') ? of_get_option('max_characters_password') : 50;

														$update_data['newpass'] = $_POST['newpass'];

														if (strlen($update_data['newpass']) < $min_characters_password || strlen($update_data['newpass']) > $max_characters_password) {
															$datebook_form_error->add( 'newpass', sprintf(esc_html__( "Your password must be between %1$s and %2$s characters", 'datebook' ), $min_characters_password, $max_characters_password), 'has-error' );

															//unset($update_data['newpass']);
														} else if ( false !== strpos( stripslashes($update_data['newpass']), "\\" ) ) {
															$datebook_form_error->add( 'newpass', esc_html__( 'Password may not contain the character "\"', 'datebook' ), 'has-error' );
															//unset($update_data['newpass']);
														}

														if ($is_user_logged_in == 1 && isset($current_user_id) && $current_user_id > 0 && isset($_POST['currentpass'])) {

															$update_data['currentpass'] = sanitize_text_field($_POST['currentpass']);

															if ($update_data['currentpass']) {

																if (isset($current_user->user_pass) && strlen($current_user->user_pass) > 0 && ! wp_check_password( $update_data['currentpass'], $current_user->user_pass, $current_user_id ) ) {
																	$datebook_form_error->add( 'currentpass', esc_html__( 'You have entered wrong current password', 'datebook' ), 'has-error' );
																	unset($update_data['currentpass']);
																}

															} else {

																if ($profile_id) {
																	$datebook_form_error->add( 'currentpass', esc_html__( 'Enter your current password in order to set a new password', 'datebook' ), 'has-error' );
																}
															}
														}

													} else {

														if ($is_user_logged_in == 0) {
															$datebook_form_error->add( 'newpass', esc_html__( 'Create a new password', 'datebook' ), 'has-error' );
														}
													}
												}

											} else if($value['slug'] == 'onlinestatus'){

											} else if($value['slug'] == 'searchbyname'){
											
											} else if(isset($datebook_reserved_fields[$value['slug']]['slug']) && $datebook_reserved_fields[$value['slug']]['slug'] == $value['slug']){

											} else {

												if (isset($_POST[$value['slug']]) && !empty($_POST[$value['slug']])){

													if (is_array($_POST[$value['slug']])) {

														// get options of field
														// if foreign language do not exist, then show title in English (en_US)
														$value_field_items = $whatform == 'search_form_other' && isset($get_profile_custom_fields[$value['slug']]['field_items_search_' . DATEBOOK_WPLANG]) && !empty($get_profile_custom_fields[$value['slug']]['field_items_search_' . DATEBOOK_WPLANG]) ? $get_profile_custom_fields[$value['slug']]['field_items_search_' . DATEBOOK_WPLANG] : (isset($get_profile_custom_fields[$value['slug']]['field_items_' . DATEBOOK_WPLANG]) && !empty($get_profile_custom_fields[$value['slug']]['field_items_' . DATEBOOK_WPLANG]) ? $get_profile_custom_fields[$value['slug']]['field_items_' . DATEBOOK_WPLANG] : $get_profile_custom_fields[$value['slug']]['field_items_en_US']);
													
														$value['field_items'] = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

														$update_data[$value['slug']] = array_map( 'absint', preg_replace("/([^0-9])/", '', $_POST[$value['slug']]) );

														$selected_field = 0;

														foreach ($value['field_items'] as $key => $val) {
															$key = $key + 1;
															if( in_array($key, $_POST[$value['slug']]) ) {
																$selected_field += 1;
															}
														}

														if ($selected_field == 0 && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0){
															$datebook_form_error->add( $value['slug'], esc_html__( 'This field is required', 'datebook' ), 'has-error' );
														}

													} else {

														$customfield_max_chars = isset($value['limittext']) && $value['limittext'] > 0 ? $value['limittext'] : 1000000;

														$update_data[$value['slug']] = isset($_POST[$value['slug']]) ? substr(implode( "\n", array_map( 'sanitize_textarea_field', explode( "\n", $_POST[$value['slug']] ) ) ), 0, $customfield_max_chars) : '';
														
														if (!isset($update_data[$value['slug']])) {
															$datebook_form_error->add( $value['slug'], esc_html__( 'This field is required', 'datebook' ), 'has-error' );
															unset($update_data[$value['slug']]);
														}

													}

												} else if (empty($_POST[$value['slug']]) && isset($get_profile_custom_fields[$value['slug']]['required']) && $get_profile_custom_fields[$value['slug']]['required'] > 0){

													if(preg_match('/"'.preg_quote($value['slug'], '/').'"/i' , json_encode($get_profile_form_fields))){

														$datebook_form_error->add( $value['slug'], esc_html__( 'This field is required', 'datebook' ), 'has-error' );

													}
												} else if (empty($_POST[$value['slug']])){

													$update_data[$value['slug']] = '';

												}
											}
										}
									}
								}
							}
						}
					}
				}
			}

			// Google reCaptcha process
			if($is_user_logged_in == 0){

				$google_recaptcha = of_get_option('google_recaptcha');

				if ($google_recaptcha['2'] == '1') {

					$google_recaptcha_error = DateBook_Utilities::datebook_google_recaptcha_response('register');

					if ($google_recaptcha_error == 1) {
						$datebook_form_error->add( 'wrong_recaptcha', esc_html__( 'Check the captcha form', 'datebook' ), 'has-error' );
					}
				}
			}

			return $update_data;

    	}
	}


	/**
	 * Update data
	 *
	 * @access public
	 */
	public static function update_data($whatform) {

		global $wpdb, $datebook_form_error, $datebook_field_titles, $datebook_get_data, $datebook_alert_error, $datebook_alert_text;

		// validate the Profile form input
		$datebook_get_data = stripslashes_deep(self::validate_form($whatform));

		$suspend_profile_after_edit = $plans_count = $subscribe_invisible = $default_subscription_plan = 0;

		$profile_edited_content = $emailhashkey = $emailhash = $user_login = $emailaddress = $user_email_temp = '';

		$user_info = array();

		// Ensure WP_Error object ($datebook_form_error) contains no error
		if (count($datebook_form_error->get_error_messages() ) < 1) {

			// Update the edited content
			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}

			$profile_id = isset($datebook_get_data['profile_id']) && $datebook_get_data['profile_id'] > 0 ? $datebook_get_data['profile_id'] : 0;

			//Get entire array
			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$get_profile_metadata = !empty($get_profile_data) ? $get_profile_data : array();


			if ($current_user_id > 0) {
				$user_info = get_userdata($current_user_id);
				$user_login = isset($user_info->user_login) && strlen($user_info->user_login) > 0 ? $user_info->user_login : '';
				$emailaddress = $user_email_temp = isset($user_info->user_email) && strlen($user_info->user_email) > 0 ? $user_info->user_email : '';

				$datebook_get_data['emailaddress'] = isset($datebook_get_data['emailaddress']) && strlen($datebook_get_data['emailaddress']) > 0 ? $datebook_get_data['emailaddress'] : (!empty($get_profile_metadata['emailaddress']) ? $get_profile_metadata['emailaddress'] : $emailaddress);

			}

			$post_profile = array(
				'ID' => $profile_id
			);

			$post_status = 'publish';
			
			// Update post
			$user_must_validate_email = of_get_option('user_must_validate_email');

			if (!is_super_admin() && $user_must_validate_email == '1') {

				// Do not publish profile if user must validate his email
				$emailhash = get_user_meta( $current_user_id, 'emailhash', true );
				if ($emailhash != '') {
					$post_status = 'private';
				}
			}

			// Update user name
			$profile_name = isset($datebook_get_data['profile_name']) && strlen($datebook_get_data['profile_name']) > 0 ? $datebook_get_data['profile_name'] : (!empty($get_profile_metadata['profile_name']) ? $get_profile_metadata['profile_name'] : '');
			$datebook_get_data['profile_name'] = DateBook_Utilities::datebook_word_filter($profile_name);

			$update_user_args = array(
				'ID' => $current_user_id, 
				//'user_email' => $datebook_get_data['emailaddress'], 
				'nickname' => $datebook_get_data['profile_name'], 
				'display_name' => $datebook_get_data['profile_name']
			);

			if (isset($datebook_get_data['newpass']) && strlen($datebook_get_data['newpass']) > 0) {

				$update_user_args['user_pass'] = $datebook_get_data['newpass'];

			}

			// If user changed about you text
			if (isset($datebook_get_data['aboutyou']) && strlen($datebook_get_data['aboutyou']) > 0) {

				$get_aboutyou = $datebook_get_data['aboutyou'];

				$datebook_get_data['aboutyou'] = DateBook_Utilities::datebook_word_filter($datebook_get_data['aboutyou']);

				// Update the edited content
				if(of_get_option('suspend_profile_after_edit') > '0'){
					if(of_get_option('suspend_profile_after_edit') == '1'){
						$post_profile['post_status'] = 'private';
						$post_profile['post_content'] = $datebook_get_data['aboutyou'];
					} else if(of_get_option('suspend_profile_after_edit') == '2'){
						update_post_meta($profile_id, 'edited_profile_content', $get_aboutyou);
					}

					$suspend_profile_after_edit = 1;
				} else {
					$post_profile['post_content'] = $datebook_get_data['aboutyou'];
				}

			}

			// Restrict changing the name of profile
			$prohibit_name_change = of_get_option('prohibit_name_change') == '1' ? 1 : 0;
			if ($prohibit_name_change == 0 && isset($datebook_get_data['profile_name']) && !empty($datebook_get_data['profile_name'])) {
				$post_profile['post_title'] = $datebook_get_data['profile_name'];
			}

			$post_profile['post_excerpt'] = $user_login;

			if(of_get_option('profile_name_type') == '3' && isset($user_login) && !empty($user_login)){
				$post_profile['post_title'] = $user_login;
			}


			// Check if Payment and Subscription are activated
			$check_if_gateway_activated = DateBook_Utilities::check_if_gateway_activated();

			if ($check_if_gateway_activated) {

				// Get Subscription plans
				$get_subscription_plans = get_option('datebook_subscription_plans');

				if (is_array($get_subscription_plans)){

					foreach($get_subscription_plans as $key => $value){

						if (isset($value['active']) && $value['active'] == 1) {

							$plans_count++;

							if (isset($value['activate_by_default']) && $value['activate_by_default'] == 1) {

								$subscribe_invisible++;

								$default_subscription_plan = $value['subscription_id'];

							}
						}
					}
				}
			}
			

			$datebook_get_subscriptionplan = $get_subsciption_status = '';

			// If user logged in then let's update his data
			if ($profile_id > 0) {

				// Check if Payment and Subscription are activated
				if ($check_if_gateway_activated) {

					$datebook_get_subscriptionplan = isset($get_profile_metadata['profile_subscription']['plan']) && isset($get_subscription_plans[$get_profile_metadata['profile_subscription']['plan']]) ? $get_subscription_plans[$get_profile_metadata['profile_subscription']['plan']] : '';

					$get_subsciption_status = DateBook_Profile_Subscription::get_subsciption_status($current_user_id);

					if ($plans_count > 0 && $datebook_get_subscriptionplan == '' && $get_subsciption_status != 'active'){
						$post_status = 'private';							
					}
				}

				wp_update_post( $post_profile );

				// Assign a term to our post
				if(isset($datebook_get_data['profiletypereserved'])){
					wp_set_object_terms( $profile_id, $datebook_get_data['profiletypereserved'], DATEBOOK_PROFILES_TAX );
				}

				update_post_meta($profile_id, 'new', '1');

				// Let's send notification to administrator about profile update
				$send_email_notification = of_get_option('receive_email_on_profile_update') ? true : false;
				$select_email_template = 'profile_changed_to_admin';
				$send_to_this_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');
				$subject_in_email = esc_html__('Profile has been changed by', 'datebook') . ': ' . $datebook_get_data['profile_name'];

				// If no errors let's show success alert
				$datebook_alert_text['success_profile_updated'] = esc_html__( 'Profile has been updated', 'datebook' );

				// Login after registration
				$auth_after_registration = 0;

				$required_fields_exist = 1;

			} else {

				// Check if user logged in and redirect him to home page
				if (is_user_logged_in()) {
					wp_redirect(home_url());
					exit;
				}

				// If user registers then let's insert his data into database
				if (of_get_option('registration_method') == 2) {
					$datebook_get_data['user'] = $datebook_get_data['emailaddress'];
				}
				// If user is not set at all then replace it with email
				if (!isset($datebook_get_data['user'])) {
					$datebook_get_data['user'] = $datebook_get_data['emailaddress'];
				}

				if (of_get_option('let_users_set_pass') == '') {
					// Generate random password
					$datebook_get_data['newpass'] = DateBook_Utilities::datebook_random_symbols();
				}

				// Check if required fields exist
				if(isset($datebook_get_data['emailaddress']) && isset($datebook_get_data['user']) && strlen($datebook_get_data['user']) > 0 && isset($datebook_get_data['newpass']) && strlen($datebook_get_data['newpass']) > 0){

					$userdata = array(
						'user_login'      => $datebook_get_data['user'],
						'user_pass'       => $datebook_get_data['newpass'],
						'user_email'      => $datebook_get_data['emailaddress'],
						'display_name'    => $datebook_get_data['profile_name'],
						'rich_editing'    => '',
						'show_admin_bar_front'=> '',
					);

					$current_user_id = wp_insert_user( $userdata );

					$postname = DateBook_Profile_Settings::create_profile_slug($current_user_id);

					// Check if Payment and Subscription are activated
					$post_status = 'publish';

					if (of_get_option('activate_manual_new_profile') == '1') {

						$post_status = 'private';

					} else {

						// Check Subscription plans exist
						if ($plans_count > 0) {

							// If subscription plan exists then do not publish profile
							$post_status = 'private';

						} else {

							// If subscription plan does not exist then publish profile
							$post_status = 'publish';

						}
					}

					// Send email notification
					$send_email_notification = false;

					if ($user_must_validate_email == '1' && !is_super_admin()) {

						// Do not publish profile if user must validate his email
						$post_status = 'private';

						//set an email hash so the user needs to validate his email in order to use the site
						$emailhash = md5($current_user_id.$datebook_get_data['user'].$datebook_get_data['emailaddress']);
						update_user_meta( $current_user_id, 'emailhash', $emailhash );
						$send_email_notification = true;

					}


					if(of_get_option('profile_name_type') == 3){
						$datebook_get_data['profile_name'] = $datebook_get_data['user'];
					}

					// Create post object
					$post_profile = array(
						'post_author' => $current_user_id,
						'post_title' => $datebook_get_data['profile_name'],
						'post_excerpt' => $datebook_get_data['user'],
						'post_name' => $postname,
						'post_status' => $post_status,
						'post_type' => DATEBOOK_POST_TYPE,
						'ping_status' => 'closed'
					);

					$post_profile['aboutyou'] = isset($datebook_get_data['aboutyou']) && strlen($datebook_get_data['aboutyou']) > 0 ? $datebook_get_data['aboutyou'] : '';

					// Insert the post into the database
					$profile_id = wp_insert_post( $post_profile );


					// Add some aditional settings and info
					$datebook_get_data['upload_folder'] = time().rand(1,999);
					$datebook_get_data['profile_type'] = DATEBOOK_POST_TYPE;
					$datebook_get_data['topad'] = '0';
					$datebook_get_data['featured'] = '0';

					// Set Who can see my profile
					$allow_choose_who_can_see_profile = of_get_option('allow_choose_who_can_see_profile') ? of_get_option('allow_choose_who_can_see_profile') : array();
					$count_allow_choose_who_can_see_profile = count(array_keys($allow_choose_who_can_see_profile, 1));
					if (isset($count_allow_choose_who_can_see_profile) && $count_allow_choose_who_can_see_profile > 0) {
						foreach($allow_choose_who_can_see_profile as $key => $value){
							if($value == 1){
								$datebook_get_data['datebook_who_can_see_my_profile'] = $key;
								break;
							}
						}
					} else {
						$datebook_get_data['datebook_who_can_see_my_profile'] = 'everyone';
					}

					// Set Who can see my images
					$allow_choose_who_can_see_images = of_get_option('allow_choose_who_can_see_images') ? of_get_option('allow_choose_who_can_see_images') : array();
					$count_allow_choose_who_can_see_images = count(array_keys($allow_choose_who_can_see_images, 1));
					if (isset($count_allow_choose_who_can_see_images) && $count_allow_choose_who_can_see_images > 0) {
						foreach($allow_choose_who_can_see_images as $key => $value){
							if($value == 1){
								$datebook_get_data['datebook_who_can_see_my_images'] = $key;
								break;
							}
						}
					} else {
						$datebook_get_data['datebook_who_can_see_my_images'] = 'everyone';
					}

					$datebook_get_data['ip'] = Class_DateBook_IP::get_ip_address();
					$datebook_get_data['hostname'] = gethostbyaddr($_SERVER['REMOTE_ADDR']);

					//adding the id in the database and the type of user, so we can check later what privileges they have
					update_user_meta( $current_user_id, 'profile_type', DATEBOOK_POST_TYPE );
					//add the post id that the user created. The user will only be able to edit this single post
					update_user_meta( $current_user_id, 'profile_postid', $profile_id );

					if(isset($datebook_get_data['country']) && $datebook_get_data['country'] > 0){
						update_post_meta($profile_id, 'country', $datebook_get_data['country']);
					}
					if(isset($datebook_get_data['region']) && $datebook_get_data['region'] > 0){
						update_post_meta($profile_id, 'region', $datebook_get_data['region']);
					}
					if(isset($datebook_get_data['city']) && $datebook_get_data['city'] > 0){
						update_post_meta($profile_id, 'city', $datebook_get_data['city']);
					}

					update_post_meta($profile_id, 'topad', '0');
					update_post_meta($profile_id, 'featured', '0');

					update_post_meta($profile_id, 'new', '1');

					update_post_meta($profile_id, 'upload_folder', $datebook_get_data['upload_folder']);

					$notactive = of_get_option('activate_manual_new_profile') == '1' ? 1 : 0;
					update_post_meta($profile_id, 'notactive', $notactive);


					


					$get_profile_metadata = array();

					// Let's send notification to user to ask him to validate his email
					$select_email_template = 'activation_link_to_profile';
					$send_to_this_email = $datebook_get_data['emailaddress'];
					$subject_in_email = esc_html__( 'Verify your email address', 'datebook' );

					// Login after registration
					$auth_after_registration = 1;
					$required_fields_exist = 1;

				} else {

					// Login after registration
					$auth_after_registration = 0;
					$required_fields_exist = 0;

				}

			}


			// Create a permalink for profile
			if($post_status != 'publish'){
				require_once ABSPATH . '/wp-admin/includes/post.php';
				list( $permalink, $postname ) = get_sample_permalink( $profile_id );
				$profile_get_permalink = str_replace( '%pagename%', $postname, $permalink );
			} else {
				$profile_get_permalink = get_permalink($profile_id);
			}

			$get_cookie_referral = Class_DateBook_Cookies::get_cookie_referral($profile_id, $profile_get_permalink);

			$emailhashkey = add_query_arg( array(
				'verifyemail' => $emailhash
			), $profile_get_permalink );



			if($required_fields_exist == 1){

				if(isset($datebook_get_data['profiletypereserved'])){
					wp_set_object_terms($profile_id, $datebook_get_data['profiletypereserved'], DATEBOOK_PROFILES_TAX);
				}

				// Let's save or update only these data for search

				// Update location
				if (is_super_admin()) {
					$profile_data = get_post($profile_id);
					$post_status = isset($profile_data->post_status) ? $profile_data->post_status : $post_status;
				}
				if($post_status == 'publish'){

					$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';

					if(isset($datebook_get_data['city']) && $datebook_get_data['city'] > 0){

						$get_profile_city = get_post_meta($profile_id, 'city', true);

						// compare if user set a new country then update counter in countries table
						if(isset($get_profile_city) && $get_profile_city != $datebook_get_data['city']){

							// increment counts in counter in city
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $datebook_get_data['city']) );
							// decrement counts in counter in country
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter - 1 WHERE id = %d", $get_profile_city) );

						}

						update_post_meta($profile_id, 'city', absint($datebook_get_data['city']));

					}

					if(isset($datebook_get_data['region']) && $datebook_get_data['region'] > 0){

						$get_profile_region = get_post_meta($profile_id, 'region', true);

						// compare if user set a new country then update counter in countries table
						if(isset($get_profile_region) && $get_profile_region != $datebook_get_data['region']){

							// increment counts in counter in region
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $datebook_get_data['region']) );
							// decrement counts in counter in country
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter - 1 WHERE id = %d", $get_profile_region) );

						}

						update_post_meta($profile_id, 'region', absint($datebook_get_data['region']));

					}

					if(isset($datebook_get_data['country']) && $datebook_get_data['country'] > 0){

						$get_profile_country = get_post_meta($profile_id, 'country', true);

						// compare if user set a new country then update counter in countries table
						if(isset($get_profile_country) && $get_profile_country != $datebook_get_data['country']){

							// increment counts in counter in country
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $datebook_get_data['country']) );
							// decrement counts in counter in country
							$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter - 1 WHERE id = %d", $get_profile_country) );

						}

						update_post_meta($profile_id, 'country', absint($datebook_get_data['country']));

					}

				}


				// Update Date of Birth
				if(isset($datebook_get_data['dateyear']) && isset($datebook_get_data['datemonth']) && isset($datebook_get_data['dateday'])){

					$datebook_get_data['birthday'] = $datebook_get_data['dateyear'].'-'.$datebook_get_data['datemonth'].'-'.$datebook_get_data['dateday'];

					update_post_meta($profile_id, 'birthday', $datebook_get_data['birthday']);

				}

				// Update Sexual orientation
				if (isset($datebook_get_data['sexualorientation']) && $datebook_get_data['sexualorientation'] > 0) {

					update_post_meta($profile_id, 'sexualorientation', absint($datebook_get_data['sexualorientation']));

				}

				// Update Gender
				if (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0) {

					update_post_meta($profile_id, 'gender', absint($datebook_get_data['gender']));

				}

				// Update Family status
				if (isset($datebook_get_data['family_status']) && $datebook_get_data['family_status'] > 0) {

					$datebook_get_data['family_status'] = $datebook_get_data['family_status'];
			
				} else {

					$datebook_get_data['family_status'] = 'single';

				}

				update_post_meta($profile_id, 'family_status', sanitize_text_field($datebook_get_data['family_status']));
				

				if (of_get_option('points_system') == 1 && class_exists('myCRED_Core')) {

					// Deduct point for adding a phone number if subscription is enabled
					if ((!isset($get_profile_metadata['phone']) || empty($get_profile_metadata['phone'])) && isset($datebook_get_data['phone']) && !empty($datebook_get_data['phone'])) {

						$subscriptionplan_id = isset($datebook_get_subscriptionplan['subscription_id']) && $datebook_get_subscriptionplan['subscription_id'] > 1 ? $datebook_get_subscriptionplan['subscription_id'] : (isset($default_subscription_plan) ? $default_subscription_plan : '');

						$points_for_enter_phone = isset($get_subscription_plans[$subscriptionplan_id]['points_for_enter_phone']) ? $get_subscription_plans[$subscriptionplan_id]['points_for_enter_phone'] : 0;

						if($points_for_enter_phone > 0){
							if($points_for_enter_phone < mycred_get_users_balance($current_user_id)){
								mycred_add( 'subscription', $current_user_id, -$points_for_enter_phone, 'Points deducted for adding a phone number' );
							} else {
								unset($datebook_get_data['phone']);
								// Show points not enough and phone not saved alert
								$datebook_alert_text['phone_not_allowed'] = esc_html__( 'You do not have enough points for adding a phone number', 'datebook' );
							}
						}
					}

					// Deduct point for adding a website URL if subscription is enabled
					if ((!isset($get_profile_metadata['website']) || empty($get_profile_metadata['website'])) && isset($datebook_get_data['website']) && !empty($datebook_get_data['website'])) {

						$subscriptionplan_id = isset($datebook_get_subscriptionplan['subscription_id']) && $datebook_get_subscriptionplan['subscription_id'] > 1 ? $datebook_get_subscriptionplan['subscription_id'] : (isset($default_subscription_plan) ? $default_subscription_plan : '');

						$points_for_enter_website = isset($get_subscription_plans[$subscriptionplan_id]['points_for_enter_website']) ? $get_subscription_plans[$subscriptionplan_id]['points_for_enter_website'] : 0;

						if($points_for_enter_website > 0){
							if($points_for_enter_website < mycred_get_users_balance($current_user_id)){
								mycred_add( 'subscription', $current_user_id, -$points_for_enter_website, 'Points deducted for adding a website URL' );
							} else {
								unset($datebook_get_data['website']);
								// Show points not enough and website not saved alert
								$datebook_alert_text['website_not_allowed'] = esc_html__( 'You do not have enough points for adding a website URL', 'datebook' );
							}
						}
					}
				}


				$datebook_alert_text['success_profile_updated'] = esc_html__( 'Profile has been updated', 'datebook' );

				// Update the edited content
				if ($suspend_profile_after_edit == 1 || $suspend_profile_after_edit == 2) {
					$datebook_alert_text['success_profile_updated'] .= '. ' . esc_html__( 'Your new text will be published after moderator approval', 'datebook' ) . '.';
					if (isset($get_aboutyou)) {
						$profile_edited_content .= $get_aboutyou;
					}
				}


				// If user changed his email then let's send email activation link to his new email
				if($auth_after_registration == 0 && isset($datebook_get_data['emailaddress'])){

					if($emailaddress != $datebook_get_data['emailaddress']){

						$datebook_get_data['emailaddress_temp'] = $datebook_get_data['emailaddress'];

					}
				}
				
				global $wp_locale_all, $datebook_reserved_fields;
				
				// get languages
				$languages_array = array();

				$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

				$languages = DateBook_Localization::datebook_all_available_language_files();

				foreach($languages as $language) {
					if($language['checked'] == 1){
						$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
					}
				}

				// Get profile form
				$get_profile_form_fields = get_option('datebook_profile_form');
				$get_profile_form_fields = isset($get_profile_form_fields[$whatform]) ? $get_profile_form_fields[$whatform] : ($get_profile_form_fields ? $get_profile_form_fields : array());

				// Get custom fields
				$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

				$datebook_profiletypes = array();
				$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
				foreach ($profiletypes_array as $key => $value ){
					$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
				}
				$profiletypes = implode("\r\n", $datebook_profiletypes);

				foreach ($all_custom_fields as $key => $value) {
					if(isset($datebook_reserved_fields[$key])){
						//unset($all_custom_fields[$key]);
						$datebook_reserved_fields[$key] = array(
							'slug' => $key, 
							'type' => $whatform == 'search_form_other' && isset($datebook_reserved_fields[$key]['type_search']) && !empty($datebook_reserved_fields[$key]['type_search']) ? $datebook_reserved_fields[$key]['type_search'] : $datebook_reserved_fields[$key]['type'], 
							'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
							'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
							'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
							'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
							'limittext' => $value['limittext']
						);

						foreach ( $languages_array as $language_key => $language_name ) {

							if (isset($value['name_' . $language_key])) {
								$datebook_reserved_fields[$key]['name_' . $language_key] =  $value['name_' . $language_key];
							}
							if (isset($value['field_items_' . $language_key])) {
								if($key == 'profiletypereserved'){
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $profiletypes;
								} else {
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $value['field_items_' . $language_key];
								}
							}
						}
					}
				}

				// Merge custom and reserved fields
				$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);

				foreach($datebook_get_data as $key => $value) {

					if($key == 'aboutyou') continue;

					// sanitize data in array
					if (is_array($value)) {
						$value = array_map( 'sanitize_text_field', $value );
					} else {
						if(ctype_digit($value) && (int)$value > 0 || $key == 'wishtravel'){}else{
							//$profile_edited_content .= $value . "\r\n";
						}
						if(isset($get_profile_custom_fields[$key]['type']) && ($get_profile_custom_fields[$key]['type'] == 'text' || $get_profile_custom_fields[$key]['type'] == 'textarea')){
							
							$text_max_chars = isset($get_profile_custom_fields[$key]['limittext']) && $get_profile_custom_fields[$key]['limittext'] > 0 ? $get_profile_custom_fields[$key]['limittext'] : 1000000;
							$value_ready = isset($value) ? substr(implode( "\n", array_map( 'sanitize_textarea_field', explode( "\n", $value ) ) ), 0, $text_max_chars) : '';

							$value = DateBook_Utilities::datebook_word_filter($value_ready); // Replace prohibited words by * sign

							if(isset($value) && !empty($value) && $key != 'user'){
								$profile_edited_content .= $value . "\r\n";
							}
						}
					}

					//Alter the options array appropriately
					$get_profile_metadata[sanitize_key($key)] = $value;

					$get_profile_metadata['edit_form'][sanitize_key($key)] = $value;

				}

				if(isset($get_profile_metadata['profile_must_complete']) && $get_profile_metadata['profile_must_complete'] == 1){
					$get_profile_metadata['profile_must_complete'] = 1;
				} else if(of_get_option('user_must_complete_profile') == '1' && $whatform == 'profile_form'){
					$get_profile_metadata['profile_must_complete'] = 1;
				} else if(of_get_option('user_must_complete_profile') < 1){
					$get_profile_metadata['profile_must_complete'] = 1;
				} else {
					$get_profile_metadata['profile_must_complete'] = 0;
				}


				// Update the post meta
				update_post_meta($profile_id, 'edit_form', $get_profile_metadata['edit_form']);

				// Update the post meta
				update_post_meta($profile_id, 'profile_personal_data', $get_profile_metadata);

				// Update profile
				wp_update_user($update_user_args);


				// Check if profile updated
				if($auth_after_registration == 0 && $select_email_template == 'profile_changed_to_admin' && of_get_option('receive_email_on_profile_update') == '1' && isset($profile_edited_content) && empty($profile_edited_content)){

					$send_email_notification = false;

				}


				// Send notification to administrator or profile
				if ($send_email_notification == true) {

					// Let's send email to User or Admin
					$datebook_email_var = array(
						'select_email_template' => $select_email_template,
						'profile_id' => $profile_id,
						'profile_name' => $datebook_get_data['profile_name'],
						'profile_get_permalink' => $profile_get_permalink,
						'user_login' => $user_login, 
						'emailaddress' => $datebook_get_data['emailaddress'], 
						'emailhashkey' => $emailhashkey
					);

					if (isset($datebook_get_data['newpass']) && strlen($datebook_get_data['newpass']) > 0) {

						$datebook_email_var['password'] = $datebook_get_data['newpass'];

					}

					set_query_var( 'datebook_email_var', $datebook_email_var );

					include DateBook_Template_Loader::locate( 'misc/email-templates' );

					$datebook_mail = DateBook_Utilities::datebook_email_send('', '', $send_to_this_email, $subject_in_email, $body);

				}


				// Again. If user changed his email then let's send email activation link to his new email
				if($auth_after_registration == 0 && isset($datebook_get_data['emailaddress'])){

					if($emailaddress != $datebook_get_data['emailaddress']){

						$datebook_get_data['emailaddress_temp'] = $datebook_get_data['emailaddress'];

						//set an email hash so the user needs to validate his email in order to use the site
						$emailhash = md5($current_user_id.$datebook_get_data['emailaddress']);

						$select_email_template = 'verify_new_email_to_profile';
						$send_to_this_email = $datebook_get_data['emailaddress'];
						$subject_in_email = esc_html__( 'Verify your email address', 'datebook' );

						$emailhashkey = add_query_arg( array(
							'verifynewemail' => $emailhash
						), $profile_get_permalink );


						// Let's send email to User or Admin
						$datebook_email_var = array(
							'select_email_template' => $select_email_template,
							'profile_id' => $profile_id,
							'profile_name' => $datebook_get_data['profile_name'],
							'profile_get_permalink' => $profile_get_permalink,
							'emailaddress' => $datebook_get_data['emailaddress'],
							'emailhashkey' => $emailhashkey
						);

						set_query_var( 'datebook_email_var', $datebook_email_var );

						include DateBook_Template_Loader::locate( 'misc/email-templates' );

						$datebook_mail = DateBook_Utilities::datebook_email_send('', '', $send_to_this_email, $subject_in_email, $body);

					}
				}

				// Unset these sensitive data not to save in open kind in profile_personal_data of wp_postmeta
				unset($datebook_get_data['user']);
				unset($datebook_get_data['newpass']);

				// Login after registration
				if ($auth_after_registration == 1 && !is_super_admin()) {
					//delete the cookies of the user if he is already logged in. for example if he is the admin
					wp_clear_auth_cookie();
					//add login cookies to the user so we can indentify him
					wp_set_auth_cookie($current_user_id, true, '');
					
					// Remember when user logged in
					$activity_time = strtotime(gmdate( 'Y-m-d H:i:s' ) . ' GMT');
					update_user_meta($current_user_id, 'login_time', $activity_time);

					// Detect page ID
					$page_id = get_the_ID();

					$check_profile_statuses_in_header = DateBook_Utilities::check_profile_statuses_in_header($page_id, $current_user_id);

					// Send email to Admin about a new profile
					if (of_get_option('email_when_register') == '1') {

						// Email
						$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');

						// Subject
						$subject_in_email = esc_html__('New profile has been registered', 'datebook');

						// Message
						$body = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!<br /><br />';
						$body .= esc_html__( 'A new profile has been registered', 'datebook' ) . '.<br />';
						$body .= esc_html__( 'Profile', 'datebook' ).': <a href="' . $profile_get_permalink . '">' . $profile_get_permalink . '</a>';

						// Send email to admin
						$datebook_mail = DateBook_Utilities::datebook_email_send(NULL, NULL, $to_email, $subject_in_email, $body);

					}

				}

				// Subscribe by default
				if (is_user_logged_in()) {
					// 1. Check a profile has a photo
					$profile_photo_id = 'yes';
					if(of_get_option('user_must_upload_photo') == '1'){
						$profile_photo_id = isset($get_profile_metadata['profile_photo_id']) ? $get_profile_metadata['profile_photo_id'] : '';
						$profile_photo_id_parse = explode('/', $profile_photo_id);
						$profile_photo_id = count($profile_photo_id_parse) > 1 ? $profile_photo_id_parse[1] : $profile_photo_id_parse[0];
					}

					// 2. Check a profile completed
					$profile_must_complete = of_get_option('user_must_complete_profile') ? (of_get_option('user_must_complete_profile') == '1' && isset($get_profile_metadata['profile_must_complete']) && $get_profile_metadata['profile_must_complete'] == 1 ? 1 : 0 ) : 1;

					// Send plan by POST and subscribe a new registered user
					if($emailhash == '' && $plans_count > 0 && $subscribe_invisible > 0 && $profile_photo_id != '' && $profile_must_complete == 1){

						$user_selected_subscription_plan = DateBook_Profile_Subscription::user_selected_subscription_plan($current_user_id);
						if($datebook_get_subscriptionplan == '' && $user_selected_subscription_plan == 0){

							$_POST['current_user_id'] = $current_user_id;
							$_POST['subscriptionplan'] = $default_subscription_plan;
							$_POST['subscriptionplan_period_key'] = 0;
							$_POST['subscribe_invisible'] = 1;
							$_POST['pay_gate'] = 'free';
							$_POST['action'] = 'payment_page';
							$_POST['payment_page'] = 3;
							$_POST['notredirect_to_subscription_page'] = 1;
							do_action('datebook_redirect_subscription_to_gateway');
						}
					}
				}

				// Redirect after registration
				if ($auth_after_registration == 1 && !is_super_admin()) {

					//This redirect is not required but could help if the blank page after registration appears.
					if (isset($page_id) && $page_id > 0 && of_get_option('registration_page') > 0 && $page_id == of_get_option('registration_page')) {
						$redirect_to_after_all = get_permalink(of_get_option('redirect_to_after_login'));
					} else if (isset($profile_id) && $profile_id > 0) {
						$redirect_to_after_all = $profile_get_permalink;
					} else {
						$redirect_to_after_all = home_url();
					}

					wp_redirect($redirect_to_after_all);

					exit();

				}


			} else {

				$datebook_alert_error = array();
				$datebook_alert_text = array();

				$datebook_alert_text['error_required_fields'] = esc_html__( 'Some required fields like email or/and password were not added in the form', 'datebook' );

				foreach($datebook_form_error->get_error_codes() as $code){

					$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
					$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);

				}

			}

		} else {

			$datebook_alert_error = array();
			$datebook_alert_text = array();

			$datebook_alert_text['error_required_fields'] = esc_html__( 'Please, fill in all required fields colored red', 'datebook' );

			foreach($datebook_form_error->get_error_codes() as $code){

				$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
				$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);

			}
		}
	}


	/**
	 * Render form
	 *
	 */
	public static function render_form($whatform, $current_user_id = 0) {

		global $wp_locale_all, $datebook_get_data, $datebook_field_titles, $datebook_gender_titles, $datebook_reserved_fields, $datebook_alert_error, $datebook_alert_text;

		set_query_var( 'datebook_field_titles', $datebook_field_titles );
		$datebook_field_titles = get_query_var( 'datebook_field_titles' );
		if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }
		
		$enable_phone = 1;
		$enable_website = 1;
		$term_id = 0;
		
		$datebook_get_aboutyou = '';
		
		$datebook_get_edit_form = array();

		$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

		$all_splans = get_option('datebook_subscription_plans');

		// If any field is left empty, add the error message to the error object
		$is_user_logged_in = is_user_logged_in() ? 1 : 0;

		if ($is_user_logged_in == 1 && $current_user_id > 0 && $whatform != 'search_form_other') {

			$profile_postid = get_user_meta( $current_user_id, 'profile_postid', true );

			$profile = get_post($profile_postid);

			$profile_id = isset($profile->ID) && $profile->ID > 0 ? $profile->ID : 0;

			if(isset($profile_id) && $profile_id > 0){

				//$action_register = isset( $_POST['action'] ) && $_POST['action'] == 'register' ? 1 : 0;

				$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
				$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

				$datebook_get_edit_form = isset($datebook_get_data['edit_form']) ? $datebook_get_data['edit_form'] : array();

				$current_user_not_admin = get_userdata($current_user_id);

				$datebook_get_data['user'] = isset($current_user_not_admin->user_login) ? $current_user_not_admin->user_login : '';

				$datebook_get_data['emailaddress'] = isset($current_user_not_admin->user_email) ? $current_user_not_admin->user_email : '';

				$datebook_get_data['city_id'] = get_post_meta($profile_id, 'city', true);

				if(isset($datebook_get_data['city_id'])){

					$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city_id'] );

					$datebook_get_data['country'] = isset($term_data->country) ? $term_data->country : '';
					$datebook_get_data['country_id'] = isset($term_data->country_id) ? $term_data->country_id : '';
					$datebook_get_data['region'] = isset($term_data->region) ? $term_data->region : '';
					$datebook_get_data['region_id'] = isset($term_data->region_id) ? $term_data->region_id : '';
					$datebook_get_data['city'] = isset($term_data->city) ? $term_data->city : '';
					$datebook_get_data['city_id'] = isset($term_data->city_id) ? $term_data->city_id : '';

				} else if(isset($datebook_get_data['region_id'])){

					$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city_id'] );

					$datebook_get_data['country'] = isset($term_data->country) ? $term_data->country : '';
					$datebook_get_data['country_id'] = isset($term_data->country_id) ? $term_data->country_id : '';
					$datebook_get_data['region'] = isset($term_data->region) ? $term_data->region : '';
					$datebook_get_data['region_id'] = isset($term_data->region_id) ? $term_data->region_id : '';

				}

				$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : (isset($datebook_get_data['dateyear']) && isset($datebook_get_data['datemonth']) && isset($datebook_get_data['dateday']) ? floor((time() - strtotime($datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday']))/31556926) : '');

				$datebook_get_data['sexualorientation'] = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';

				$term_list = wp_get_post_terms($profile_id, DATEBOOK_PROFILES_TAX, array('fields' => 'all'));
				$term_id = isset($term_list[0]->term_id) ? $term_list[0]->term_id : 0;
				
				// Get the edited content
				if(of_get_option('suspend_profile_after_edit') == 2){
					$datebook_get_aboutyou = get_post_meta($profile_id, 'edited_profile_content', true);
				}
				
			}

			if($enable_subscription == 1){

				// Get user subscription id
				$member_subscriptions = datebook_get_member_subscriptions( array( 'user_id' => $current_user_id ) );
				$member_splan_id = isset($member_subscriptions[0]->subscription_plan_id) ? $member_subscriptions[0]->subscription_plan_id : NULL;
				
				if(isset($all_splans[$member_splan_id]['subscription_id']) && isset($member_splan_id) && $member_splan_id > 0 && $all_splans[$member_splan_id]['subscription_id'] == $member_splan_id) {
					$enable_phone = isset($all_splans[$member_splan_id]['enter_phone']) && $all_splans[$member_splan_id]['enter_phone'] > 0 ? 1 : 0;
					$enable_website = isset($all_splans[$member_splan_id]['enter_website']) && $all_splans[$member_splan_id]['enter_website'] > 0 ? 1 : 0;
				}
			}
		}


		//Get profile form array
		$get_profile_form_fields = get_option('datebook_profile_form');
		$get_profile_form_fields = isset($get_profile_form_fields[$whatform]) ? $get_profile_form_fields[$whatform] : ($get_profile_form_fields ? $get_profile_form_fields : array());

		if(is_array($get_profile_form_fields)){

			// Subscription fields
			if(DateBook_Utilities::check_if_gateway_activated() == 1 && isset($_POST['subscriptionplan'])) {

				$datebook_get_subscriptionplan = isset($_POST['subscriptionplan']) && strlen($_POST['subscriptionplan']) > 1 ? $_POST['subscriptionplan'] : (strlen($profile_subscription_plan) > 1 ? $profile_subscription_plan : 0);

				$datebook_get_subscriptionplan_price = isset($_POST['subscriptionplan_price']) ? $_POST['subscriptionplan_price'] : (isset($datebook_get_data['subscriptionplan_price']) ? $datebook_get_data['subscriptionplan_price'] : 0);

				$subscription_period_number_key = isset($all_splans[$datebook_get_subscriptionplan]['register_period_number'][$datebook_get_subscriptionplan_price]) ? $all_splans[$datebook_get_subscriptionplan]['register_period_number'][$datebook_get_subscriptionplan_price] : 0;

				$subscription_period_key = $all_splans[$datebook_get_subscriptionplan]['register_period'][$datebook_get_subscriptionplan_price];

				$subscription_period_title = DateBook_Utilities::datebook_plural_text($subscription_period_number_key, $subscription_period_key);

				$subscription_price = isset($all_splans[$datebook_get_subscriptionplan]['price'][$datebook_get_subscriptionplan_price]) && $all_splans[$datebook_get_subscriptionplan]['price'][$datebook_get_subscriptionplan_price] > 0 ? DateBook_Profile_Subscription::datebook_format_money($all_splans[$datebook_get_subscriptionplan]['price'][$datebook_get_subscriptionplan_price]) . ' / ' . $subscription_period_title : esc_html__( 'no payment required', 'datebook' );

				?>

				<input type="hidden" name="subscriptionplan" value="<?php echo esc_attr($datebook_get_subscriptionplan); ?>" />
				<input type="hidden" name="subscriptionplan_price" value="<?php echo esc_attr($datebook_get_subscriptionplan_price); ?>" />

				<div class="form-group mt-0 mb-4">
					<label for="datebook-subscription-plan" class="col-form-label font-weight-bold"><?php esc_html_e( 'Subscription plan', 'datebook' ); ?>:</label> 

					<?php

					$subscripion_plan_title = isset($all_splans[$datebook_get_subscriptionplan]['name_' . DATEBOOK_WPLANG]) && !empty($all_splans[$datebook_get_subscriptionplan]['name_' . DATEBOOK_WPLANG]) ? $all_splans[$datebook_get_subscriptionplan]['name_' . DATEBOOK_WPLANG] : (isset($all_splans[$datebook_get_subscriptionplan]['name_en_US']) && !empty($all_splans[$datebook_get_subscriptionplan]['name_en_US']) ? $all_splans[$datebook_get_subscriptionplan]['name_en_US'] : '');

					if (!empty($subscripion_plan_title)) { ?>
						<label class="col-form-label"><?php echo esc_attr($all_splans[$datebook_get_subscriptionplan]['name_' . DATEBOOK_WPLANG]); ?> <?php if($subscription_price) { echo '('. esc_attr($subscription_price) . ')'; } ?></label>
					<?php } ?>
					
				</div>
				
			<?php }


			$datebook_alert_error_exists = isset($datebook_alert_error) ? 1 : 0;

			// get languages
			$languages_array = array();

			$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

			$languages = DateBook_Localization::datebook_all_available_language_files();

			foreach($languages as $language) {
				if($language['checked'] == 1){
					$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
				}
			}

			// Get custom fields
			$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

			$datebook_profiletypes = array();
			$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
			foreach ($profiletypes_array as $key => $value ){
				$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
			}
			$profiletypes = implode("\r\n", $datebook_profiletypes);

			foreach ($all_custom_fields as $key => $value) {
				if(isset($datebook_reserved_fields[$key])){
					unset($all_custom_fields[$key]);
					$datebook_reserved_fields[$key] = array(
						'slug' => $key, 
						'type' => $whatform == 'search_form_other' && isset($datebook_reserved_fields[$key]['type_search']) && !empty($datebook_reserved_fields[$key]['type_search']) ? $datebook_reserved_fields[$key]['type_search'] : $datebook_reserved_fields[$key]['type'], 
						'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
						'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
						'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
						'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
						'limittext' => $value['limittext'],

						'searchbyname' => isset($value['searchbyname']) && $value['searchbyname'] == 1 ? 1 : 0,
						'searchbyid' => isset($value['searchbyid']) && $value['searchbyid'] == 1 ? 1 : 0,
						'searchbyusername' => isset($value['searchbyusername']) && $value['searchbyusername'] == 1 ? 1 : 0,					
					);

					foreach ( $languages_array as $language_key => $language_name ) {
						
						$value_name = $whatform == 'search_form_other' && isset($value['name_search_' . $language_key]) && !empty($value['name_search_' . $language_key]) ? 'name_search_' . $language_key : (isset($value['name_' . $language_key]) && !empty($value['name_' . $language_key]) ? 'name_' . $language_key : 'name_en_US');

						if (isset($value_name)) {
							$datebook_reserved_fields[$key][$value_name] =  $value[$value_name];
						}
						
						$value_field_items = $whatform == 'search_form_other' && isset($value['field_items_search_' . $language_key]) && !empty($value['field_items_search_' . $language_key]) ? 'field_items_search_' . $language_key : (isset($value['field_items_' . $language_key]) && !empty($value['field_items_' . $language_key]) ? 'field_items_' . $language_key : 'field_items_en_US');
						
						if (isset($value_field_items)) {
							if($key == 'profiletypereserved'){
								$datebook_reserved_fields[$key][$value_field_items] =  $profiletypes;
							} else {
								$datebook_reserved_fields[$key][$value_field_items] =  $value[$value_field_items];
							}
						}
					}
				}
			}

			// Merge custom and reserved fields
			$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);
			
			function whatever($array, $key, $val) {
				foreach ($array as $item)
					if (isset($item[$key]) && $item[$key] == $val)
						return true;
				return false;
			}

			if(whatever($get_profile_form_fields, 'row_type', 'divider')){
				$divider_exists = 1;
			} else {
				$divider_exists = 0;
			}

			if($divider_exists == 1){
				echo '<div id="carouselExampleControls" class="carousel" data-interval="false">';
				echo '<div class="carousel-inner">';
			}

			unset($get_profile_form_fields['formname']);
			unset($get_profile_form_fields['formtitle']);
			
			$find_array_key_last = array_key_last($get_profile_form_fields);

			foreach($get_profile_form_fields as $superkey => $supervalue){

				if(isset($supervalue['name']) && $supervalue['name'] == 'row') {

					if($divider_exists == 1 && $superkey == 0 && isset($supervalue['row_type']) && $supervalue['row_type'] == 'column'){
						echo '<div class="carousel-item active">';
					} else if($divider_exists == 1 && $superkey > 0 && $supervalue['quantity_columns'] == 0 && isset($supervalue['row_type']) && $supervalue['row_type'] == 'divider'){
						echo '</div">';
						echo '<div class="carousel-item">';
					}

					if(isset($supervalue['children']) && !empty($supervalue['children']) && is_array($supervalue['children']) && $supervalue['quantity_columns'] > 0){

						if(isset($supervalue['quantity_columns']) && $supervalue['quantity_columns'] == 1){
							$input_columns = 'onecolumnrow';
							$input_title = 'onecolumntitle';
						} else if(isset($supervalue['quantity_columns']) && $supervalue['quantity_columns'] == 1){
							$input_columns = 'twocolumnrow';
							$input_title = 'twocolumntitle';
						} else {
							$input_columns = 'threecolumnrow';
							$input_title = 'threecolumntitle';
						}

						echo '<div class="row">';

						foreach($get_profile_custom_fields as $key => $field){

							if (isset($field['active']) && $field['active'] != 1) continue;
							if (isset($field['type']) && $field['type'] != 'title') continue;

							if (isset($supervalue['children'][0]['rowTitle']) && $supervalue['children'][0]['rowTitle'] == $key) {

								// if foreign language do not exist, then show title in English (en_US)
								$field['name'] = $whatform == 'search_form_other' && isset($field['name_search_' . DATEBOOK_WPLANG]) && !empty($field['name_search_' . DATEBOOK_WPLANG]) ? $field['name_search_' . DATEBOOK_WPLANG] : (isset($field['name_' . DATEBOOK_WPLANG]) && !empty($field['name_' . DATEBOOK_WPLANG]) ? $field['name_' . DATEBOOK_WPLANG] : $field['name_en_US']);

								echo '<div class="col-lg-12 col-md-12 col-sm-12">';
								echo '<h2>' . esc_attr($field['name']) . '</h2>';
								echo '</div>';

							}
						}

						$align_column_right = '';
						$key = 0;

						foreach ( $supervalue['children'] as $key => $columns ) {

							if(isset($columns['name']) && $columns['name'] == 'column'){

								if(isset($supervalue['quantity_columns']) && $supervalue['quantity_columns'] == 1){

									echo '<div class="col-lg-12 col-md-12 col-sm-12">';

								} else if(isset($supervalue['quantity_columns']) && $supervalue['quantity_columns'] == 2){

									echo '<div class="col-lg-6 col-md-6 col-sm-6">';

								} else {

									echo '<div class="col-lg-4 col-md-4 col-sm-4">';

								}

								if(isset($columns['children'])){

									foreach ( $columns['children'] as $key => $column ) {

										if(isset($get_profile_custom_fields[$column['slug']]) && isset($get_profile_custom_fields[$column['slug']]['active']) && $get_profile_custom_fields[$column['slug']]['active'] == 1) {

											$custom_field_data = $get_profile_custom_fields[$column['slug']];

											// if foreign language do not exist, then show title in English (en_US)
											$custom_field_data['name'] = $whatform == 'search_form_other' && isset($custom_field_data['name_search_' . DATEBOOK_WPLANG]) && !empty($custom_field_data['name_search_' . DATEBOOK_WPLANG]) ? $custom_field_data['name_search_' . DATEBOOK_WPLANG] : (isset($custom_field_data['name_' . DATEBOOK_WPLANG]) && !empty($custom_field_data['name_' . DATEBOOK_WPLANG]) ? $custom_field_data['name_' . DATEBOOK_WPLANG] : $custom_field_data['name_en_US']);

											$custom_field_data_required = isset($custom_field_data['required']) && $custom_field_data['required'] == 1 ? '' : ($whatform != 'search_form_other' ? '<small class="text-muted"> (' . esc_html__( 'optional', 'datebook' ) . ')</small>' : '');

											$datebook_alert_error_class = isset($datebook_alert_error[$column['slug']]) ? $datebook_alert_error[$column['slug']] : '';

											$custom_field_data['limittext'] = isset($custom_field_data['limittext']) && $custom_field_data['limittext'] > 0 ? $custom_field_data['limittext'] : 0;


											// Start displaying fields
											if($column['slug'] == 'profiletypereserved'){

												$term_id = isset($_POST['profiletypereserved']) && $_POST['profiletypereserved'] > 0 ? $_POST['profiletypereserved'] : (isset($datebook_get_data['profiletypereserved']) && $datebook_get_data['profiletypereserved'] > 0 ? $datebook_get_data['profiletypereserved'] : $term_id);

												if ($whatform == 'search_form_other') {
													$term_id = isset($_POST['profiletypereserved']) && $_POST['profiletypereserved'] > 0 ? $_POST['profiletypereserved'] : '';
												}

												$profile_type_title = isset($custom_field_data['name']) && !empty($custom_field_data['name']) ? $custom_field_data['name'] : esc_html__( 'Profile type', 'datebook' );

												if ($whatform == 'search_form_other' || $is_user_logged_in == 0 || $term_id == 0) {

													if($whatform == 'search_form_other' || $term_id == 0 || of_get_option('profiletype_order_in_registration') == 'profiletype_in_registration'){

														$args = array(
															'name'					=> 'profiletypereserved',
															'orderby'				=> 'term_id',
															'order'					=> 'ASC',
															'show_last_update'		=> 0,
															'style'					=> '',
															'show_count'			=> 0,
															'hide_empty'			=> 0,
															'use_desc_for_title'	=> 0,
															//'child_of'			=> $catMain->term_id,
															'exclude'				=> '',
															'exclude_tree'			=> '',
															'include'				=> '',
															'hierarchical'			=> true,
															'title_li'				=> '',
															'show_option_none'		=> $profile_type_title,
															'number'				=> NULL,
															'echo'					=> 0,
															'depth'					=> 1,
															'current_category'		=> 0,
															'hide_if_empty'			=> true,
															'selected'				=> $term_id,
															'pad_counts'			=> 0,
															'class'					=> 'custom-select',
															'taxonomy'				=> DATEBOOK_PROFILES_TAX
														);

														?>

														<div class="form-group mt-0 mb-4 <?php if (isset($datebook_alert_text['profiletypereserved'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['profiletypereserved'])); } ?>">

														<?php

														if(!empty(wp_dropdown_categories($args))){

															echo wp_dropdown_categories($args);

															if (isset($datebook_alert_text['profiletypereserved'])) {

																echo '<div class="is-invalid text-danger datebook-error-profiletypereserved">' . esc_attr($datebook_alert_text['profiletypereserved']) . '</div>';

															}
														}

														echo '</div>';

													} else {

														// Get categories as array
														echo '<input type="hidden" name="profiletypereserved" value="' . absint($term_id) . '" />';

													}

												} else if ($is_user_logged_in == 1) {

														// Get Profile types
														$categories = get_terms(array(
															'orderby' => 'term_id',
															'order' => 'ASC',
															'taxonomy' => DATEBOOK_PROFILES_TAX,
															'hide_empty' => false,
															'selected' => $term_id,
														));

														?>

													<div class="md-form mt-0 mb-4">

													<?php

													if(!empty($categories)){

														// Get categories as array
														echo '<input type="text" value="';

														foreach ( $categories as $category ) :
													
															if($category->term_id == $term_id){
																$term_names = get_term_meta($category->term_id, 'datebook_profiletype_' . DATEBOOK_WPLANG);
																$category_name = isset($term_names[0]) && !empty($term_names[0]) ? $term_names[0] : $category->name;
																echo esc_html($category_name);
															}

														endforeach;

														echo '" class="form-control" disabled="disabled" /><label for="datebook-birth" class="active font-weight-bold">' . $profile_type_title . '</label>';

														echo '<small class="form-text text-muted">' . esc_html__( 'Type is set only once during registration and cannot be changed', 'datebook' ) . '</small>';

													}
												
													echo '</div>';

												}

											} else if($column['slug'] == 'profilename'){

												$profile_name_type = of_get_option('profile_name_type');

												switch($profile_name_type) {
													case 1 : $profile_name_title = esc_html__( 'Name', 'datebook' ); break;
													case 2 : $profile_name_title = esc_html__( 'Title', 'datebook' ); break;
													case 3 : $profile_name_title = esc_html__( 'Username', 'datebook' ); break;
													default: $profile_name_title = esc_html__( 'Name', 'datebook' ); break;
												}

												if($profile_name_type < 3){

													$profile_name = isset($_POST['profile_name']) && !empty($_POST['profile_name']) && strlen($_POST['profile_name']) > 0 ? $_POST['profile_name'] : (isset($profile->post_title) && strlen($profile->post_title) > 0 ? $profile->post_title : (!empty($datebook_get_data['profile_name']) && strlen($datebook_get_data['profile_name']) > 0 ? $datebook_get_data['profile_name'] : ''));

													$characters_limit_profilename = of_get_option('characters_limit_profilename') ? of_get_option('characters_limit_profilename') : 1000;

													?>

													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['profile_name'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['profile_name'])); } ?>">

													<?php if (!empty($profile_name) && of_get_option('prohibit_name_change') == 1 && $is_user_logged_in == 1) { ?>
														<input id="datebook-profile-name" class="form-control" type="text" value="<?php if (!empty($profile_name)) { echo esc_html($profile_name); } ?>" disabled />
														<small class="form-text text-muted"><?php echo esc_html__( 'Name is set only once during registration and cannot be changed', 'datebook' ); ?></small>

													<?php } else { ?>

														<input id="datebook-profile-name" class="form-control" type="text" name="profile_name" value="<?php if (!empty($profile_name)) { echo esc_html($profile_name); } ?>" maxlength="<?php echo absint($characters_limit_profilename); ?>" />

													<?php } ?>

													<label for="datebook-profile-name" class="font-weight-bold"><?php echo esc_html($profile_name_title); echo $custom_field_data_required; ?></label>

													<?php
													if (isset($datebook_alert_text['profile_name'])) {
														echo '<div class="is-invalid text-danger datebook-error-profile-name">'.esc_attr($datebook_alert_text['profile_name'])."</div>";
													}
													?>
												
													</div>
											
												<?php
												}

											} else if($column['slug'] == 'countrycity'){ ?>

												<div class="md-form mt-0 mb-4 datebook-profile-country <?php if (isset($datebook_alert_text['city'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['city'])); } ?>">

													<?php

													$datebook_get_country = isset($_POST['country']) ? $_POST['country'] : (isset($datebook_get_data['country_id']) && $datebook_get_data['country_id'] > 0 ? $datebook_get_data['country_id'] : '');
													$datebook_get_region = isset($_POST['region']) ? $_POST['region'] : (isset($datebook_get_data['region_id']) && $datebook_get_data['region_id'] > 0 ? $datebook_get_data['region_id'] : '');
													$datebook_get_city = isset($_POST['city']) ? $_POST['city'] : (isset($datebook_get_data['city_id']) && $datebook_get_data['city_id'] > 0 ? $datebook_get_data['city_id'] : '');

													?>

													<input id="datebook-locationcountry" name="country" type="hidden" value="<?php echo esc_attr($datebook_get_country);?>" />
													<input id="datebook-locationregion" name="region" type="hidden" value="<?php echo esc_attr($datebook_get_region);?>" />
													<input id="datebook-locationcity" name="city" type="hidden" value="<?php echo esc_attr($datebook_get_city);?>" />

													<?php

													$search_countrycity = '';

													if (isset($_POST['countrycity']) && !empty($_POST['countrycity'])) {

														$search_countrycity = $_POST['countrycity'];

													} else {

														if (isset($datebook_get_data['city']) && !empty($datebook_get_data['city'])){
															$search_countrycity .= $datebook_get_data['city'] . ', ';
														}

														if (isset($datebook_get_data['region']) && !empty($datebook_get_data['region'])){
															$search_countrycity .= $datebook_get_data['region'] . ', ';
														}

														if (isset($datebook_get_data['country']) && !empty($datebook_get_data['country'])){
															$search_countrycity .= $datebook_get_data['country'];
														}

													}

													?>

													<input id="datebook-location" class="form-control datebook-search-btn" name="countrycity" readonly type="text" value="<?php echo esc_attr($search_countrycity);?>" aria-label="<?php esc_html_e( 'Location', 'datebook' ); ?>" data-toggle="modal" data-target="#dbmodalcountriespanel" post-type="profile" all-locations="<?php if(isset($whatform) && $whatform == 'search_form_other') { echo 0; } else { echo 1; } ?>" form-type="<?php if(isset($whatform)) { echo $whatform; } ?>" />

													<label for="datebook-location" class="font-weight-bold"><?php if(isset($custom_field_data['name']) && !empty($custom_field_data['name'])) { echo $custom_field_data['name']; } else { esc_html_e( 'Location', 'datebook' ); } echo $custom_field_data_required; ?></label>

													<?php echo DateBook_Search::datebook_countries_popup($whatform, 1); ?>

													<?php

													if (isset($datebook_alert_text['city'])) {
														echo '<div class="is-invalid text-danger datebook-error-location">'.esc_attr($datebook_alert_text['city'])."</div>";
													}

													?>

												</div>

											<?php

											} else if($column['slug'] == 'birthdate'){

												$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : (isset($datebook_get_data['dateyear']) && isset($datebook_get_data['datemonth']) && isset($datebook_get_data['dateday']) ? floor((time() - strtotime($datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday']))/31556926) : '');

												$register_age_min = of_get_option('register_age_min') > 0 ? of_get_option('register_age_min') : 18;
												$register_age_max = of_get_option('register_age_max') > 0 ? of_get_option('register_age_max') : 80;
												$startyear = date('Y') - $register_age_min;
												$endyear = date('Y') - $register_age_max;

												if (isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0 && isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0 && isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0 && of_get_option("allow_edit_birthdate") != '1' && $is_user_logged_in == 1) {

													?>

													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['birth'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['birth'])); } ?>">

													<?php

													echo '<input type="text" value="';

													if (isset($age) && $age > 0) {
														echo esc_attr($age) . ' ' . esc_html__( 'years old', 'datebook' ) . ' ';
													}

													if (isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0) {
														echo '('.esc_attr($datebook_get_data['dateday']).' ';
													}

													if (isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0) {

														if ($datebook_get_data['datemonth'] == '1') { esc_html_e( 'January', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '2') { esc_html_e( 'February', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '3') { esc_html_e( 'March', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '4') { esc_html_e( 'April', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '5') { esc_html_e( 'May', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '6') { esc_html_e( 'June', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '7') { esc_html_e( 'July', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '8') { esc_html_e( 'August', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '9') { esc_html_e( 'September', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '10') { esc_html_e( 'October', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '11') { esc_html_e( 'November', 'datebook' ); }
														if ($datebook_get_data['datemonth'] == '12') { esc_html_e( 'December', 'datebook' ); }

													}

													if (isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0) {

														for ($i=$startyear; $i>=$endyear; $i--) {
															if ($datebook_get_data['dateyear'] == $i) { echo ' ' . $i; }
														}

													}

													if (isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0 && isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0) {

														echo '), ' . wp_specialchars_decode(esc_html(DateBook_Profile_Settings::datebook_zodiac($datebook_get_data['dateday'], $datebook_get_data['datemonth'], 1, 1)), ENT_QUOTES );

													}

													echo '" id="datebook-birth" class="form-control" disabled="disabled" /><label for="datebook-birth" class="active font-weight-bold">' . esc_html__( 'Date of Birth', 'datebook' ) . ' ' . $custom_field_data_required . '</label>';

													echo '<small class="form-text text-muted">' .esc_html__( 'Date of birth is set only once during registration and cannot be changed', 'datebook' ) . '</small>';

												} else { ?>

													<div class="form-group mt-0 mb-4 <?php if (isset($datebook_alert_text['birth'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['birth'])); } ?>">

													<label for="datebook-birth" class="font-weight-bold"><?php if(isset($custom_field_data['name']) && !empty($custom_field_data['name'])) { echo $custom_field_data['name']; } else { esc_html_e( 'Date of Birth', 'datebook' ); } echo $custom_field_data_required; ?></label>

													<div id="datebook-birth" class="row">

														<div class="col-sm-4 <?php if (isset($datebook_alert_text['dateday'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['dateday'])); } ?>">
															<select name="dateday" id="datebook-dateday" class="custom-select mb-1 datebook-dateday">
																<option value=""><?php esc_html_e( 'Day', 'datebook' ); ?></option>
																<?php
																for ($i=1;$i<=31;$i+=1) {
																	$datebook_get_dateday = (isset($_POST['dateday']) && $_POST['dateday'] > 0) ? $_POST['dateday'] : (isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0 ? $datebook_get_data['dateday'] : '');
																	echo '<option value="'.$i.'" ';
																	if (isset($datebook_get_dateday) && $datebook_get_dateday == $i) {
																		echo ' selected="selected"';
																	}
																	echo '>'.$i.'</option>';
																	unset($selected);
																}
																?>
															</select>

														</div>
														<div class="col-sm-4 <?php if (isset($datebook_alert_text['datemonth'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['datemonth'])); } ?>">

														<?php

														$datebook_get_datemonth = (isset($_POST['datemonth']) && $_POST['datemonth'] > 0) ? $_POST['datemonth'] : (isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0 ? $datebook_get_data['datemonth'] : '');

														?>

														<select name="datemonth" id="datebook-datemonth" class="custom-select mb-1 datebook-datemonth">
															<option value=""><?php esc_html_e( 'Month', 'datebook' ); ?></option>
															<option value="1"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '1') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'January', 'datebook' ); ?></option>
															<option value="2"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '2') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'February', 'datebook' ); ?></option>
															<option value="3"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '3') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'March', 'datebook' ); ?></option>
															<option value="4"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '4') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'April', 'datebook' ); ?></option>
															<option value="5"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '5') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'May', 'datebook' ); ?></option>
															<option value="6"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '6') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'June', 'datebook' ); ?></option>
															<option value="7"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '7') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'July', 'datebook' ); ?></option>
															<option value="8"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '8') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'August', 'datebook' ); ?></option>
															<option value="9"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '9') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'September', 'datebook' ); ?></option>
															<option value="10"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '10') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'October', 'datebook' ); ?></option>
															<option value="11"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '11') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'November', 'datebook' ); ?></option>
															<option value="12"<?php if (isset($datebook_get_datemonth) && $datebook_get_datemonth == '12') { echo ' selected="selected"'; } ?>><?php esc_html_e( 'December', 'datebook' ); ?></option>
														</select>

													</div>
													<div class="col-sm-4 <?php if (isset($datebook_alert_text['dateyear'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['dateyear'])); } ?>">

														<select name="dateyear" id="datebook-dateyear" class="custom-select mb-1 datebook-dateyear">
															<option value=""><?php esc_html_e( 'Year', 'datebook' ); ?></option>

															<?php

															$datebook_get_dateyear = (isset($_POST['dateyear']) && $_POST['dateyear'] > 0) ? $_POST['dateyear'] : (isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0 ? $datebook_get_data['dateyear'] : '');

															for ($i = $startyear; $i >= $endyear; $i--) {
																echo '<option value="'.$i.'"';
																if (isset($datebook_get_dateyear) && $datebook_get_dateyear == $i) {
																	echo ' selected="selected"';
																}
																echo '>'.$i.'</option>';
																unset($selected);
															}
															?>
														</select>

													</div>
												</div>

												<?php

												if (isset($datebook_alert_text['dateday'])) {
													echo '<div class="is-invalid text-danger datebook-error-dateday">' . esc_attr($datebook_alert_text['dateday']) . '</div>';
												}
												if (isset($datebook_alert_text['datemonth'])) {
													echo '<div class="is-invalid text-danger datebook-error-datemonth">' . esc_attr($datebook_alert_text['datemonth']) . '</div>';
												}
												if (isset($datebook_alert_text['dateyear'])) {
													echo '<div class="is-invalid text-danger datebook-error-dateyear">' . esc_attr($datebook_alert_text['dateyear']) . '</div>';
												}
												if (isset($datebook_alert_text['birth'])) {
													echo '<div class="is-invalid text-danger datebook-error-birth">' . esc_attr($datebook_alert_text['birth']) . '</div>';
												}

											} ?>

											</div>

											<?php 

											} else if($column['slug'] == 'gender'){

												global $datebook_gender_titles;

												if (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0 && of_get_option('allow_edit_gender') != '1' && $is_user_logged_in == 1) {

													?>

													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['gender'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['gender'])); } ?>">

														<?php

														foreach ($datebook_gender_titles as $key => $value) {

															if ($datebook_get_data['gender'] == $key) {
																echo '<input id="datebook-gender" type="text" value="' . esc_html__( $value, 'datebook' ) . '" class="form-control" disabled />';
																echo '<label for="datebook-gender" class="font-weight-bold">' . esc_html__( 'Gender', 'datebook' ) . '</label>';

															}
														}

														?>

														<small class="form-text text-muted"><?php echo esc_html__( 'Gender is set only once during registration and cannot be changed', 'datebook' ); ?></small>

													<?php } else { ?>

														<div class="form-group mt-0 mb-4 datebook-search-panel <?php if (isset($datebook_alert_text['gender'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['gender'])); } ?>">

														<div class="btn-group d-flex btn-group-toggle datebook-register-panel datebook-search-other" data-toggle="buttons">
													
														<?php

														$datebook_get_gender = (isset($_POST['gender']) && $_POST['gender'] > 0) ? $_POST['gender'] : (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0 ? $datebook_get_data['gender'] : '');

														if (of_get_option('gender_allowed') != '') {
															$allowed_gender = of_get_option('gender_allowed');
														}

														// Add custom Genders
														if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {
															$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));
															foreach ($allowed_gender_other_array as $key => $value ){
																$allowed_gender[] = 1;
															}
														}

														$count_genders = count( array_keys( $allowed_gender, 1 )); // count active genders

														if(isset($count_genders) && $count_genders > 2 ) {

															echo '<select class="custom-select" name="gender">';

														}

														foreach ($datebook_gender_titles as $key => $value) {

															if(isset($allowed_gender[$key]) && $allowed_gender[$key] == 1){

																if ($key == 1) {
																	$gender_icon = 'female';
																} else if ($key == 2) {
																	$gender_icon = 'male';
																}

																if(isset($count_genders) && $count_genders > 2 ) {

																	?>

																	<option value="<?php echo sanitize_key($key); ?>"<?php if (isset($datebook_get_gender) && $datebook_get_gender == $key) { echo ' selected="selected"'; } ?>><?php echo esc_html__( $value, 'datebook' ); ?></option>

																<?php } else { ?>

																	<label for="<?php echo str_replace('/', '', $value); ?>" class="btn datebook-search-gender datebook-search-btn form-check-label w-100 waves-effect waves-light m-0 <?php if (isset($datebook_get_gender) && $datebook_get_gender == $key) { echo ' active'; } ?>" title="<?php echo sprintf( esc_html__( "%s", 'datebook' ), $value ); ?>">
																	<input type="radio" name="gender" value="<?php echo sanitize_key($key); ?>" id="<?php echo str_replace('/', '', $value); ?>"<?php if (isset($datebook_get_gender) && $datebook_get_gender == $key) { echo ' checked="checked"'; } ?> />

																	<?php if (isset($gender_icon)) { ?>

																		<i class="fas fa-<?php echo esc_attr($gender_icon);?> fa-lg mr-1"></i>

																	<?php } ?>

																	<span class="align-middle"><?php echo esc_html__( $value, 'datebook' ); ?></span>

																</label>
															
															<?php

															}
														}
													}

													if(isset($count_genders) && $count_genders > 2 ) {
														echo '</select>';
													}

													?>

												</div>

												<?php

												if (isset($datebook_alert_text['gender'])) {
													echo '<div class="is-invalid text-danger datebook-error-gender">' . esc_attr($datebook_alert_text['gender']) . "</div>";
												}

											} ?>

											</div>
										
											<?php 

											} else if($column['slug'] == 'sexualorientation'){

												if (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {

													$allowed_sexual_orientation = of_get_option('sexual_orientation_allowed');

													// Add custom Sexual Orientations
													if (of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {
														$sexual_orientation_allowed_other_array = explode('<br />', strtr(of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG), array('\r\n' => '<br />', '\r' => '<br />', '\n' => '<br />')));

														foreach ($sexual_orientation_allowed_other_array as $key => $value ){
															$allowed_sexual_orientation[] = 1;
														}
													}

													$sexualorientation = (isset($_POST['sexualorientation']) && $_POST['sexualorientation'] > 0) ? $_POST['sexualorientation'] : (isset($datebook_get_data['sexualorientation']) && $datebook_get_data['sexualorientation'] > 0 ? $datebook_get_data['sexualorientation'] : '');

													?>

													<div class="form-group mt-0 mb-4 <?php if (isset($datebook_alert_text['sexualorientation'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['sexualorientation'])); } ?>">

														<select id="datebook-sexualorientation" class="custom-select" name="sexualorientation">

														<option value=""><?php if(isset($custom_field_data['name']) && !empty($custom_field_data['name'])) { echo $custom_field_data['name']; } else { esc_html_e( 'Select sexual orientation', 'datebook' ); } echo $custom_field_data_required; ?></option>
														
														

														<?php 

														foreach ($datebook_sexualorientation_titles as $key => $value) {

															if(isset($allowed_sexual_orientation[$key]) && $allowed_sexual_orientation[$key] == 1){

															?>

															<option value="<?php echo sanitize_key($key); ?>" <?php if (isset($sexualorientation) && $sexualorientation == $key) { echo ' selected="selected"'; } ?>><?php echo esc_html__( $value, 'datebook' ); ?></option>

														<?php } } ?>

														</select>

														<?php

														if (isset($datebook_alert_text['sexualorientation'])) {

															echo '<div class="is-invalid text-danger datebook-error-sexualorientation">' . esc_attr($datebook_alert_text['sexualorientation']) . '</div>';

														}

														?>

													</div>

												<?php

												}
	
											} else if($column['slug'] == 'phone'){
											
												$phone = (isset($_POST['phone']) && $_POST['phone'] > 0) ? $_POST['phone'] : (isset($datebook_get_data['phone']) && !empty($datebook_get_data['phone']) ? $datebook_get_data['phone'] : '');

												?>

												<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['phone'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['phone'])); } ?>">

													<input type="text" name="phone" id="datebook-phone" value="<?php if (isset($phone)) { echo esc_attr($phone); } ?>" class="form-control" />
													<label for="datebook-phone" class="font-weight-bold"><?php if(isset($custom_field_data['name']) && !empty($custom_field_data['name'])) { echo $custom_field_data['name']; } else { esc_html_e( 'Phone', 'datebook' ); } echo $custom_field_data_required; ?></label>
													<?php 
													if (isset($datebook_alert_text['phone'])) {
														echo '<div class="is-invalid text-danger datebook-error-phone">'.esc_attr($datebook_alert_text['phone']).'</div>';
													}
													?>

												</div>

											<?php 
	
											} else if($column['slug'] == 'website'){

												$website = isset($_POST['website']) && strlen($_POST['website']) > 0 ? $_POST['website'] : (isset($datebook_get_data['website']) && strlen($datebook_get_data['website']) > 0 ? $datebook_get_data['website'] : '');

												?>

												<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['website'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['website'])); } ?>">

													<input type="text" name="website" id="datebook-website" value="<?php echo esc_url($website); ?>" class="form-control" />
													<label for="datebook-website" class="font-weight-bold"><?php if(isset($custom_field_data['name']) && !empty($custom_field_data['name'])) { echo $custom_field_data['name']; } else { esc_html_e( 'Website', 'datebook' ); } echo $custom_field_data_required; ?></label>

													<?php 
													if (isset($datebook_alert_text['website'])) {
														echo '<div class="is-invalid text-danger datebook-error-website">'.esc_attr($datebook_alert_text['website']) . '</div>';
													}
													?>

												</div>

											<?php 

											} else if($column['slug'] == 'email'){

												if (of_get_option('registration_method') == 1 || of_get_option('registration_method') == 2) { ?>

													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['emailaddress'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['emailaddress'])); } ?>">

													<input type="email" name="emailaddress" id="datebook-emailaddress" value="<?php if (isset($datebook_get_data['emailaddress'])) { echo sanitize_email($datebook_get_data['emailaddress']); } ?>" class="form-control" />
													<label for="datebook-emailaddress" class="font-weight-bold"><?php esc_html_e( 'Email', 'datebook' ); ?></label>

													<span class="datebook-checkemail"></span>
													<div class="clear"></div>

													<?php

													if (isset($datebook_get_data['emailaddress_temp'])) {

														echo '<div class="alert alert-warning p-2 small text-italic">' . esc_html__( 'You must verify a new address before it becomes active.', 'datebook' ) . ' ' . esc_attr($datebook_get_data['emailaddress_temp']) . '</div>';

													}

													if (isset($datebook_alert_text['emailaddress'])) {

														echo '<div class="is-invalid text-danger datebook-error-emailaddress">'.esc_attr($datebook_alert_text['emailaddress']) . '</div>';

													}

													?>

												</div>

												<?php }
	
											} else if($column['slug'] == 'user'){

												if (of_get_option('registration_method') == 1) {

													$min_characters_username = of_get_option('min_characters_username') ? of_get_option('min_characters_username') : 4;
													$max_characters_username = of_get_option('max_characters_username') ? of_get_option('max_characters_username') : 30;

													?>
												
													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['user'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['user'])); } ?>">

														<?php if ($is_user_logged_in == 1) { ?>
													
															<input id="datebook-user" type="text" name="user" value="<?php if (isset($datebook_get_data['user'])) { echo esc_attr($datebook_get_data['user']); } ?>" autocomplete="off" class="form-control" title="<?php echo esc_html__( 'Username is set only once during registration and cannot be changed', 'datebook' ); ?>" disabled />
															<label for="datebook-user" class="font-weight-bold"><?php esc_html_e( 'Username', 'datebook' ); ?> <small>(<?php echo sprintf( esc_html__( 'between %1$s and %2$s characters', 'datebook' ), $min_characters_username, $max_characters_username ); ?>)</small></label>
															<small class="form-text text-muted"><?php echo esc_html__( 'Username is set only once during registration and cannot be changed', 'datebook' ); ?></small>

														<?php } else { ?>

															<input id="datebook-user" type="text" name="user" value="<?php if (isset($datebook_get_data['user'])) { echo esc_attr($datebook_get_data['user']); } ?>" autocomplete="off" class="form-control" title="<?php echo esc_html__( 'Username is set only once during registration and cannot be changed', 'datebook' ); ?>" />
															<label for="datebook-user" class="font-weight-bold"><?php esc_html_e( 'Username', 'datebook' ); ?> <small>(<?php echo sprintf( esc_html__( 'between %1$s and %2$s characters', 'datebook' ), $min_characters_username, $max_characters_username ); ?>)</small></label>

															<div class="d-block datebook-checkuser"></div>

															<?php

															if (isset($datebook_alert_text['user'])) {
														
																echo '<div class="is-invalid text-danger datebook-error-user">'.esc_attr($datebook_alert_text['user']) . '</div>';
														
															}

														} ?>

													</div>

												<?php }

											} else if($column['slug'] == 'newpass'){

												if (of_get_option('let_users_set_pass') == 1) {
												
													$min_characters_password = of_get_option('min_characters_password') ? of_get_option('min_characters_password') : 4;
													$max_characters_password = of_get_option('max_characters_password') ? of_get_option('max_characters_password') : 50;

													?>
												
													<?php if ($is_user_logged_in == 1) { ?>
												
														<div id="datebook_show_password" class="md-form mt-0 mb-4 position-relative <?php if (isset($datebook_alert_text['currentpass'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['currentpass'])); } ?>">
												
															<a class="md-addon position-absolute grey-text" style="bottom:5px; right:5px;" data-position="right middle" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>

															<input type="password" name="currentpass" id="datebook-currentpass" value="<?php if (isset($_POST['currentpass'])) { echo esc_attr($_POST['currentpass']); } ?>" class="form-control" autocomplete="off" />
															<label for="datebook-currentpass" class="control-label font-weight-bold"><?php esc_html_e( 'Current password', 'datebook' ); ?></label>

															<?php

															if (isset($datebook_alert_text['currentpass'])) {

																echo '<div class="is-invalid text-danger datebook-error-currentpass">' . esc_attr($datebook_alert_text['currentpass']) . '</div>';

															}

															?>
													
														</div>

													<?php } ?>

													<div id="datebook_show_password" class="md-form mt-0 mb-4 position-relative <?php if (isset($datebook_alert_text['newpass'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['newpass'])); } ?>">

														<a class="md-addon position-absolute grey-text" style="bottom:5px; right:5px;" data-position="right middle" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
													
														<input type="password" name="newpass" id="datebook-newpass" value="<?php if (isset($_POST['newpass'])) { echo esc_attr($_POST['newpass']); } ?>" class="form-control" autocomplete="off" />
														<label for="datebook-newpass" class="font-weight-bold"><?php if ($is_user_logged_in == 1) { echo esc_html__( 'New password', 'datebook' ); } else { echo esc_html__( 'Password', 'datebook' ); } ?> <small>(<?php echo sprintf(esc_html__( 'between %1$s and %2$s characters', 'datebook' ), $min_characters_password, $max_characters_password); ?>)</small></label>

														<?php

														if (isset($datebook_alert_text['newpass'])) {

															echo '<div class="is-invalid text-danger datebook-error-newpass">' . esc_attr($datebook_alert_text['newpass']) . '</div>';

														}

														?>

													</div>

												<?php }

											} else if($column['slug'] == 'aboutyou'){

												$datebook_alert_error_aboutyou = isset($datebook_alert_error['aboutyou']) ? $datebook_alert_error['aboutyou'] : '';

												$aboutyou_max_chars = isset($custom_field_data['limittext']) && $custom_field_data['limittext'] > 0 ? $custom_field_data['limittext'] : 1000;

												$alert_text_awaiting_approval = 0;

												if($datebook_alert_error_exists == 1){

													if(isset($_POST['aboutyou']) && !empty($_POST['aboutyou']) && strlen($_POST['aboutyou']) > 0){
														$datebook_get_aboutyou = stripslashes($_POST['aboutyou']);
													} else if (of_get_option('suspend_profile_after_edit') == 2 && isset($datebook_get_aboutyou) && !empty($datebook_get_aboutyou)){
														$datebook_get_aboutyou = $datebook_get_aboutyou;
														$alert_text_awaiting_approval = 1;
													} else if (!empty($datebook_get_data['aboutyou']) && strlen($datebook_get_data['aboutyou']) > 0){
														$datebook_get_aboutyou = stripslashes($datebook_get_data['aboutyou']);
													} else {
														$datebook_get_aboutyou = '';
													}

												} else {

													if(of_get_option('suspend_profile_after_edit') == 2 && isset($datebook_get_aboutyou) && !empty($datebook_get_aboutyou)){
														$datebook_get_aboutyou = $datebook_get_aboutyou;
														$alert_text_awaiting_approval = 1;
													} else if (isset($profile->post_content)){
														$datebook_get_aboutyou = stripslashes($profile->post_content);
													} else if (!empty($datebook_get_data['aboutyou']) && strlen($datebook_get_data['aboutyou']) > 0){
														$datebook_get_aboutyou = stripslashes($datebook_get_data['aboutyou']);
													} else {
														$datebook_get_aboutyou = '';
													}

												}

												echo '<div class="form-group mt-0 mb-4 ' . esc_attr(sanitize_html_class($datebook_alert_error_aboutyou)) . '">';

												echo '<label for="datebook-' . $column['slug'] . '" class="control-label font-weight-bold">' . $custom_field_data['name'] . ' ' . $custom_field_data_required . '</label>';

													if($aboutyou_max_chars > 0) { ?>

														<span class="datebook-aboutyou label badge badge-light float-right" title="<?php esc_html_e( 'Number of characters allowed', 'datebook' ); ?>" data-textlimit="<?php echo absint($aboutyou_max_chars); ?>"><?php echo absint($aboutyou_max_chars); ?></span>

													<?php } ?>

													<div id="datebook-aboutyou-box">
														<textarea name="aboutyou" id="datebook-aboutyou" rows="5" cols="42" class="form-control" style="height:109px"><?php echo esc_textarea($datebook_get_aboutyou); ?></textarea>
													</div>

													<?php

													if ($alert_text_awaiting_approval == 1) {

														echo '<div class="alert alert-warning mt-1">' . esc_html__( 'Your new text is pending approval', 'datebook' ) . '</div>';

													}

													if (isset($datebook_alert_text['aboutyou'])) {

														echo '<em class="text-error">'.esc_attr($datebook_alert_text['aboutyou']).'</em>';

													}

													?>

												</div>

											<?php 

											} else if($column['slug'] == 'onlinestatus' && $whatform == 'search_form_other'){

												$search_online = isset($_REQUEST['online_status']) ? $_REQUEST['online_status'] : 0;

												?>

												<div class="form-group mt-0 mb-4 <?php if (isset($datebook_alert_text['online_status'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['online_status'])); } ?>">

													<div class="custom-control custom-checkbox">
														<input type="checkbox" name="online_status" class="custom-control-input datebook-online" id="datebook-online" value="1" <?php if ($search_online == 1) { echo ' checked="checked"'; }?>/>
														<label class="custom-control-label font-weight-bold" for="datebook-online"><?php esc_html_e( 'Online', 'datebook' ); ?></label>
													</div>

													<?php
													if (isset($datebook_alert_text['online_status'])) {
														echo '<div class="is-invalid text-danger datebook-error-online_status">'.esc_attr($datebook_alert_text['online_status'])."</div>";
													}
													?>

												</div>

											<?php 
												
											} else if($column['slug'] == 'searchbyname' && $whatform == 'search_form_other'){

												$searchbyname = isset($custom_field_data['searchbyname']) && $custom_field_data['searchbyname'] == 1 ? 1 : 0;
												$searchbyid = isset($custom_field_data['searchbyid']) && $custom_field_data['searchbyid'] == 1 ? 1 : 0;
												$searchbyusername = isset($custom_field_data['searchbyusername']) && $custom_field_data['searchbyusername'] == 1 ? 1 : 0;

												if ($searchbyname == 1 || $searchbyid == 1 || $searchbyusername == 1) {
													
													$search_comma = 0;

													$search_profilename_title = '';

													if ($searchbyname == 1) {

														$search_profilename_title .= esc_html__( 'Name', 'datebook' );

														$search_comma = 1;

													}

													if ($searchbyid == 1) {

														if ($search_comma > 0 && $searchbyusername == 0) {
															$search_profilename_title .= ' ' . esc_html__( 'or', 'datebook' ) . ' ';
														} else if ($search_comma > 0) {
															$search_profilename_title .= ', ';
														}

														$search_profilename_title .= esc_html__( 'ID', 'datebook' );

														$search_comma = 1;

													}

													if ($searchbyusername == 1) {

														if ($search_comma > 0) {
															$search_profilename_title .= ' ' . esc_html__( 'or', 'datebook' ) . ' ';
														}

														$search_profilename_title .= esc_html__( 'Username', 'datebook' );

													}

													$search_profilename = isset($_REQUEST['searchbyprofilename']) ? $_REQUEST['searchbyprofilename'] : '';

													$characters_limit_searchbyprofilename = isset($custom_field_data['limittext']) && $custom_field_data['limittext'] > 0 ? $custom_field_data['limittext'] : 1000;

													?>

													<div class="md-form mt-0 mb-4 <?php if (isset($datebook_alert_text['searchbyprofilename'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['searchbyprofilename'])); } ?>">

														<input id="datebook-searchbyprofilename" class="form-control" type="text" name="searchbyprofilename" value="<?php if (!empty($search_profilename)) { echo esc_html($search_profilename); } ?>" maxlength="<?php echo absint($characters_limit_searchbyprofilename); ?>" />

														<label for="datebook-searchbyprofilename" class="control-label font-weight-bold"><?php echo esc_attr($search_profilename_title); echo $custom_field_data_required; ?></label> 

														<?php
														if (isset($datebook_alert_text['searchbyprofilename'])) {
															echo '<div class="is-invalid text-danger datebook-error-searchbyprofilename">'.esc_attr($datebook_alert_text['searchbyprofilename'])."</div>";
														}
														?>

													</div>

												<?php }

											} else if(isset($datebook_reserved_fields[$column['slug']]['slug']) && $datebook_reserved_fields[$column['slug']]['slug'] == $column['slug']){

											} else {

												echo '<div class="form-group mt-0 mb-4 ' . esc_attr($datebook_alert_error_class) . '">';
												echo '<label for="datebook-' . $column['slug'] . '" class="control-label font-weight-bold">' . $custom_field_data['name'] . ' ' . $custom_field_data_required . '</label>';

												if(($custom_field_data['type'] == 'text' || $custom_field_data['type'] == 'textarea') && $custom_field_data['limittext'] > 0) {

													echo '<span class="datebook-' . $column['slug'] . ' label badge badge-light float-right" title="'. esc_html__( 'Number of characters allowed', 'datebook' ) . '" data-textlimit="' . esc_attr($custom_field_data['limittext']) . '">' . esc_attr($custom_field_data['limittext']) . '</span>';

												}

												echo '<div id="datebook-' . $column['slug'] . '-box">';

												// Render field
												self::render_field_in($whatform, $custom_field_data, $datebook_get_edit_form, $datebook_alert_error_exists);

												if (isset($datebook_alert_text[$column['slug']])) {
													echo '<em class="text-error">'.esc_attr($datebook_alert_text[$column['slug']])."</em>";
												}

												echo '</div>';
												echo '</div>';

											}
										}
									}
								}

								echo '</div>';

							}
						}

						echo '</div>';

					}

					if($divider_exists == 1 && $superkey == 0){

						echo '<div class="md-form text-center">';
						echo '<a class="carousel-control-next btn btn-light btn-lg w-auto" href="#carouselExampleControls" role="button" data-slide="next" style="opacity:1">' . esc_html__( 'Next', 'datebook' ) . '</a>';
						echo '</div>';
						echo '</div>';
					} else if($divider_exists == 1 && $superkey > 0 && $supervalue['quantity_columns'] > 0 && isset($supervalue['row_type']) && $supervalue['row_type'] == 'column' && $superkey == $find_array_key_last){
						echo '<div class="md-form text-center">';
						echo '<a class="carousel-control-prev btn btn-link btn-lg w-auto" style="opacity:1" href="#carouselExampleControls" role="button" data-slide="prev">' . esc_html__( 'Back', 'datebook' ) . '</a>';
						echo '<button type="submit" name="submit" class="btn btn-primary btn-lg" style="opacity:1">' . esc_html__( 'Submit', 'datebook' ) . '</button>';
						echo '</div>';

						if($whatform == 'registration_form') {
							echo '<div class="mt-5 datebook-terms-padding text-center">';

							echo sprintf('%s <a href="%s" target="_blank">%s</a>', esc_html__( 'By submitting data you agree to our', 'datebook' ), esc_url(get_permalink(of_get_option('terms_and_conditions_url'))), esc_html__('Terms and Conditions', 'datebook'));

							echo '</div>';
						}

						echo '</div>';

					} else if($divider_exists == 1 && $superkey > 0 && $supervalue['quantity_columns'] > 0 && isset($supervalue['row_type']) && $supervalue['row_type'] == 'column'){
						echo '<div class="md-form text-center">';
						echo '<a class="carousel-control-prev btn btn-link btn-lg w-auto" style="opacity:1" href="#carouselExampleControls" role="button" data-slide="prev">' . esc_html__( 'Back', 'datebook' ) . '</a>';
						echo '<a class="carousel-control-next btn btn-light btn-lg w-auto" style="opacity:1" href="#carouselExampleControls" role="button" data-slide="next">' . esc_html__( 'Next', 'datebook' ) . '</a>';
						echo '</div>';
						echo '</div>';
					}

				}
			}
			
			if($divider_exists == 1){
				echo '</div>';
				echo '</div>';
			}

			// Google reCaptcha
			if($is_user_logged_in == 0){

				$google_recaptcha = of_get_option('google_recaptcha');

				if ($google_recaptcha['2'] == '1') {

					$google_recaptcha_sitekey = of_get_option('google_recaptcha_sitekey') ? of_get_option('google_recaptcha_sitekey') : '';

					?>

					<div class="md-form">
						<div class="row justify-content-center">
							<div class="col g-recaptcha <?php if (isset($datebook_alert_text['wrong_recaptcha'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['wrong_recaptcha'])); } ?>" data-sitekey="<?php echo esc_attr($google_recaptcha_sitekey); ?>" style="width: 304px !important; max-width: 304px !important; margin: 0px; padding: 0px;"></div>

							<?php

							if (isset($datebook_alert_text['wrong_recaptcha'])) {
								echo '<div class="is-invalid text-danger">' . esc_attr($datebook_alert_text['wrong_recaptcha']) . '</div>';
							}

							?>

						</div>
					</div>

				<?php }
			}

			if($divider_exists == 0 && $whatform == 'registration_form') {
				echo '<div class="md-form text-center">';
				echo '<button type="submit" name="submit" class="btn btn-primary btn-lg">' . esc_html__( 'Submit', 'datebook' ) . '</button>';
				echo '</div>';
				
				?>
				
				<div class="datebook-terms-padding text-center">

				<?php

					echo sprintf('%s <a href="%s" target="_blank">%s</a>', esc_html__( 'By submitting data you agree to our', 'datebook' ), esc_url(get_permalink(of_get_option('terms_and_conditions_url'))), esc_html__('Terms and Conditions', 'datebook'));

				?>

				</div>
					
				<?php
			}

		}
	}

}

//DateBook_Profile_Edit::init($datebook_options_array);
//$dateBook_forms = new DateBook_Forms($datebook_options_array);