<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Front_Page
 *
 * @class DateBook_Front_Page
 * @package DateBook/Classes
 * @author Pagick Themes
 */

class DateBook_Front_Page {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_header', array( __CLASS__, 'process_header' ) );
		add_action( 'datebook_show_frontpage', array( __CLASS__, 'process_front_page' ) );

		add_shortcode( 'datebook_mosaic_normal_profiles', array( __CLASS__, 'process_mosaic_normal_profiles' ) );
		add_shortcode( 'datebook_top_profiles', array( __CLASS__, 'pre_process_top_profiles' ) );
		add_shortcode( 'datebook_countries', array( __CLASS__, 'pre_process_countries' ) );

	}


	/**
	 * Header page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_header() {

		// display welcome text
		echo DateBook_Template_Loader::load( 'pages/page-header' );

	}


	/**
	 * Show front welcome text
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_front_welcome_text() {

		if (of_get_option('welcome_text_' . DATEBOOK_WPLANG) != '') {

			// display welcome text
			return DateBook_Template_Loader::load( 'frontpage/front-welcome-text' );

		}

	}


	/**
	 * Show front normal profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function process_mosaic_normal_profiles() {

		$normal_on_front = of_get_option('normal_on_front');

		if (isset($normal_on_front['show']) && $normal_on_front['show'] == 1 && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$shown_normal_to_loggedin_users_only = DateBook_Utilities::datebook_show_to_logged_in_users($normal_on_front['show_to_loggedin_users']);

			if ($shown_normal_to_loggedin_users_only == 1) {
				
				global $datebook_field_titles;
				set_query_var( 'datebook_field_titles', $datebook_field_titles );
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}

				// display normal profiles
				return DateBook_Template_Loader::load( 'frontpage/front-normal-profiles' );

			}

		}

	}


	/**
	 * Return top profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_top_profiles($atts = array()) {

		$topad_on_front = of_get_option('topad_on_front');

		if (isset($topad_on_front['show']) && $topad_on_front['show'] == 1 && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$shown_topad_to_loggedin_users_only = DateBook_Utilities::datebook_show_to_logged_in_users($topad_on_front['show_to_loggedin_users']);

			if ($shown_topad_to_loggedin_users_only == 1) {

				global $datebook_field_titles;
				set_query_var( 'datebook_field_titles', $datebook_field_titles );

				$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;
				
				$shortcode_style = (isset($atts['style']) ? $atts['style'] : of_get_option("top_profiles_style")) ? of_get_option("top_profiles_style") : 1; // 1, 2, 3, 4
				
				$shortcode_quantity = of_get_option('topad_quantity') ? of_get_option('topad_quantity') : 6; // 6, 12

				$shortcode_round = (isset($atts['round']) ? $atts['round'] : of_get_option("top_round")) ? of_get_option("top_round") : 1; // 1, 2, 3

				$topad_on_front_with_images = 0;
				if ($is_shortcode == 0) {
					$topad_on_front_sections = of_get_option('topad_on_front');
					if (isset($topad_on_front_sections['with_images_only']) && $topad_on_front_sections['with_images_only'] == 1) {
						$topad_on_front_with_images = 1;
					}
				}
				$shortcode_with_images = isset($atts['with_images']) ? $atts['with_images'] : $topad_on_front_with_images; // 1, 0

				$shortcode_images_margin = (isset($atts['margin']) ? $atts['margin'] : of_get_option("top_margin")) ? of_get_option("top_margin") : '';
				$shortcode_images_padding = (isset($atts['padding']) ? $atts['padding'] : of_get_option("top_padding")) ? of_get_option("top_padding") : '';
				$shortcode_border_width = (isset($atts['border_width']) ? $atts['border_width'] : of_get_option("top_border_width")) ? of_get_option("top_border_width") : 0; // 0, 1
				$shortcode_border_style = (isset($atts['border_style']) ? $atts['border_style'] : of_get_option("top_border_style")) ? of_get_option("top_border_style") : 1; // 0, 1
				$shortcode_border_color = (isset($atts['border_color']) ? $atts['border_color'] : of_get_option("top_border_color")) ? of_get_option("top_border_color") : ''; // 0, random, #FF6600
				$shortcode_color_gamma = (isset($atts['color_gamma']) ? $atts['color_gamma'] : of_get_option("top_color_gamma")) ? of_get_option("top_color_gamma") : ''; // 0, random, #FF6600
				//$shortcode_shadow = isset($atts['shadow']) ? $atts['shadow'] : of_get_option("top_shadow") ? of_get_option("top_shadow") : 1; // 1, 2, 3, 4
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}

				$top_info_comments = 0;
				$top_info_images = 0;

				if ($is_shortcode == 0) {

					$top_info_sections = of_get_option('show_top_profile_details');

					if (isset($top_info_sections['comments']) && $top_info_sections['comments'] == 1) {
						$top_info_comments = 1;
					}

					if (isset($top_info_sections['images']) && $top_info_sections['images'] == 1) {
						$top_info_images = 1;
					}

				}

				$shortcode_comments = isset($atts['comments']) ? $atts['comments'] : $top_info_comments; // 0, 1
				$shortcode_moreimages = isset($atts['moreimages']) ? $atts['moreimages'] : $top_info_images; // 0, 1
				$shortcode_direction = isset($atts['direction']) ? $atts['direction'] : 'horizontal'; // horizontal, vertical
		
				$shortcode_slide = isset($atts['slide']) ? 1 : 0; // 0, 1

				$options = array(
					'shortcode' => $is_shortcode,
					'style' => $shortcode_style,
					'quantity' => $shortcode_quantity,
					'round' => $shortcode_round,
					'with_images' => $shortcode_with_images,
					'margin' => $shortcode_images_margin,
					'padding' => $shortcode_images_padding,
					'border_width' => $shortcode_border_width,
					'border_style' => $shortcode_border_style,
					'border_color' => $shortcode_border_color,
					'color_gamma' => $shortcode_color_gamma,
					//'shadow' => $shortcode_shadow,
					'comments' => $shortcode_comments,
					'moreimages' => $shortcode_moreimages,
					'direction' => $shortcode_direction,
					'slide' => $shortcode_slide
				);
		
	    		// return the Top profiles
				return DateBook_Template_Loader::load( 'frontpage/front-top-ad-profiles', $options );

			}
		}
	}


	/**
	 * Show front Top profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function process_top_profiles() {

		// display Top Ad profiles
		echo self::pre_process_top_profiles();	

	}


	/**
	 * Return list of countries
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_countries($atts = array()) {

		$countries_on_front = of_get_option('countries_on_front');

		if (isset($countries_on_front['show_countries']) && $countries_on_front['show_countries'] == 1 && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$shown_countries_to_loggedin_users_only = DateBook_Utilities::datebook_show_to_logged_in_users($countries_on_front['show_to_loggedin_users']);

			if ($shown_countries_to_loggedin_users_only == 1) {

				// display countries
				$is_shortcode = (!empty($atts) && is_array($atts) ? 1 : isset($atts['shortcode']) && $atts['shortcode'] == 1) ? 0 : 1;

				$shortcode_show_empty_countries = isset($countries_on_front['show_empty_countries']) && $countries_on_front['show_empty_countries'] > 0 ? 1 : 0;

				$shortcode_quantity = (isset($atts['showquantity']) ? $atts['showquantity'] : isset($countries_on_front['profiles_quantity']) && $countries_on_front['profiles_quantity'] > 0) ? 1 : 0; // 0, 1

				$shortcode_style = (isset($atts['style']) ? $atts['style'] : of_get_option('countries_style')) ? of_get_option('countries_style') : 1; // 1, 2, 3, 4
				
				$shortcode_genders = (isset($atts['genders']) ? $atts['genders'] : isset($countries_on_front['genders']) && $countries_on_front['genders'] > 0) ? 1 : 0; // 0, 1

				$shortcode_round = (isset($atts['round']) ? $atts['round'] : of_get_option('countries_round')) ? of_get_option('countries_round') : 1; // 1, 2, 3

				$countries_on_front_with_images = 0;
				if ($is_shortcode == 0) {
					if (isset($countries_on_front['with_flags']) && $countries_on_front['with_flags'] == 1) {
						$countries_on_front_with_images = 1;
					}
				}
				$shortcode_with_images = isset($atts['with_flag']) ? $atts['with_flag'] : $countries_on_front_with_images; // 1, 0

				$shortcode_padding = (isset($atts['padding']) ? $atts['padding'] : of_get_option("countries_padding")) ? of_get_option("countries_padding") : 1; // 1, 2
				$shortcode_border_width = (isset($atts['border_width']) ? $atts['border_width'] : of_get_option("countries_border_width")) ? of_get_option("countries_border_width") : 0; // 0, 1
				$shortcode_border_style = (isset($atts['border_style']) ? $atts['border_style'] : of_get_option("countries_border_style")) ? of_get_option("countries_border_style") : 1; // 0, 1
				$shortcode_border_color = (isset($atts['border_color']) ? $atts['border_color'] : of_get_option("countries_border_color")) ? of_get_option("countries_border_color") : ''; // 0, random, #FF6600
				$shortcode_color_gamma = (isset($atts['color_gamma']) ? $atts['color_gamma'] : of_get_option("countries_color_gamma")) ? of_get_option("countries_color_gamma") : ''; // 0, random, #FF6600
				//$shortcode_shadow = isset($atts['shadow']) ? $atts['shadow'] : of_get_option("countries_shadow") ? of_get_option("countries_shadow") : 1; // 1, 2, 3, 4
				$shortcode_slide = isset($atts['slide']) ? 1 : 0; // 0, 1

				$options = array(
					'shortcode' => $is_shortcode, 
					'style' => $shortcode_style,
					'show_empty_countries' => $shortcode_show_empty_countries,
					'quantity' => $shortcode_quantity, 
					'genders' => $shortcode_genders,
					'round' => $shortcode_round, 
					'with_flags' => $shortcode_with_images, 
					'padding' => $shortcode_padding, 
					'border_width' => $shortcode_border_width, 
					'border_style' => $shortcode_border_style, 
					'border_color' => $shortcode_border_color, 
					'color_gamma' => $shortcode_color_gamma, 
					//'shadow' => $shortcode_shadow, 
					'slide' => $shortcode_slide,
					

				);
		
	    		// return the list of countries
				return DateBook_Template_Loader::load( 'frontpage/countries-map', $options );

			}
		}
	}


	/**
	 * Show front countries
	 *
	 * @access public
	 * @return void
	 */
	public static function process_countries() {

		$atts = array('shortcode' => 0);

		// display countries
		echo self::pre_process_countries($atts);

	}


	/**
	 * Show front page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_front_page() {

		if(isset($_GET['datebook-moderation']) && $_GET['datebook-moderation'] == 'yes' && isset($_GET['moderation-page']) && $_GET['moderation-page'] == 'profiles' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)){

			// display Moderation page
			echo DateBook_Template_Loader::load( 'admin/moderator-profiles' );

		} else if(isset($_GET['datebook-moderation']) && $_GET['datebook-moderation'] == 'yes' && isset($_GET['moderation-page']) && $_GET['moderation-page'] == 'images' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)){

			// display Moderation page
			echo DateBook_Template_Loader::load( 'admin/moderator-images' );

		} else {

			echo self::datebook_show_front_welcome_text();

			echo self::process_mosaic_normal_profiles();

			echo self::process_top_profiles();

			echo self::process_countries();

		}
	}


}

//DateBook_Front_Page::init();
$dateBook_front_page_class = new DateBook_Front_Page($datebook_options_array);