<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Scripts
 *
 * @class DateBook_Scripts
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Scripts {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Initialize scripts
	 *
	 * @access public
	 * @return void
	 */
	public static function init() {

		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'datebook_enqueue_frontend' ), 10000 );

	}


	/**
	 * Enqueues the Google $font that is passed
	 */
	public static function options_typography_enqueue_google_font($font) {

		$font = explode(',', $font);
		$font = $font[0];

		// Certain Google fonts need slight tweaks in order to load properly
		// Like our friend "Raleway"
		if ( $font == 'Raleway' ){
			$font = 'Raleway:100';
		}

		$font = str_replace(' ', '+', $font);

		wp_enqueue_style( "options_typography_$font", 'https://fonts.googleapis.com/css?family=' . $font, false, null, 'all' );

	}

	
	/**
	 * Loads script and style files
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_enqueue_frontend() {

		$page_id = get_the_ID();

		// Load JavaScripts
		wp_enqueue_script('icheck', DATEBOOK_URL . 'assets/js/icheck.min.js', array(), false, true );
		
		wp_enqueue_script('bootstrap-select', DATEBOOK_URL . 'assets/js/bootstrap-select.min.js', array(), false, true );

		if ($page_id == of_get_option('my_tours_page') || is_super_admin()) {
			
			
			
			wp_enqueue_script('moment', DATEBOOK_URL . 'assets/js/moment.min.js', array(), false, true );
			wp_enqueue_script('pikaday', DATEBOOK_URL . 'assets/js/pikaday.js', array(), false, true );
			wp_enqueue_script('pikaday-settings', DATEBOOK_URL . 'assets/js/pikaday-settings.js', array('pikaday'), false, true );

			// Get global months
			global $datebook_month_titles;

			wp_localize_script( 'pikaday-settings', 'datebook_date_translation', array(
				'datebook_january' => esc_html__( $datebook_month_titles[1], 'datebook' ),
				'datebook_february' => esc_html__( $datebook_month_titles[2], 'datebook' ),
				'datebook_march' => esc_html__( $datebook_month_titles[3], 'datebook' ),
				'datebook_april' => esc_html__( $datebook_month_titles[4], 'datebook' ),
				'datebook_may' => esc_html__( $datebook_month_titles[5], 'datebook' ),
				'datebook_june' => esc_html__( $datebook_month_titles[6], 'datebook' ),
				'datebook_july' => esc_html__( $datebook_month_titles[7], 'datebook' ),
				'datebook_august' => esc_html__( $datebook_month_titles[8], 'datebook' ),
				'datebook_september' => esc_html__( $datebook_month_titles[9], 'datebook' ),
				'datebook_october' => esc_html__( $datebook_month_titles[10], 'datebook' ),
				'datebook_november' => esc_html__( $datebook_month_titles[11], 'datebook' ),
				'datebook_december' => esc_html__( $datebook_month_titles['12'], 'datebook' ),

				'datebook_monday' => esc_html__( $datebook_month_titles[14], 'datebook' ),
				'datebook_tuesday' => esc_html__( $datebook_month_titles[15], 'datebook' ),
				'datebook_wednesday' => esc_html__( $datebook_month_titles[16], 'datebook' ),
				'datebook_thursday' => esc_html__( $datebook_month_titles[17], 'datebook' ),
				'datebook_friday' => esc_html__( $datebook_month_titles[18], 'datebook' ),
				'datebook_saturday' => esc_html__( $datebook_month_titles[19], 'datebook' ),
				'datebook_sunday' => esc_html__( $datebook_month_titles[13], 'datebook' ),

				'datebook_mon' => esc_html__( $datebook_month_titles[21], 'datebook' ),
				'datebook_tue' => esc_html__( $datebook_month_titles[22], 'datebook' ),
				'datebook_wed' => esc_html__( $datebook_month_titles[23], 'datebook' ),
				'datebook_thu' => esc_html__( $datebook_month_titles[24], 'datebook' ),
				'datebook_fri' => esc_html__( $datebook_month_titles[25], 'datebook' ),
				'datebook_sat' => esc_html__( $datebook_month_titles[26], 'datebook' ),
				'datebook_sun' => esc_html__( $datebook_month_titles[20], 'datebook' ),

				'datebook_previous_month' => esc_html__( 'Previous Month', 'datebook' ),
				'datebook_next_month' => esc_html__( 'Next Month', 'datebook' )
			));
			
			$delete_profile_confirm = "
				function datebook_delete_profile() {
					var confirmdelete = confirm('" . esc_html__( 'Do you really want to delete this profile?', 'datebook' ) . "');
					if (confirmdelete) {
						return true;
					} else {
						return false;
					}
				}
			";

			wp_add_inline_script( 'jquery', $delete_profile_confirm );
		
		}


		global $is_IE;

		if ( !$is_IE && of_get_option('enable_retina_images') ) {
			wp_enqueue_script('retina', DATEBOOK_URL . 'assets/js/retina.min.js', array(), false, true );
		}
		
		
		wp_enqueue_style('bootstrap-select', DATEBOOK_URL . 'assets/css/bootstrap-select.min.css', false);

		if (of_get_option('kind_of_lightbox') == 'lightbox' && (get_post_type() == DATEBOOK_POST_TYPE && is_single() || $page_id == of_get_option('my_photos_page') || $page_id == of_get_option('my_verification_page'))){

			wp_enqueue_style('simple-lightbox', DATEBOOK_URL . 'assets/css/simplelightbox.min.css', false);
			wp_enqueue_script('simple-lightbox', DATEBOOK_URL . 'assets/js/simple-lightbox.js', array('jquery'), false, true );

			// Load inline script Simple Lightbox
			$datebook_lightbox_js = "
				jQuery(document).ready(function($) {
					'use strict';
					if($('.datebook-gallery a').length){
						$('.datebook-gallery a').simpleLightbox();
					}
				});
			";

			wp_add_inline_script('simple-lightbox', $datebook_lightbox_js);

		} else {

			wp_enqueue_style('blueimp', DATEBOOK_URL . 'assets/css/blueimp-gallery.min.css', false);
			wp_enqueue_script('blueimp', DATEBOOK_URL . 'assets/js/blueimp-gallery.min.js', array('jquery'), false, true );

			$datebook_lightbox_js = "
				jQuery(document).ready(function($) {
					'use strict';	
					$(document).on('click', '#blueimp-gallery-links', function(event) {
						if (!$(event.target).closest('#blueimp-gallery-links button').length) {
							event = event || window.event;
							var target = event.target || event.srcElement, 
							link = target.src ? target.parentNode : target, 
							options = {index: link, event: event}, 
							links = this.getElementsByTagName('a');
							blueimp.Gallery(links, options);
						}
					});
				});
			";
			
			wp_add_inline_script('blueimp', $datebook_lightbox_js);

		}
		
		wp_enqueue_script('swiper', DATEBOOK_URL . 'assets/js/swiper-bundle.min.js', array('jquery'), false, true );
		wp_enqueue_script('datebook-script-plugin', DATEBOOK_URL . 'assets/js/datebook-script-plugin.js', array(), false, true );
		wp_enqueue_script('datebook-ajax-script', DATEBOOK_URL . 'assets/js/datebook-ajax-script.js', array('jquery'), false, true );

		if (is_user_logged_in() && of_get_option('contact_method') != '3') {

			if (isset($_GET['action']) && $_GET['action'] == 'read' && (is_user_logged_in() || is_super_admin())) {

				wp_enqueue_script('datebook-messages-ajax', DATEBOOK_URL . 'assets/js/datebook-messages-ajax.js', array('jquery'), false, false );

			} else {

				wp_enqueue_script('datebook-ajax-logged', DATEBOOK_URL . 'assets/js/datebook-messages-ajax-logged.js', array('jquery'), false, true );

			}

		} else {

			if ($page_id == of_get_option('login_page') || $page_id == of_get_option('registration_page')) {
				$google_recaptcha = of_get_option('google_recaptcha');

				if ($google_recaptcha['1'] == '1' || $google_recaptcha['2'] == '1') {
					wp_enqueue_script('google-recaptcha', 'https://www.google.com/recaptcha/api.js', array(), false, true );
				}
			}
		}

		if ((is_front_page() && of_get_option( 'age_range_front' ) == 'ionrangeslider') || (!is_front_page() && of_get_option( 'age_range_other' ) == 'ionrangeslider') && $page_id == of_get_option('search_results_page')){

			wp_enqueue_style('rangeSlider', DATEBOOK_URL . 'assets/css/ion.rangeSlider.css', false);
			wp_enqueue_script('rangeSlider', DATEBOOK_URL . 'assets/js/ion.rangeSlider.min.js', array(), false, true );

			// Set age range on Search form
			$datebook_agedefault_min = of_get_option('register_age_min') > 0 ? of_get_option('register_age_min') : 18;
			$datebook_agedefault_max = of_get_option('register_age_max') > 0 ? of_get_option('register_age_max') : 80;

			if(isset($_REQUEST['agerange'])){
				$register_age_arr = explode('-', $_REQUEST['agerange']);
				$datebook_agerange_min = $register_age_arr[0];
				$datebook_agerange_max = $register_age_arr[1];
			} else {
				$datebook_agerange_min = $datebook_agedefault_min;
				$datebook_agerange_max = $datebook_agedefault_max;
			}

			wp_localize_script( 'datebook-script-plugin', 'datebook_agerange', array(
				'datebook_agedefault_min' => trim($datebook_agedefault_min),
				'datebook_agedefault_max' => trim($datebook_agedefault_max),
				'datebook_agerange_min' => trim($datebook_agerange_min),
				'datebook_agerange_max' => trim($datebook_agerange_max)
			));
			
			$age_range_layout = of_get_option('age_range_layout') ? of_get_option('age_range_layout') : 'round';


			// Show age range slider on Search form
			$datebook_rangeSlider_js = "
				jQuery(document).ready(function($) {
					'use strict';	
					$('#datebook-agerange').ionRangeSlider({
						type: 'double',
						min: datebook_agerange.datebook_agedefault_min,
						max: datebook_agerange.datebook_agedefault_max,
						from: datebook_agerange.datebook_agerange_min,
						to: datebook_agerange.datebook_agerange_max,
						hide_min_max: false,
						hide_from_to: false,
						grid: false,
						keyboard: true,
						keyboard_step: 1,
						input_values_separator: ' - ',
						skin: '" . esc_attr($age_range_layout) . "'
					});
					
					$('#datebook-agerange').removeClass('irs-hidden-input');
					
					$(document).on('click', '#datebook-agerange', function(){
						$('.js-irs-0').slideToggle('fast');
					});
				});
			";

			wp_add_inline_script('rangeSlider', $datebook_rangeSlider_js);

		}


		if ($page_id == of_get_option('my_photos_page') && is_user_logged_in()) {
			$page_ajax = get_permalink(of_get_option('my_photos_page'));
		} else if (($page_id == of_get_option('classifiedspage_addpost') || $page_id == of_get_option('my_classifieds_page')) && is_user_logged_in()) {
			$page_ajax = get_permalink(of_get_option('classifiedspage_addpost'));
		} else {
			$page_ajax = home_url();
		}

		$page_my_messages_ajax = get_permalink(of_get_option('my_messages_page'));

		$chat_sound = of_get_option('chat_custom_sound');
		if($chat_sound){
			$chat_sound_path = $chat_sound;
		} else {
			$chat_ready_sound = of_get_option('chat_ready_sound') ? of_get_option('chat_ready_sound') : 'chat-01';
			$chat_sound_path = DATEBOOK_URL . 'assets/sounds/' . $chat_ready_sound . '.ogg';
		}
		
		$display_new_message_popup = of_get_option('display_new_message_popup') ? of_get_option('display_new_message_popup') * 1000 : 0;

		wp_localize_script( 'datebook-ajax-script', 'datebookajaxlocal', array(
			'ajax_url' => esc_url($page_ajax),
			'ajax_my_messages_url' => esc_url($page_my_messages_ajax),
			'path_to_sound' => $chat_sound_path,
			'display_new_message_popup' => $display_new_message_popup,
		));


		if (is_user_logged_in() && of_get_option('logout_idle_user') > 0) {

			$login_url = add_query_arg( array(
				'action' => 'logout'
			), get_permalink(of_get_option('login_page')) );

			wp_enqueue_script('datebook-idle-script', DATEBOOK_URL . 'assets/js/datebook-idle-script.js', array('jquery'), false, true );

			wp_localize_script( 'datebook-idle-script', 'datebook_logout_url', array(
				'datebook_idle_time' => of_get_option('logout_idle_user'),
				'ajax_url' => esc_url($login_url)
			));

		}


		// Set width and height of chat window
		$chat_width = of_get_option('chat_width') > 0 ? of_get_option('chat_width') : 780;
		$chat_height = of_get_option('chat_height') > 0 ? of_get_option('chat_height') : 500;

		$chat_update_period = of_get_option('chat_update_period') > 0 ? of_get_option('chat_update_period') * 1000 : 5000;

		wp_localize_script( 'datebook-script-plugin', 'datebook_chat_window', array(
			'datebook_chat_width' => trim($chat_width),
			'datebook_chat_height' => trim($chat_height),
			'datebook_chat_update_period' => $chat_update_period
		));


		if (of_get_option('enable_reviews') == '1') {
			wp_enqueue_style( 'dashicons' );

			wp_register_style( 'datebook-reviews', DATEBOOK_URL . 'assets/css/datebook-reviews.css' );
			wp_enqueue_style( 'datebook-reviews' );

			wp_register_script( 'datebook-reviews', DATEBOOK_URL . 'assets/js/datebook-reviews.js', array( 'jquery' ) );
			wp_enqueue_script( 'datebook-reviews' );
		}


		// Load CSS Styles
		if (is_user_logged_in()) {

			wp_enqueue_style('pikaday', DATEBOOK_URL . 'assets/css/pikaday.css', false);

			wp_enqueue_style('swiper', DATEBOOK_URL . 'assets/css/swiper-bundle.min.css', false);

		}
		wp_enqueue_style('datebook-social-buttons', DATEBOOK_URL . 'assets/css/datebook-social-buttons.css', false);

		if ( ! current_theme_supports( 'datebook-custom-styles' ) ) {
			wp_enqueue_style('datebook-style-plugin', DATEBOOK_URL . 'assets/css/datebook-style-plugin.css', array( 'datebook-style-theme' ) );
		}

		if (of_get_option('datebook_color_schemes')  && of_get_option('datebook_color_schemes') != 'Default') {
			wp_enqueue_style('datebook-datebook-color', DATEBOOK_URL . 'assets/css/colors/' . of_get_option('datebook_color_schemes') . '.css', array( 'datebook-style-plugin' ) );
		}

		// Internet Explorer 6, 7, 8 style
		wp_enqueue_style('datebook-ie-plugin', DATEBOOK_URL . 'assets/css/datebook-ie-plugin.css', false);
		wp_style_add_data( 'datebook-ie-plugin', 'conditional', 'lt IE 9' );


		// Load Google Fonts
		$all_google_fonts = array_keys( options_typography_get_google_fonts() );

		// Define all the options that possibly have a unique Google font
		$datebook_font = array();
		$datebook_font[] = of_get_option('typography_body');
		$datebook_font[] = of_get_option('typography_h1');
		$datebook_font[] = of_get_option('typography_h2');
		$datebook_font[] = of_get_option('typography_h3');
		$datebook_font[] = of_get_option('typography_h4');
		$datebook_font[] = of_get_option('typography_h5');
		$datebook_font[] = of_get_option('typography_h6');
		$datebook_font[] = of_get_option('typography_lead');
		$datebook_font[] = of_get_option('typography_blockquote');
		$datebook_font[] = of_get_option('top_menu_font_front');
		$datebook_font[] = of_get_option('top_menu_font_other');
		$datebook_font[] = of_get_option('primary_menu_font_front');
		$datebook_font[] = of_get_option('primary_menu_font_other');
		$datebook_font[] = of_get_option('user_menu_font_front');
		$datebook_font[] = of_get_option('user_menu_font_other');
		$datebook_font[] = of_get_option('welcome_slogan_font');

		// Get the font face for each option and put it in an array
		if($datebook_font){

			// If it is a Google font, go ahead and call the function to enqueue it
			foreach ( $datebook_font as $key => $font ) {
				if ( in_array( $font['face'], $all_google_fonts ) ) {
					self::options_typography_enqueue_google_font($font['face']);
				}
			}
		}


		// Load Custom Style
		$upload_dir = wp_upload_dir();
		$cache_dir = trailingslashit( $upload_dir['basedir'] ) . DATEBOOK_OPTIONS_FOLDER;

		if (file_exists($cache_dir . '/' . DATEBOOK_CUSTOM_STYLE . '.css')) {

			$css_saved_time = date("ymd-Gis", filemtime($cache_dir . '/' . DATEBOOK_CUSTOM_STYLE . '.css'));

			$style_url = trailingslashit( $upload_dir['baseurl'] ) . DATEBOOK_OPTIONS_FOLDER;
			wp_enqueue_style('datebook-custom', $style_url . '/' . DATEBOOK_CUSTOM_STYLE . '.css', array('datebook-style-plugin'), $css_saved_time);

		}
	}

}

//DateBook_Scripts::init();
$dateBook_scripts_class = new DateBook_Scripts($datebook_options_array);