<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Blog Categories

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_categories_widgets' );

// Categories widget.
function datebook_categories_widgets() {
	register_widget( 'DateBook_Categories_widget' );
}

// Widget class.
class DateBook_Categories_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-categories-widget', 'description' => esc_html__( 'Displays categories of blog.', 'datebook' ) );

		parent::__construct( 'datebook_categories_widget', esc_html__( 'DateBook: Categories', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['categories_count'] = (int)$new_instance['categories_count'];
		$instance['taxonomy'] = strip_tags($new_instance['taxonomy']);
		$instance['sort_by'] = strip_tags($new_instance['sort_by']);

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Categories',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = isset( $instance['title'] ) ? $instance['title'] : '';
		$categories_count = (isset($instance['categories_count']) && (int)$instance['categories_count'] > 0) ? (int)$instance['categories_count'] : 10;
		$taxonomy = !empty($instance['taxonomy']) ? strip_tags($instance['taxonomy']) : '';
		$sort_by = !empty($instance['sort_by']) ? strip_tags($instance['sort_by']) : 'ascending';

		?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'datebook' ) ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>	
		<label for="<?php echo esc_attr($this->get_field_id('taxonomy')); ?>"><?php esc_html_e( 'Choose the Taxonomy to display', 'datebook' ); ?></label> 
		<?php $taxonomies = get_taxonomies(array('public'=>true), 'names'); ?>
		<select id="<?php echo esc_attr($this->get_field_id('taxonomy')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('taxonomy')); ?>">
			<?php foreach ($taxonomies as $key => $option): ?>
			<option value="<?php echo sanitize_key($key); ?>" <?php if ($taxonomy == $key ) { echo 'selected="selected"'; } ?>><?php echo esc_attr($option);?></option>
			<?php endforeach; ?>
		</select>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('sort_by')); ?>"><?php esc_html_e( 'Sort by', 'datebook' );?></label>
			<?php $answers = array('ASC' => 'A-Z','DESC' => 'Z-A'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('sort_by')); ?>" name="<?php echo esc_attr($this->get_field_name('sort_by')); ?>">
				<?php foreach ($answers as $key => $answer ): ?>
				<option <?php if ($sort_by == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key); ?>"><?php echo esc_attr($answer); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		
		<p>
		<label for="<?php echo esc_attr($this->get_field_id('categories_count')); ?>"><?php esc_html_e("Number of Categories", 'datebook' );?>:</label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('categories_count')); ?>" name="<?php echo esc_attr($this->get_field_name('categories_count')); ?>" step="1" min="1" value="<?php echo esc_attr($categories_count); ?>" size="3" type="number">
		</p>

		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$posts_per_page = ((int)$instance['categories_count'] > 0) ? (int)$instance['categories_count'] : 10;
		$taxonomy = strip_tags($instance['taxonomy']); // the taxonomy to display

		$sort_by = '';
		if(!empty($instance['sort_by']) && is_array($instance['sort_by'])):
			$sort_by =  array_filter($instance['sort_by']);
		elseif(!empty($instance['sort_by'])):
			$sort_by = explode(',',$instance['sort_by']);
		endif;
		

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display Widget */
		$args = array(
			'number' 	=> $posts_per_page,
			'taxonomy'	=> $taxonomy
		);
		
		// retrieves an array of categories or taxonomy terms
		$cats = get_categories($args);
		?>
		<!-- sidebar -->
		<h4 class="mb-0 datebook-title-aside"><?php esc_html_e( 'Categories', 'datebook' ); ?></h4>
		<hr />
		<ul class="list-unstyled">
			<?php foreach($cats as $cat) { ?>
			<li><a href="<?php echo get_term_link($cat->slug, $taxonomy); ?>" title="<?php sprintf( esc_html__( 'View all posts in %s ', 'datebook' ), $cat->name ); ?>"><?php echo esc_attr($cat->name); ?></a></li>
			<?php } ?>
		</ul>
		<!-- /sidebar -->

		<?php echo $after_widget; ?>

		<?php
	}

}