<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Classifieds

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_classifieds_widgets' );

// Register widget.
function datebook_classifieds_widgets() {
	register_widget( 'DateBook_Classifieds_widget' );
}

// Widget class.
class DateBook_Classifieds_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-classifieds-widget', 'description' => esc_html__( 'Displays latest classifieds.', 'datebook' ) );

		parent::__construct( 'datebook_classifieds_widget', esc_html__( 'DateBook: Classifieds', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['classifieds_count'] = strip_tags($new_instance['classifieds_count']);
		$instance['sort_by'] = strip_tags($new_instance['sort_by']);
		$instance['enabled_image'] = !empty($new_instance['enabled_image']) ? 1 : 0;
		$instance['enabled_date'] = !empty($new_instance['enabled_date']) ? 1 : 0;
		$instance['style'] = strip_tags($new_instance['style']);

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Classifieds',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$classifieds_count = (isset($instance['classifieds_count']) && (int)$instance['classifieds_count'] > 0) ? (int)$instance['classifieds_count'] : 5;
		$sort_by = !empty($instance['sort_by']) ? strip_tags($instance['sort_by']) : 'descending';
		$enabled_image = isset($instance['enabled_image']) ? (bool) $instance['enabled_image'] : false;
		$enabled_date = isset($instance['enabled_date']) ? (bool) $instance['enabled_date'] : false;
		$style = !empty($instance['style']) ? strip_tags($instance['style']) : 1;
		?>

		<!-- Widget Title: Text Input -->

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'datebook' ) ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('sort_by')); ?>"><?php esc_html_e('Sort by date', 'datebook' );?></label>
			<?php $answers = array('DESC' => 'Descending','ASC' => 'Ascending','RAND' => 'Random'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('sort_by')); ?>" name="<?php echo esc_attr($this->get_field_name('sort_by')); ?>">
				<?php foreach ($answers as $key => $answer ): ?>
				<option <?php if ($sort_by == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_attr($answer);?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id('posts_count')); ?>"><?php esc_html_e("Number of Classifieds", 'datebook' );?>:</label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('classifieds_count')); ?>" name="<?php echo esc_attr($this->get_field_name('classifieds_count')); ?>" step="1" min="1" value="<?php echo esc_attr($classifieds_count); ?>" size="3" type="number">
		</p>
		<p>
			<input type="checkbox"  id="<?php echo esc_attr($this->get_field_id('enabled_image'));?>" name="<?php echo esc_attr($this->get_field_name('enabled_image'));?>" <?php checked($enabled_image); ?> /> <?php esc_html_e("Show Image", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox"  id="<?php echo esc_attr($this->get_field_id('enabled_date')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_date')); ?>" <?php checked($enabled_date); ?> /> <?php esc_html_e("Show Date", 'datebook' );?>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('style')); ?>"><?php esc_html_e('Style', 'datebook' );?></label>
			<?php $styles = array('1' => '1 style','2' => '2 style','3' => '3 style'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('style')); ?>" name="<?php echo esc_attr($this->get_field_name('style')); ?>">
				<?php foreach ($styles as $key => $value ): ?>
				<option <?php if ($style == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_attr($value);?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$posts_per_page = ((int)$instance['classifieds_count'] > 0) ? (int)$instance['classifieds_count'] : 10;
		$enabled_image = isset($instance['enabled_image']) ? (bool)$instance['enabled_image'] : 0;
		$enabled_date = isset($instance['enabled_date']) ? (bool)$instance['enabled_date'] : 0;
		$style = isset($instance['style']) ? $instance['style'] : 1;
		
		$sort_by = '';
		if(!empty($instance['sort_by']) && is_array($instance['sort_by'])):
			$sort_by =  array_filter($instance['sort_by']);
		elseif(!empty($instance['sort_by'])):
			$sort_by = explode(',', $instance['sort_by']);
		endif;
		
		/* Display Widget */

		global $datebook_gender_titles;

		$args = array(
			'post_type' => DATEBOOK_CLASSIFIEDS_TYPE,
			'post_status' => 'publish',
			'orderby'  => 'date',
			'order' => $sort_by,
			'posts_per_page' => $posts_per_page
		);

		$the_query = new WP_Query( $args );
		
		if ( $the_query->have_posts() ) :
		
			/* Before widget (defined by themes). */
			echo $before_widget;
			?>

			<!-- sidebar -->
			<div class="card-header">

				<h4 class="mb-0 datebook-title-aside"><?php esc_html_e( 'Classifieds', 'datebook' ); ?></h4>

			</div>
		
			<?php

			$search_default_thumbnail = of_get_option('search_default_thumbnail') ? 1 : 0;

			$show_age = DateBook_Utilities::datebook_show_field('birthdate', 1) ? 1 : 0;

			$show_sexual_orientation = (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

			$show_gender = (DateBook_Utilities::datebook_show_field('gender', 1) && (of_get_option('gender_allowed') != '' || of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

			$show_location = DateBook_Utilities::datebook_show_field('countrycity', 1) ? 1 : 0;

			while ( $the_query->have_posts() ) : $the_query->the_post();

				$classified_id = absint(get_the_ID());

				// Get profile id
				$profile_classifieds_id = get_post_meta($classified_id, 'profile_classifieds_id', true);
				$profile_data = get_post($profile_classifieds_id);

				if (isset($profile_data->ID) && $profile_data->ID > 0 && isset($profile_data->post_status) && $profile_data->post_status == 'publish') {
				
					$profile_id = isset($profile_data->ID) ? $profile_data->ID : '';

					$profile_title = isset($profile_data->post_title) ? $profile_data->post_title : '';

					$gender = get_post_meta($profile_id, 'gender', true);
				
					if ($gender == 1) {
						$gender_icon = 'fa fa-venus';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars';
					} else {
						$gender_icon = 'fa fa-user';
					}


					$birthday = get_post_meta($profile_id, 'birthday', true);
					$age = !empty($birthday) ? floor((time() - strtotime($birthday))/31556926) : '';

					$city_id = get_post_meta($profile_id, 'city', true);

					if(isset($city_id)){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
						$city = isset($term_data->city) ? $term_data->city : '';
						$country = isset($term_data->country) ? $term_data->country : '';

					}

					if (get_post_meta($classified_id,'classifieds_offer_direction', true) == 'offering') {

						$classifieds_offer_direction = esc_html__( 'offering a classifieds', 'datebook' );

					}

					if (get_post_meta($classified_id,'classifieds_offer_direction', true) == 'looking') {

						$classifieds_offer_direction = esc_html__( 'looking for a classifieds', 'datebook' );

					}
					
					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_classifieds_sidebar', $gender, true, '', $search_default_thumbnail);

					// display the Classified template
					if ($style == 1) {

						include DateBook_Template_Loader::locate( 'widgets/classifieds-1' );

					} else if ($style == 2) {

						include DateBook_Template_Loader::locate( 'widgets/classifieds-2' );

					} else if ($style == 3) {

						include DateBook_Template_Loader::locate( 'widgets/classifieds-3' );

					}

				}

			endwhile;

			/* After widget (defined by themes). */
			echo $after_widget;

		endif;

		wp_reset_postdata();

	}

}