<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Featured Profile

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_featured_profile_widgets' );

// Register widget.
function datebook_featured_profile_widgets() {
	register_widget( 'DateBook_Featured_Profile_widget' );
}

// Widget class.
class DateBook_Featured_Profile_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-featured-profile-widget', 'description' => esc_html__( 'Displays one Featured profile.', 'datebook' ) );

		parent::__construct( 'datebook_featured_profile_widget', esc_html__( 'DateBook: Featured Profile', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = !empty($new_instance['title']) ? strip_tags( $new_instance['title'] ) : '';
		$instance['show_name'] = !empty($new_instance['show_name']) ? 1 : 0;
		$instance['show_details'] = !empty($new_instance['show_details']) ? 1 : 0;
		$instance['posts_per_page'] = !empty($new_instance['posts_per_page']) ? ($new_instance['posts_per_page']) : 1;

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Featured Profile',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$show_name = isset($instance['show_name']) ? (bool) $instance['show_name'] : false;
		$show_details = isset($instance['show_details']) ? (bool) $instance['show_details'] : false;
		$posts_per_page = isset($instance['posts_per_page']) ? (int) $instance['posts_per_page'] : 1;
		
		?>

		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('show_name')); ?>" name="<?php echo esc_attr($this->get_field_name('show_name')); ?>" <?php checked($show_name); ?> /> <?php esc_html_e("Show Profile Name", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('show_details')); ?>" name="<?php echo esc_attr($this->get_field_name('show_details')); ?>" <?php checked($show_details); ?> /> <?php esc_html_e("Show Details (age, gender, city, country)", 'datebook' );?>
		</p>
        <p>
		<label for="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>"><?php esc_html_e("Number of profiles", 'datebook' );?>:</label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>" name="<?php echo esc_attr($this->get_field_name('posts_per_page')); ?>" step="1" min="1" value="<?php echo esc_attr($posts_per_page); ?>" size="3" type="number">
		</p>

		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {

		$featured_enabled_sections = of_get_option('featured_enabled');

		if (isset($featured_enabled_sections['show']) && $featured_enabled_sections['show'] == 1) {

			extract( $args );

			/* Our variables from the widget settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$show_name = isset($instance['show_name']) ? (bool)$instance['show_name']:0;
			$show_details = isset($instance['show_details']) ? (bool)$instance['show_details']:0;
			$posts_per_page = isset($instance['posts_per_page']) ? $instance['posts_per_page'] : 1;

			$sidebar_quantity_featured_profiles = $posts_per_page ? array('posts_per_page' => $posts_per_page, 'before_widget' => $before_widget, 'after_widget' => $after_widget) : array('posts_per_page' => '1', 'before_widget' => '', 'after_widget' => '');

			/* Display Widget */

			/* sidebar */

			// display the Featured profile on sidebar
			echo DateBook_Template_Loader::load( 'widgets/featured-profiles-sidebar', $sidebar_quantity_featured_profiles );

			/* end of sidebar */

		}

	}

}