<?php
/**
 * Category Page
 */

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-9 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

<?php endif; ?>

		<div class="mb-3">
			<div class="datebook-blogs-page">

			<?php 

			if (is_category()){

				$current_category = single_cat_title('', false);

				if(isset($current_category)){

				?>

				<div class="datebook-custom-card card mb-3">
					<div class="card-body">

						<h1><?php echo esc_html($current_category); ?></h1>
						<span><?php echo esc_html__( 'You are on the category page', 'datebook' ); ?></span>

					</div>
				</div>

				<?php } ?>

			<?php } ?>

				<div class="mb-3 datebook-blogs-page">

				<?php if (get_theme_mod( 'datebook_masonry_style', 2 ) == 2) { ?>

					<div class="row masonry">
					<div class="grid-sizer col-md-3"></div>

				<?php } else { ?>

					<div class="card-columns">

				<?php } ?>

				<?php
				
				$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

				$category = get_queried_object();
				$category_id = isset($category->term_id) && $category->term_id > 0 ? $category->term_id : 0;

				$args = array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'paged' => $paged,
					'cat' => $category_id, //we can pass comma-separated ids here
				);

				$wp_query = new WP_Query( $args );

				if ( $wp_query->have_posts() ) {

					while ( $wp_query->have_posts() ) {

						$wp_query->the_post();
						
						get_template_part( 'templates/content-list/content', get_post_format() );

					}

				} else {
					
					esc_html__( 'No posts ', 'datebook' );
					
				}

				?>

				</div>

				</div>
			</div>

			<?php

			get_template_part( 'templates/post', 'pager' );
			
			wp_reset_postdata();
			
			?>

		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-3 col-sm-3 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-blogs' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-blogs');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->