<?php
/*
 * Profile Login form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_form_error, $datebook_alert_error, $datebook_alert_text;
		

if (of_get_option('login_method') == 1 && of_get_option('registration_method') == 1) {

	$login_email_title = esc_html__( 'Email or Username', 'datebook' );

} else if (of_get_option('login_method') == 2) {

	$login_email_title = esc_html__( 'Email', 'datebook' );

} else if (of_get_option('login_method') == 3 && of_get_option('registration_method') == 1) {

	$login_email_title = esc_html__( 'Username', 'datebook' );

} else {

	$login_email_title = esc_html__( 'Email', 'datebook' );

}

$login_url = get_permalink(of_get_option('login_page'));

?>

<!--Header-->
<div class="header">
	<div class="text-center">

		<h2><?php esc_html_e( 'Login', 'datebook' ); ?></h2>

	</div>
</div>
<!--Header-->
	
<div class="mt-4">

	<?php

		$google_recaptcha = of_get_option('google_recaptcha');

		if ( is_wp_error( $datebook_form_error ) ) {

			$datebook_alert_error = array();
			$datebook_alert_text = array();

		?>

	<div class="alert alert-danger text-center">

		<?php if($google_recaptcha['1'] == '1'){ ?>

		<ul class="pb-0 mb-0 text-left">

			<?php } ?>

			<?php 

				foreach($datebook_form_error->get_error_codes() as $code){

					$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
					$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);

					if($google_recaptcha['1'] == '1'){
						echo '<li>';
					}

					echo esc_attr($datebook_alert_text[$code]);

					if($google_recaptcha['1'] == '1'){
						echo '</li>';
					}

				}

				?>

			<?php if($google_recaptcha['1'] == '1'){ ?>

		</ul>

		<?php } ?>

	</div>

	<?php } ?>

	<?php if (isset($datebook_alert_text['success_login'])) { ?>

		<div class="alert alert-success text-center">

			<?php echo esc_attr($datebook_alert_text['success_login']); ?>

		</div>

		<?php } ?>

	<!--Body-->
	<form name="loginform" id="loginform" action="<?php echo esc_url($login_url); ?>" method="post" class="form-signin">

		<input type="hidden" name="testcookie" value="1" />

		<div class="md-form">
			<i class="fa fa-envelope prefix grey-text"></i>
			<input type="text" name="log" id="user_login" value="" class="form-control" />
			<label for="user_login">
				<?php echo esc_attr($login_email_title); ?>
			</label>
		</div>
		<div id="datebook_show_password" class="md-form position-relative">
			<i class="fa fa-lock prefix grey-text"></i>
			<a class="md-addon position-absolute grey-text" style="bottom:5px; right:5px;" data-position="right middle" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
			<input type="password" name="pwd" id="user_pass" value="" class="form-control" />
			<label for="user_pass">
				<?php esc_html_e( 'Password', 'datebook' ); ?>
			</label>
		</div>
		
		<p class="font-small grey-text d-flex justify-content-end">
			<a href="<?php echo esc_url(get_permalink(of_get_option('forgot_password_page'))); ?>" class="dark-grey-text font-weight-bold ml-1"><?php esc_html_e( 'Forgot?', 'datebook' ); ?></a>
		</p>

		<?php

		if ($google_recaptcha['1'] == '1') {

			$google_recaptcha_sitekey = of_get_option('google_recaptcha_sitekey') ? of_get_option('google_recaptcha_sitekey') : '';

			if ($google_recaptcha_sitekey) {

			?>

			<div class="mb-4">
				<div class="g-recaptcha" data-sitekey="<?php echo esc_attr($google_recaptcha_sitekey); ?>"></div>
			</div>

		<?php } } ?>

		<div class="text-center mt-4 mb-4">

			<button type="submit" name="submit" class="btn btn-primary btn-lg btn-block">
			<?php esc_html_e( 'Login', 'datebook' ); ?>
			</button>

		</div>

		<?php if (of_get_option('enable_profile_registration') == '1') { ?>

			<p class="font-small grey-text d-flex justify-content-center">
				<?php esc_html_e( 'Not registered yet?', 'datebook' ); ?> 
				<a href="<?php echo esc_url(get_permalink(of_get_option('registration_page'))); ?>" class="dark-grey-text font-weight-bold ml-1"><?php esc_html_e( 'Register', 'datebook' ); ?></a>
			</p>

		<?php } ?>

	</form>
</div>
