<?php
/**
 * Email templates
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

global $datebook_contact_text, $datebook_user_info;

$datebook_email_var = get_query_var( 'datebook_email_var' );
if ( is_array( $datebook_email_var ) ) { extract($datebook_email_var); }


// Header Welcome text, like this: Hello, Joe Dow!
if ($select_email_template == 'activation_link_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'Before you can use the site you will need to validate your email address.', 'datebook' );
	$sub_text = esc_html__( 'You must validate your email in order to communicate to other users', 'datebook' );

} else if ($select_email_template == 'profile_activated_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'Your profile has been activated', 'datebook' );

} else if ($select_email_template == 'profile_suspended_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'Your profile has been suspended', 'datebook' );

} else if ($select_email_template == 'profile_changed_to_admin') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Profile changes have been made by', 'datebook' ) . ' ' . $profile_name;

} else if ($select_email_template == 'verify_new_email_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'You recently requested to have the email address on your account changed.', 'datebook' );
	$sub_text = esc_html__( 'You can safely ignore and delete this email if you do not want to take this action.', 'datebook' );

} else if ($select_email_template == 'new_message_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'Someone viewed', 'datebook' );
	
	$body_text = ' <span style="font-family:Arial,sans-serif;font-size:16px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:16px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_html__( 'your profile', 'datebook' ) . '</a></span> 
              <span style="font-family:Arial,sans-serif;font-size:16px;color:#000001;"> ' . esc_html__( 'and sent a message!', 'datebook' ) . ' </span>';

} else if ($select_email_template == 'friend_request_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'You have received a friend request', 'datebook' ) . ' ' . sanitize_email(of_get_option('email_sitename'));

	$body_text = '<a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:16px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($profile_get_permalink) . '</a>';

} else if ($select_email_template == 'retrieve_password_message') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	$intro_text = esc_html__( 'You asked us to reset your password for your account.', 'datebook' );

} else if ($select_email_template == 'reply_to_classifieds_to_profile') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . $profile_name . '!';
	
	$intro_text = esc_html__( 'Someone viewed', 'datebook' );
	
	$body_text = '<span style="font-family:Arial,sans-serif;font-size:16px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:16px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_html__( 'your classifieds posting', 'datebook' ) . '</a></span> <span style="font-family:Arial,sans-serif;font-size:16px;color:#000001;"> ' . esc_html__( 'and sent a message!', 'datebook' ) . ' </span>';

} else if ($select_email_template == 'tour_changed_to_admin') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Tour has been edited by', 'datebook' ) . ' ' . $profile_name;

} else if ($select_email_template == 'tour_added_to_admin') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Tour has been added by', 'datebook' ) . ' ' . $profile_name;

} else if ($select_email_template == 'classified_changed_to_admin') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Classified ad has been edited by', 'datebook' ) . ' ' . $profile_name;

} else if ($select_email_template == 'classified_added_to_admin') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Classified ad has been added by', 'datebook' ) . ' ' . $profile_name;

} else if ($select_email_template == 'message_from_contactus_page') {

	$hello_name = esc_html__( 'Hello', 'datebook' ) . ', ' . esc_html__( 'Admin', 'datebook' ) . '!';
	$intro_text = esc_html__( 'Someone sent you a message through the contact page', 'datebook' );

}


if(of_get_option('logo_email')){
	$datebook_email_logo = of_get_option('logo_email');
} else {
	$datebook_email_logo = DATEBOOK_URL . 'assets/images/logo-email.png';
}




// Email Header
$body = '<table cellspacing="0" cellpadding="0" border="0" style="max-width:460px;">
  <tbody>
    <tr>
      <td width="1" height="10" colspan="3"></td>
    </tr>
    <tr>
      <td width="10" height="1"></td>
      <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;" align="left">
          <tbody>
		  <tr>
              <td align="left"><span style="font-family:Arial,sans-serif;font-size:26px;color:#000001;line-height:normal;"> ' . esc_html($hello_name) . '</span></td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="20"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
			<tr>
              <td valign="top" align="left">
			  
			  <span style="font-family:Arial,sans-serif;font-size:16px;color:#000001;"> ' . esc_html($intro_text) . '</span>';

			  if ($select_email_template == 'new_message_to_profile' || $select_email_template == 'reply_to_classifieds_to_profile') {
				 $body .= $body_text;
			  }
			  
			  $body .= '			  

              </td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="30"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td align="left"><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td align="left" valign="top"><table width="100%" align="left" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;table-layout:fixed;">
                          <tbody>

';



// Email template for Activating Profile. When someone must click on the activation link in the email to activate his profile.
if ($select_email_template == 'activation_link_to_profile' || $select_email_template == 'verify_new_email_to_profile') {

	$body .= '<tr>
				<td valign="top" align="left">
					<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Please, validate your email address by clicking the link bellow', 'datebook' ) . ': </span>
				</td>
			</tr>
			<tr>
				<td valign="top" align="left">
					<span style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($emailhashkey) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($emailhashkey) . '</a></span>
				</td>
			</tr>';

	if (of_get_option('let_users_set_pass') == '' && isset($password)) {

		$body .= '<tr>
					<td height="10"><div style="margin:0;padding:0;line-height:0;">  </div></td>
				</tr>
				<tr>
					<td valign="top" align="left">
						<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Password', 'datebook' ) . ': ' . esc_attr($password) . '</span>
					</td>
				</tr>';

	}

	$body .= '</tbody>
			</table></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="30"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td valign="top" align="left">
			  <span style="font-family:Arial,sans-serif;font-size:13px;color:#666666;">' . $sub_text . '</span>
			  </td>
            </tr>';
}

// Email template for Profile and Admin. When someone activates his profile.
if ($select_email_template == 'profile_activated_to_profile' || $select_email_template == 'profile_suspended_to_profile'){

	$body .= '<tr>
				<td valign="top" align="left">
				<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Profile', 'datebook' ) . ':<br />
				<span style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($profile_get_permalink) . '</a></span> 
				</td>
			</tr>
		</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>';
}


if ($select_email_template == 'profile_changed_to_admin' || $select_email_template == 'tour_changed_to_admin' || $select_email_template == 'tour_added_to_admin' || $select_email_template == 'classified_changed_to_admin' || $select_email_template == 'classified_added_to_admin') {

	if (isset($profile_edited_content) && !empty($profile_edited_content)) {

		$body .= '<tr>
					<td valign="top" align="left">
						<span style="font-family:Arial,sans-serif;font-size:16px;color:#000001; "> ' . esc_html__( 'Edited description', 'datebook' ) . ':</span>
					</td>
				</tr>
				<tr>
					<td valign="top" align="left">
					<p style="padding: 20px; background-color: #f5f5f5; background-clip: border-box; border: 1px solid rgba(0,0,0,.125); border-radius: .5rem;">
						<span style="font-family:Arial,sans-serif;font-size:16px;color: #949494; font-style: italic;"> ' . nl2br(esc_html($profile_edited_content)) . '</span>
						</p>
					</td>
				</tr>

            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="30"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>';

	}


	$body .= '<tr>
				<td valign="top" align="left">
					<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Account information', 'datebook' ) . ': </span><br />
					<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Username', 'datebook' ) . ': ' . esc_attr($user_login) . '</span><br />
					<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'Email', 'datebook' ) . ': ' . sanitize_email($emailaddress) . '</span>
				</td>
			</tr>';

	$body .= '</tbody>
       </table></td>
      </tr>
     </tbody>
     </table></td>
     </tr>

            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="10"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>';

		$body .= '<tr><td align="left"><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
					<tbody>
						<tr><td align="left" valign="top"><table width="100%" align="left" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;table-layout:fixed;">
							<tbody>
                            <tr>
							  <td valign="top" align="left">
							  <span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'You can view it here', 'datebook' ) . ':<br />
							  <span style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($profile_get_permalink) . '</a></span> 
							  </td>
                            </tr>
                          </tbody>
                        </table></td>
                    </tr>
                  </tbody>
                </table></td></tr>';

		$body .= '<tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="20"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>';
}

// Friend request to Profile
if ($select_email_template == 'friend_request_to_profile') {

	$body .= '
		</tbody>
       </table></td>
      </tr>
     </tbody>
                </table></td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="10"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td align="left"><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td align="left" valign="top"><table width="100%" align="left" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;table-layout:fixed;">
                          <tbody>
                            <tr>
							  <td valign="top" align="left">
							  <span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'A new friend is waiting for your approval here', 'datebook' ) . ':<br />
							  <span style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($profile_get_permalink) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($profile_get_permalink) . '</a></span> 
							  </td>
                            </tr>
                          </tbody>
                        </table></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="20"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>';
}


// Email template for Profile Contact. When someone views profile and sends a message.
if ($select_email_template == 'new_message_to_profile') {

	if(of_get_option('show_name_text_in_notification') == 1){

		if(of_get_option('contact_method') == 1 && of_get_option('show_name_text_in_notification') == 1){

			$body .= '<tr><td valign="top" align="left">';

			$body .= '<span style="font-family:Arial,sans-serif;font-size:13px;color:#000001;">' . esc_attr($from_contacting_name) . '</span> ';

		}

		if(of_get_option('contact_method') == 2){

			$body .= '<span style="font-family:Arial,sans-serif;font-size:13px;color:#0065CB;text-decoration:underline;"><a href="mailto:' . sanitize_email($from_contacting_email) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:13px;color:#0065CB;text-decoration:underline;">' . sanitize_email($from_contacting_email) . '</a></span> ';

		}

		if(of_get_option('contact_method') == 1 && of_get_option('show_name_text_in_notification') == 1){

			$body .= '<span style="font-family:Arial,sans-serif;font-size:13px;color:#000001;">' . esc_html__( 'says', 'datebook' ) . ':</span>';

			$body .= '</td></tr>';

			$body .= '<tr>
						<td height="8"></td>
					</tr>
					<tr>
						<td valign="top" align="left" style="font-family:Arial,sans-serif;font-size:13px;color:#666666;">' . wp_specialchars_decode(esc_html($from_contacting_text), ENT_QUOTES ) . '</td>
					</tr>';

			$body .= '<tr>
						<td>
							<table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
								<tbody>
									<tr>
										<td width="100%" height="30"></td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>';

		}
			
		$body .= '</tbody>
				</table>
			</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>';

		if(of_get_option('contact_method') == 2){

			$body .= '<tr><td valign="top" align="left"><span style="font-family:Arial,sans-serif;font-size:16px;color:#000001;"> ' . esc_html__( 'You can directly reply to the sender of this message', 'datebook' ) . ' </span></td></tr>';

		}
	
	}

}


// Email template for Profile. When someone activates his profile.
if ($select_email_template == 'reply_to_classifieds_to_profile') {

$body .= '<tr>
			<td valign="top" align="left"><span style="font-family:Arial,sans-serif;font-size:13px;color:#000001;">' . esc_attr($from_contacting_name) . ',</span> <span style="font-family:Arial,sans-serif;font-size:13px;color:#0065CB;text-decoration:underline;"><a href="mailto:' . sanitize_email($from_contacting_email) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:13px;color:#0065CB;text-decoration:underline;">' . sanitize_email($from_contacting_email) . '</a></span> <span style="font-family:Arial,sans-serif;font-size:13px;color:#000001;">' . esc_html__( 'says', 'datebook' ) . ':</span></td>
																	</tr>
																	<tr>
																		<td height="8"></td>
																	</tr>
																	<tr>
																		<td valign="top" align="left"><span style="font-family:Arial,sans-serif;font-size:13px;color:#666666;">' . esc_html($contacting_text) . '</span></td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
									<tr>
										<td>
											<table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
												<tbody>
													<tr>
														<td width="100%" height="30"></td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
									<tr>
										<td valign="top" align="left"><span style="font-family:Arial,sans-serif;font-size:16px;color:#000001;"> ' . esc_html__( 'You can directly reply to the sender of this message', 'datebook' ) . ' </span></td>
									</tr>';

}

// Email template for Profile. When someone activates his profile.
if ($select_email_template == 'retrieve_password_message') {

$body .= '<tr>
           <td valign="top" align="left">
				<span style="font-family:Arial,sans-serif;font-size:14px;color:#000001;"> ' . esc_html__( 'To reset your password, click the link bellow', 'datebook' ) . ': </span>
							  </td>
                            </tr>
                            <tr>
                              <td valign="top" align="left">
							  	<span style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;"><a href="' . esc_url($reset_link) . '" target="_blank" style="font-family:Arial,sans-serif;font-size:14px;color:#0066CC;line-height:20px;text-decoration:underline;">' . esc_url($reset_link) . '</a></span>
								</td>
                            </tr>
                          </tbody>
                        </table></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td width="100%" height="30"></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td valign="top" align="left">
			  <span style="font-family:Arial,sans-serif;font-size:13px;color:#666666;">' . esc_html__( 'If this was a mistake, or you did not ask for a password reset, just ignore this email and nothing will happen.', 'datebook' ) . '</span>
			  </td>
            </tr>';

}

// Email Body
if ($select_email_template == 'message_from_contactus_page') {
	
	$body .= esc_html__( 'Sender information', 'datebook' ) . ':<br />';
	$body .= '<strong>' . esc_html__( 'Name', 'datebook' ) . ':</strong> ' . $datebook_contact_text['contacting_name'] . '<br />';
	$body .= '<strong>' . esc_html__( 'Email', 'datebook' ) . ':</strong> ' . $datebook_contact_text['contacting_email'] . '<br />';
	
	if (isset($profile_url)) {
		
		$body .= '<strong>' . esc_html__( 'Profile', 'datebook' ) . ':</strong> ' . esc_url($profile_url) . '<br />';
		
	}
	
	$body .= '<strong>' . esc_html__( 'Message', 'datebook' ) . ':</strong> <br />';
	$body .= $datebook_contact_text['contacting_text'] . '<br /><br />';
	$body .= esc_html__( 'You can directly reply to the sender of this message', 'datebook' );
	
}


// Email Footer
$body .= '<tr>
              <td height="30"><div style="margin:0;padding:0;line-height:0;"> </div></td>
            </tr>
            <tr>
              <td height="2" bgcolor="#E62E04"><div style="margin:0;padding:0;line-height:0;background:#E62E04;"> </div></td>
            </tr>
            <tr>
              <td height="20"><div style="margin:0;padding:0;line-height:0;"> </div></td>
            </tr>
            <tr>
              <td align="left"><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td align="left"><span style="font-family:Arial,sans-serif;font-size:13px;color:#000001;"> ' . esc_html__( 'With kind regards', 'datebook' ) . ',<br />' . esc_html__( 'Your', 'datebook' ) . ' <a href="' . esc_url(home_url()) . '" target="_blank" style="font-family:Arial,sans-serif;color:#0065CB !important;text-decoration:underline;"> ' . esc_attr(get_bloginfo('name')) . ' </a> </span></td>
                      <td align="right"><a href="' . esc_url(home_url()) . '" target="_blank" style="font-family:Arial,sans-serif;"><img src="' . esc_url($datebook_email_logo) . '" border="0" style="display:block;max-width:161px;" alt="" title="" /></a></td>
                    </tr>
                  </tbody>
                </table></td>
            </tr>
            <tr>
              <td height="20"><div style="margin:0;padding:0;line-height:0;">  </div></td>
            </tr>
            <tr>
              <td align="left"><span style="font-family:Arial,sans-serif;color:#656565;font-size:13px;line-height:19px;"> ' . esc_html__( 'Note, we never ask you for your password. If this message has been sent wrong, please inform us', 'datebook' ) . ' <a href="' . esc_url(get_permalink(of_get_option('contact_page'))) . '" target="_blank" style="font-family:Arial,sans-serif;color:#0065CB !important;text-decoration:underline;"><span style="font-family:Arial,sans-serif;color:#0065CB;">' . esc_html__( 'here', 'datebook' ) . '</span></a> . </span></td>
            </tr>
            <tr>
              <td height="8"><div style="margin:0;padding:0;line-height:0;">  </div></td>
            </tr>
            <tr>
              <td align="left"><span style="font-family:Arial,sans-serif;color:#656565;font-size:13px;line-height:19px;">' . esc_attr(get_bloginfo('name')) . ' - ' . esc_html(get_bloginfo('description')) . '</span></td>
            </tr>
          </tbody>
        </table></td>
      <td width="10" height="1"></td>
    </tr>
    <tr>
      <td width="1" height="10" colspan="3"></td>
    </tr>
  </tbody>
</table>';

set_query_var( 'datebook_email_body', $body );