<?php 
/*
 * Notification about user must validate his/her email
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$page_id = get_the_ID();

$page_link = get_permalink($page_id);

$resendactivation_url = add_query_arg( array(
	'action' => 'resendactivation'
), $page_link );

$activatedemailbyadmin_url = add_query_arg( array(
	'verifyemail' => 'activationkeybyadmin',
	'action' => 'activatedemailbyadmin'
), $page_link );

?>

<div class="alert alert-warning alert-dismissable">

	<h4 class="alert-heading"><?php echo esc_html__( 'First, verify your email address', 'datebook' ); ?></h4>

	<p><?php echo esc_html__( 'Before subscribing to any of subscription plans, you must verify your email address.', 'datebook' ); ?></p>

	<a class="btn btn-warning btn-sm" href="<?php echo esc_url($resendactivation_url); ?>"><?php echo esc_html__( 'Send activation to me again!', 'datebook' ); ?></a>
	
	<?php if (is_super_admin()) { ?>
	
		<a class="btn btn-success btn-sm" href="<?php echo esc_url($activatedemailbyadmin_url); ?>"><?php echo esc_html__( 'Activate without email', 'datebook' ); ?></a>
	
	<?php } ?>

</div>
