<?php
/**
 * Create pages for Profiles displayed by type on Search page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php

	endif;

	do_action('datebook_profile_all_statuses');

	DateBook_Search::show_search_form();

	echo DateBook_Search::return_list_of_profiles();

	?>

	</div>
	
	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>
	
	<div class="col-lg-3 col-md-3 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-search' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-search');
			}

			?>

		</div>
	</div>
	
	<?php endif; ?>

</div>
<!-- /content -->