<?php
/*
 * List of friends
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

global $datebook_gender_titles;

// Get IDs of pending friends
$get_pending_friends_ids = isset($datebook_get_data['friends']['pending']) ? array_keys($datebook_get_data['friends']['pending']) : array();

$profile_post = get_post($profile_id);
$profile_post_author = isset($profile_post->post_author) && $profile_post->post_author > 0 ? $profile_post->post_author : 0;

// Detect if approved friends exist
$get_approved_friends_ids = is_array($get_approved_friends_ids) && !empty($get_approved_friends_ids) ? $get_approved_friends_ids : array();

if($current_user_id == $profile_post_author){

	// Merge pending and approved friends
	$get_all_friends_ids = array_merge($get_pending_friends_ids, $get_approved_friends_ids);
	
} else {
	
	$get_all_friends_ids = $get_approved_friends_ids;
	
}

// Check if Retina enabled in Theme Options
$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

//if(of_get_option('datebook_custom_images')){
	// set up cache folder
	$upload_dir = wp_upload_dir();
	$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');
	$columns_image_format = 'image_friend_request';
//}

?>

<h2 id="datebook-friends-list-anchor" name="datebook-friends-list-anchor"><?php esc_html_e( 'My friends', 'datebook' ); ?></h2>

<?php

if(is_array($get_all_friends_ids) && !empty($get_all_friends_ids)){
	
	if($current_user_id == $profile_post_author && is_array($get_pending_friends_ids) && !empty($get_pending_friends_ids)){

	// Show list of friends of profile
	$args = array(
		'post_type' => DATEBOOK_POST_TYPE,
		'post_status' => 'publish',
		'orderby' => 'DESC',
		'posts_per_page' => -1,
		'post__in' => $get_pending_friends_ids
	);

	$the_query = new WP_Query( $args );

	if ( $the_query->have_posts()) :

		?>
		
		<div id="datebook-pending-panel" class="card mb-3 border border-warning">
		
		<div class="card-body">
		
		<h5 class="card-title"><?php esc_html_e( 'Users awaiting your friend approval', 'datebook' ); ?></h5>
		
		<div class="col-sm-12 col-12 col-md-12 col-lg-12 col-xl-12">
		<div class="row">

		<?php

		while ( $the_query->have_posts() ) : $the_query->the_post();

			$profile_id = absint(get_the_ID());

			$friends_data_array = get_post_meta($profile_id, 'profile_personal_data', true);
			$get_friends_data = isset($friends_data_array) ? $friends_data_array : array();

			if($datebook_get_data['friends']['pending'][$profile_id]['status'] == 'pending' && $current_user_id != $profile_post_author) continue;

			$show_accept_button = $show_remove_button = 0;
			$class_friend_request_pending = '';
			if(isset($datebook_get_data['friends']['pending'][$profile_id])){
				if($datebook_get_data['friends']['pending'][$profile_id]['status'] == 'pending'){
					$show_accept_button = 1;
					$class_friend_request_pending = ' datebook-friend-request-pending';
				} else if($datebook_get_data['friends'][$profile_id]['status'] == 'approved'){
					$show_remove_button = 1;
				}
			}
			
			$get_the_title = get_the_title();

			$country_id = isset($get_friends_data['country']) ? $get_friends_data['country'] : '';
			$region_id = isset($get_friends_data['region']) ? $get_friends_data['region'] : '';
			$city_id = isset($get_friends_data['city']) ? $get_friends_data['city'] : '';

			if(isset($city_id)){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
				$country = isset($term_data->country) ? $term_data->country : '';
				$city = isset($term_data->city) ? $term_data->city : '';

			}

			$age = isset($get_friends_data['birthday']) && !empty($get_friends_data['birthday']) ? floor((time() - strtotime($get_friends_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) : '';
			$gender = isset($get_friends_data['gender']) ? $get_friends_data['gender'] : 0;

			if ($gender == 1) {
				$gender_icon = 'fa fa-venus fa-lg';
			} else if ($gender == 2) {
				$gender_icon = 'fa fa-mars fa-lg';
			} else {
				$gender_icon = 'fa fa-user fa-lg';
			}

			$profile_location = '';

			if (isset($city)) {
				$profile_location .= $city;
			}
			if (!empty($city) && !empty($country)) {
				$profile_location .= ", ";
			}
			if (isset($country)) {
				$profile_location .= $country;
			}

			$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true);

			if($thumbnail_url['image_exists'] == 'yes'){

				$profile_image_url = $thumbnail_url['img_full_url'];

			} else {

				$profile_image_url = $cache_url . $columns_image_format . '.png';

			}

			?>

			<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3 datebook-padding-less datebook-friend-id-<?php echo absint($profile_id); ?>">
			<figure class="card mb-3 figure img-thumbnail shadow-sm text-center datebook-friend-box">
				<a class="figure-img img-fluid d-block<?php echo esc_attr($class_friend_request_pending); ?>" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 75%"><img class="img-fluid w-100" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($get_the_title); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

				<?php if($current_user_id == $profile_post_author) { ?>

				<div class="dropdown grey lighten-5 d-none datebook-friends-three-dots">
					<button class="btn p-0 pl-1 pr-1 mt-0 mb-0 shadow-none" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class='fa fa-ellipsis-v'></i></button>
					<div class="dropdown-menu dropdown-menu-right p-0 datebook-dropdown-menu" aria-labelledby="dropdownMenuButton">

						<a class="dropdown-item p-1 pr-2 pl-2 text-center small datebook-remove-friend-request" profile-id="<?php echo absint($profile_id); ?>" href="javascript:void(0)" onclick="return false;"><?php esc_html_e( 'Remove from Friends', 'datebook' ); ?></a>

					</div>
				</div>

				<?php } ?>

				<figcaption class="figure-caption datebook-friend-box-title datebook-ellipsis"><?php echo esc_attr($get_the_title); ?></figcaption>
				<figcaption class="figure-caption"><?php echo esc_attr($age); ?> <span title="<?php if (isset($datebook_gender_titles[$gender])) { echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span></figcaption>
				<figcaption class="figure-caption datebook-ellipsis"><?php echo esc_attr($profile_location); ?></figcaption>

				<?php if($current_user_id == $profile_post_author) { ?>

				<div class="btn-group d-flex text-nowrap datebook-friend-request-buttons" role="group">

				<?php if($show_accept_button == 1) { ?>
					<span class="btn btn-sm btn-success p-1 waves-effect datebook-accept-friend-request" profile-id="<?php echo absint($profile_id); ?>"><?php esc_html_e( 'Accept', 'datebook' ); ?></span> <span class="btn btn-sm btn-light p-1 datebook-reject-friend-request" profile-id="<?php echo absint($profile_id); ?>"><?php esc_html_e( 'Reject', 'datebook' ); ?></span>
				<?php } ?>

				</div>
				
				<?php } ?>
			
			</figure>
			</div>

			<?php
			
		endwhile;
		
		?>
		
		</div>
		</div>

		</div>
		</div>
				
		<?php

	endif;

	wp_reset_postdata();
	
	}


	?>

	<div class="col-sm-12 col-12 col-md-12 col-lg-12 col-xl-12">
	<div id="datebook-friends-list" class="row">

	<?php

	if(is_array($get_approved_friends_ids) && !empty($get_approved_friends_ids)){

	// Show list of friends of profile
	$args = array(
		'post_type' => DATEBOOK_POST_TYPE,
		'post_status' => 'publish',
		'orderby' => 'DESC',
		'posts_per_page' => -1,
		'post__in' => $get_approved_friends_ids
	);

	$the_query = new WP_Query( $args );

	if ( $the_query->have_posts()) :

		while ( $the_query->have_posts() ) : $the_query->the_post();

			$profile_id = absint(get_the_ID());

			$friends_data_array = get_post_meta($profile_id, 'profile_personal_data', true);
			$get_friends_data = isset($friends_data_array) ? $friends_data_array : array();

			if(isset($datebook_get_data['friends']['pending'][$profile_id]) && $datebook_get_data['friends']['pending'][$profile_id]['status'] == 'pending' && $current_user_id != $profile_post_author) continue;

			$show_remove_button = 0;
			if(isset($datebook_get_data['friends'][$profile_id]['status']) && $datebook_get_data['friends'][$profile_id]['status'] == 'approved'){
				$show_remove_button = 1;
			}


			
			$get_the_title = get_the_title();

			$country_id = isset($get_friends_data['country']) ? $get_friends_data['country'] : '';
			$region_id = isset($get_friends_data['region']) ? $get_friends_data['region'] : '';
			$city_id = isset($get_friends_data['city']) ? $get_friends_data['city'] : '';

			if(isset($city_id)){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
				$country = isset($term_data->country) ? $term_data->country : '';
				$city = isset($term_data->city) ? $term_data->city : '';

			}

			$age = isset($get_friends_data['birthday']) && !empty($get_friends_data['birthday']) ? floor((time() - strtotime($get_friends_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) : '';
			$gender = isset($get_friends_data['gender']) ? $get_friends_data['gender'] : 0;

			if ($gender == 1) {
				$gender_icon = 'fa fa-venus fa-lg';
			} else if ($gender == 2) {
				$gender_icon = 'fa fa-mars fa-lg';
			} else {
				$gender_icon = 'fa fa-user fa-lg';
			}

			$profile_location = '';

			if (isset($city)) {
				$profile_location .= $city;
			}
			if (!empty($city) && !empty($country)) {
				$profile_location .= ", ";
			}
			if (isset($country)) {
				$profile_location .= $country;
			}

			$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true);

			if($thumbnail_url['image_exists'] == 'yes'){

				$profile_image_url = $thumbnail_url['img_full_url'];
				
			} else {

				$profile_image_url = $cache_url . $columns_image_format . '.png';
				
			}

			?>
			
		
			<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3 datebook-padding-less datebook-friend-id-<?php echo absint($profile_id); ?>">
			<figure class="card mb-3 figure img-thumbnail shadow-sm text-center datebook-friend-box">
				<a class="figure-img img-fluid d-block" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 75%"><img class="img-fluid w-100" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($get_the_title); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

				<?php if($current_user_id == $profile_post_author && $show_remove_button == 1) { ?>

				<div class="dropdown grey lighten-5 datebook-friends-three-dots">
					<button class="btn p-0 pl-1 pr-1 mt-0 mb-0 shadow-none" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class='fa fa-ellipsis-v'></i></button>
					<div class="dropdown-menu dropdown-menu-right p-0 small datebook-dropdown-menu" aria-labelledby="dropdownMenuButton">

						<a class="dropdown-item p-1 pr-2 pl-2 text-center small datebook-remove-friend-request" profile-id="<?php echo absint($profile_id); ?>" href="javascript:void(0)" onclick="return false;"><?php esc_html_e( 'Remove from Friends', 'datebook' ); ?></a>
						
					</div>
				</div>

				<?php } ?>

				<figcaption class="figure-caption datebook-friend-box-title datebook-ellipsis"><?php echo esc_attr($get_the_title); ?></figcaption>
				<figcaption class="figure-caption"><?php echo esc_attr($age); ?> <span title="<?php if (isset($datebook_gender_titles[$gender])) { echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span></figcaption>
				<figcaption class="figure-caption datebook-ellipsis"><?php echo esc_attr($profile_location); ?></figcaption>

			</figure>
			</div>

			<?php
			
		endwhile;

	endif;

	wp_reset_postdata();
	
	}

	?>

	</div>
	</div>

<?php } else { ?>

	<div class="card border-0 shadow-none datebook-transparent">
		<div class="card-body text-center">

			<h4 class="card-title"><?php esc_html_e( 'No friends', 'datebook' ); ?></h4>

		</div>

        <img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-friends.png');?>" alt="" />

	</div>

<?php

}