<?php
/*
 * Profile Photos form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_field_titles, $datebook_alert_error, $datebook_alert_text, $datebook_image_sizes;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$quantity_photos = absint(of_get_option('quantity_images_per_profile'));

// Check if Payment and Subscription are activated
if (DateBook_Utilities::check_if_gateway_activated()) {

	// Get user subscription id
	$member_subscriptions = datebook_get_member_subscriptions( array( 'user_id' => $current_user_id ) );
	$member_splan_id = isset($member_subscriptions[0]->subscription_plan_id) ? $member_subscriptions[0]->subscription_plan_id : NULL;
	if($member_splan_id > 0){

		$all_splans = get_option('datebook_subscription_plans');
		if(isset($all_splans[$member_splan_id]['upload_images']) && $all_splans[$member_splan_id]['upload_images'] == '1') {
			if(isset($all_splans[$member_splan_id]['subscription_id']) && isset($member_splan_id) && $member_splan_id > 0 && $all_splans[$member_splan_id]['subscription_id'] == $member_splan_id) {
				$quantity_photos = absint($all_splans[$member_splan_id]['subscription_limitphotos']);
			}
		} else {
			$quantity_photos = 0;
		}

	} else {
		$quantity_photos = $quantity_photos;
	}
}

?>

<div class="datebook-custom-card card datebook-photocontainer">
	<div class="card-body">

	<h2><?php esc_html_e( 'My photos', 'datebook' ); ?></h2>

	<?php if (is_user_logged_in()) { ?>

	<div class="datebook-upload-photos-form tooltip-demo">
		<div class="card border mb-3 datebook-transparent">
			<div id="datebook-images-panel" class="card-body">

				<p><?php esc_html_e( 'Click the button and select all the images you want to upload.', 'datebook' ); ?></p>
				
				<p>

				<?php

				

				if ($quantity_photos > 0) {
					
					$quantity_photos_text = sprintf( _n( '%s image', '%s images', $quantity_photos, 'datebook' ), $quantity_photos );

					echo sprintf( esc_html__( 'You may upload up to', 'datebook' ), $quantity_photos_text ) . ' ' . $quantity_photos_text . '. ';

				}
				
				if ( !function_exists( 'wp_max_upload_size' ) ) {
					require_once ABSPATH . WPINC . '/media.php';
				}
				
				$datebook_max_upload_size = of_get_option('allowed_max_image_size') > 0 ? absint(of_get_option('allowed_max_image_size')) : wp_max_upload_size();
				
				echo esc_html__( 'Max image size', 'datebook' ) . ': ' . esc_attr(size_format($datebook_max_upload_size));
				
				$datebook_allowed_extensions = of_get_option('allowed_file_extensions') ? of_get_option('allowed_file_extensions') : '';

				if ( $datebook_allowed_extensions ) {

					echo ' <span class="badge badge-pill badge-info" data-toggle="tooltip" data-placement="right" data-original-title="' . esc_html__( 'Allowed image extensions', 'datebook' ) . ': ' . esc_attr($datebook_allowed_extensions) . '">?</span>';

				}

				?>

				</p>

				<hr />

				<form id="datebook-imageform" enctype="multipart/form-data" name='imageform' method="post" action="<?php echo esc_url(get_permalink(of_get_option('my_photos_page'))); ?>">

					<input type="hidden" name="datebook_image_upload" value="upload" />
					
					<input type="hidden" id="datebook_image_width" name="datebook_image_width" value="<?php echo absint($datebook_image_sizes['image_photos_upload_form']['width']); ?>" />
					<input type="hidden" id="datebook_image_height" name="datebook_image_height" value="<?php echo absint($datebook_image_sizes['image_photos_upload_form']['height']); ?>" />

					<div class="input-group mb-3">
						<div class="custom-file">
							<input type="file" class="custom-file-input datebook-file datebook-image-submit" id="datebook-images" name="images">
							<label class="custom-file-label" for="datebook-images" aria-describedby="datebook-fileaddon"><?php esc_html_e( 'Select an image', 'datebook' ); ?></label>
						</div>
						<div class="input-group-append">
							<button id="datebook-fileaddon" class="input-group-text btn-primary border-0" type="submit"><?php esc_html_e( 'Upload', 'datebook' ); ?></button>
						</div>
					</div>
				</form>


				<div id="datebook-error-div" class="datebook-noimage-error alert alert-warning"><?php esc_html_e( 'Select your image', 'datebook' ); ?></div>

				<div id="datebook-error-div" class="datebook-noimageext-error alert alert-warning"><?php esc_html_e( 'Oops! Your image has wrong file extension', 'datebook' ); ?></div>

					<div id="datebook-loader" class="align-items-center" style="display: none;">
						<?php esc_html_e( 'Image uploading', 'datebook' ); ?> <div class="spinner-border spinner-border-sm ml-3" role="status" aria-hidden="true"></div>
					</div>
				
				
				<div class="datebook-clear20"></div>

				<div class="datebook-img-popup"></div>

				<figure id="blueimp-gallery-links" class="text-center datebook-gallery">

				<?php
				
				$filter = function(){
					return 'post_status ASC';
				};
				add_filter('posts_orderby', $filter);

				$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );
				
				$prohibit_images_delete = of_get_option('prohibit_images_delete');
				$show_deleted_image = ($prohibit_images_delete[2] == 1 || is_super_admin()) ? 'inherit,private' : 'inherit';

				$all_photos_args = array(
					'post_parent' => $profile_id, 
					'post_status' => $show_deleted_image, 
					'post_type' => 'attachment', 
					'post_mime_type' => 'image', 
					'order' => 'ASC', 
					'orderby' => 'menu_order ID',
					'posts_per_page' => -1,
					'suppress_filters' => false,
					'meta_query' => array(
						array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
					)
				);

				$all_photos = new WP_Query( $all_photos_args );

				remove_filter('posts_orderby', $filter);

				if ($all_photos->have_posts()) {

					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					$profile_photo_id = isset($datebook_get_data['profile_photo_id']) ? $datebook_get_data['profile_photo_id'] : '';

					$get_data_gender = isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0 ? $datebook_get_data['gender'] : 0;

					if ($get_data_gender == 1) {
						$gender_img = '-f';
					} else if ($get_data_gender == 2) {
						$gender_img = '-m';
					} else {
						$gender_img = '';
					}

					$upload_folder = isset($datebook_get_data['upload_folder']) ? $datebook_get_data['upload_folder'] : '';

					$upload_dir = wp_upload_dir();
					$targetPath = $upload_dir['basedir'] . '/' . $upload_folder;

					while($all_photos->have_posts()) : $all_photos->the_post();

						$photo_id = $all_photos->post->ID;
						
						$get_the_title = get_the_title($all_photos->post->ID);

						$photo_url = explode('.', $get_the_title);

						$thumbnail_file = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_photos_upload_form']['width'] . 'x' . $datebook_image_sizes['image_photos_upload_form']['height']) . '.' . $photo_url[1];

						$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file;
						
						$thumb_no_exist = $big_thumb_no_exist = 0;

						if (!file_exists($targetPath . '/' . $thumbnail_file)) {

							if (!file_exists($targetPath . '/' . $get_the_title)) {

								$thumb_noimage_name = str_replace('_','-', 'image_photos_upload_form');
								$thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';
								$thumb_no_exist = 1;

							} else {

								$image = wp_get_image_editor($targetPath . '/' . $get_the_title);
								if ( ! is_wp_error( $image ) ) {
									$image->resize( $datebook_image_sizes['image_photos_upload_form']['width'], $datebook_image_sizes['image_photos_upload_form']['height'], true );
									$image->save($targetPath . '/' . $thumbnail_file);
								}
							}

						}

						$big_thumbnail_file = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'] . 'x' . $datebook_image_sizes['image_big']['height']) . '.' . $photo_url[1];
						
						$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_file;

						if (!file_exists($targetPath . '/' . $big_thumbnail_file)) {

							if (!file_exists($targetPath . '/' . $get_the_title)) {

								$thumb_noimage_name = str_replace('_','-', 'image_big');
								$big_thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';
								$big_thumb_no_exist = 1;

							} else {
								
								$image = wp_get_image_editor($targetPath . '/' . $get_the_title);
								if ( ! is_wp_error( $image ) ) {
									$image->resize( $datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height'], true );
									$image->save($targetPath . '/' . $big_thumbnail_file);
								}
							}
						}

						$style = 'default';
						

						$profile_photo_id_parse = explode('/', $profile_photo_id);
						$profile_photo_id_array = count($profile_photo_id_parse) > 1 ? $profile_photo_id_parse[1] : $profile_photo_id_parse[0];
						
						// Check if default photo set
						if ($profile_photo_id_array == $get_the_title){
							$style = 'primary';
							$class = ' selected';
						} else {
							$style = 'light';
							$class = '';
						}

						echo '<div id="' . absint($photo_id) . '" class="view p-1 text-center datebook-img-single" style="float:left;margin-right: 10px;margin-bottom: 14px;">';
						echo '<span class="rounded shadow-sm ' . esc_attr($class) . '">';
						if ($thumb_no_exist == 0){
							echo '<a class="white text-center datebook-frontphoto" href="' . esc_url($big_thumbnail_url) . '" style="width: ' . $datebook_image_sizes['image_photos_upload_form']['width'] . 'px; height:' . $datebook_image_sizes['image_photos_upload_form']['height'] . 'px;">';
						}
						echo '<img class="img-fluid m-auto datebook-pic-rotate-' . absint($photo_id) . '" src="' . esc_url($thumbnail_url) . '" alt="" />';
						if ($thumb_no_exist == 0){
							echo '</a>';
						}

						if ($all_photos->post->post_status == 'private' || $thumb_no_exist == 1){

							echo '<div class="mask flex-center waves-effect waves-light rgba-black-light">';
							echo '<p class="white-text">' . esc_html__( 'Deleted', 'datebook' ) . '</p>';
							echo '</div>';

						}

						// Rotate image
						echo '<input type="hidden" name="rotation" id="datebook-rotation-' . absint($photo_id) . '" value="0" />';
						echo '<button id="datebook-rotate" class="datebook-rotate datebook-rotate-' . absint($photo_id) . '" value="' . absint($photo_id) . '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__('Rotate', 'datebook') .'"><i class="fas fa-redo-alt"></i></button>';
						echo '<div class="spinner-border spinner-border-sm datebook-rotate-process datebook-rotate-process-' . absint($photo_id) . '" role="status" aria-hidden="true"></div>';

						//echo '</a>';
						echo '</span>';

						echo '<div class="datebook-clear5"></div>';

						if ($thumb_no_exist == 0 && $all_photos->post->post_status == 'inherit') {

							echo '<button id="datebook-img-main-id" class="btn btn-' . esc_attr($style) . ' btn-sm m-1 p-1 pr-3 pl-3 shadow-none datebook-default-btn-' . absint($photo_id) . '" value="' . absint($photo_id) . '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__('Make default', 'datebook') .'"><i class="fa fa-check"></i></button> ';

						} else {

							echo '<button class="btn btn-light btn-sm m-1 p-1 pr-3 pl-3 shadow-none" value="" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__('Make default', 'datebook') .'" disabled><i class="fas fa-ban"></i></button> ';

						}

						$prohibit_delete = ($prohibit_images_delete[1] == 1) ? 1 : 0;
						$prohibit_delete_status = ($prohibit_delete == 1 && $all_photos->post->post_status == 'private') ? 1 : 0;
						$hide_delete_button = ($prohibit_images_delete[3] == 1) ? 1 : 0;

						if ($hide_delete_button == 0) {
							if ($prohibit_delete_status == 0) {

								echo '<button id="datebook-img-delete-id" class="btn btn-sm btn-light m-1 p-1 pr-3 pl-3 shadow-none datebook-delete-btn-' . absint($photo_id) . '" value="' . absint($photo_id) . '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__('Delete image', 'datebook') .'"><i class="fa fa-trash"></i></button>';

							}
						}

						echo '</div>'."\n";

						unset($style, $class);

					endwhile;
					
				}
				
				wp_reset_postdata();

				?>
				
				</figure>

				<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" style="display:none">
					<div class="slides"></div>
					<h3 class="title"></h3>
					<a class="prev">‹</a>
					<a class="next">›</a>
					<a class="close">×</a>
					<a class="play-pause"></a>
					<ol class="indicator"></ol>
				</div>
			</div>

			<div class="datebook-clear20"></div>

		</div>
	</div>

	<?php

	} else {

		esc_html_e( 'You need to login or register to upload photos', 'datebook' );

	}

	?>
	
</div>
</div>