<?php
/*
 * Countries for translation
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get all translated cities
$datebook_translated_cities = get_option('datebook_translated_cities');

?>

<div class="datebook-translate-cities">

	<?php

	$pre_count_cities = $count_item = $count_cities = 0;

	$search_item = $search_buttons = '';

	$search_item .= '<form action="https://demo1.pagickthemes.com/registration/?translate=google" method="post">';
	$search_item .= '<input type="hidden" name="action" value="get_translated_words" />';

	$search_item .= '<ol>';

	foreach( $pre_cities_only as $region_country => $get_cities_only ){

		$pre_count_cities += count($get_cities_only);

		//$count_cities = 0;

		foreach( $get_cities_only as $get_city_value ){

			if(isset($datebook_translated_cities) && is_array($datebook_translated_cities) && in_array($get_city_value['id'], $datebook_translated_cities)) continue;

			$get_city_value_name_array = maybe_unserialize( $get_city_value['name'] );

			// if foreign language do not exist, then show title in English (en_US)
			$city_name_exists = isset($get_city_value_name_array[$get_language_code]) && !empty($get_city_value_name_array[$get_language_code]) ? $get_city_value_name_array[$get_language_code] : '';

			if($city_name_exists == ''){

				$count_cities++;

				$city_name = isset($get_city_value_name_array['en_US']) && !empty($get_city_value_name_array['en_US']) ? $get_city_value_name_array['en_US'] : '';

				$city_name = str_replace("&rsquo;", '', $city_name);
				$city_name = str_replace("&lsquo;", '', $city_name);

				$search_item .= '<li><div class="row datebook-countrymenu"><div class="col-5">';

				$search_item .= '<input id="' . esc_attr($get_city_value['id']) . '" class="form-control datebook-city-to ' . esc_attr($get_city_value['id']) . '" type="text" name="datebook_city_name[' . esc_attr($get_city_value['id']) . ']" value=""> ';

				$search_item .= '</div>';
				$search_item .= '<div class="col-7 datebook-city-from" title="'.esc_attr($city_name).'" data-id="' . esc_attr($get_city_value['id']) . '">';

				$city_name = str_replace(',', '', $city_name);
				$search_item .= esc_attr($city_name . ', ' . $region_country);

				$search_item .= '</div></div></li>';
				
			}

			if($pre_count_cities > 150) {
				if($count_cities <= 150) {
					if($count_cities >= 150) break;
				}
			}
		}

		if($count_cities >= 150) {break;}

	}
	
	$search_item .= '</ol>';

	$search_item .= '<input type="submit" id="translate-submit-button" class="btn btn-success btn-lg" value="2. Submit" disabled />';
	$search_item .= '</form>';

	$search_items_out = '';
	$search_items_out .= $count_cities;
	$search_items_out .= $search_item;

	// Escape all fields but keep HTML tags
	echo stripslashes_deep($search_items_out);

	?>
	
	<button onclick="myFunction()" class="btn btn-warning btn-lg datebook-move-cities">1. Click me</button>
	

</div>

<script>
function myFunction() {

	var x = document.getElementsByClassName("datebook-city-from");
	var i;
	for (i = 0; i < x.length; i++) {

		var get_inner_text = x[i].innerHTML;
		
		var StrippedString = get_inner_text.replace(/<\/?[^>]+(>|$)/g, "");

		var fields = StrippedString.split(',');
		var city_name = fields[0];

		var get_data_id = x[i].getAttribute('data-id');

		var text = document.getElementById(get_data_id);
		text.value += city_name;

	}

	document.getElementById('translate-submit-button').disabled = false;

}
</script>