<?php
/*
 * Content template for Single Classified page
 */

global $post, $datebook_image_sizes;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

// Check if Retina enabled in Theme Options
$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

?>

<div class="datebook-custom-card card">
	<div class="card-body">

		<h4><?php esc_html_e( 'Tour Details', 'datebook' ); ?></h4>

		<hr />

		<?php
			while (have_posts()) : the_post();
				
				$post_id = get_user_meta( get_the_author_meta('ID'), "profile_postid", true );
				$profile_data = get_post($post_id);
				
				if (!empty($profile_data->ID) && $profile_data->ID > 1) {

					$profile_id = $profile_data->ID;
					$profile_title = $profile_data->post_title;
					$profile_status = $profile_data->post_status;
				
					$get_profile_data = get_post_meta($profile_id, "profile_personal_data", true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					if(isset($datebook_get_data['city'])){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
						$country = isset($term_data->country) ? $term_data->country : '';
						$city = isset($term_data->city) ? $term_data->city : '';

					}

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
					$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';
					
					if ($gender == 1) {

						$gender_icon = 'fa fa-venus fa-lg';

					} else if ($gender == 2) {

						$gender_icon = 'fa fa-mars fa-lg';

					} else {

						$gender_icon = 'fa fa-user fa-lg';

					}
				
				}

				$tour_id = get_the_ID();
				
				$profile_data = get_post($tour_id);
				$profile_postid = $profile_data->post_author;
				$user = get_userdata( $profile_postid );
				$profile_title = $user->display_name;
				$profile_email = $user->user_email;

				$city_id = get_post_meta($tour_id, 'city', true);

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
				$tour_country = isset($term_data->country) ? $term_data->country : '';
				$tour_city = isset($term_data->city) ? $term_data->city : '';

				$tour_start = DateBook_Utilities::datebook_date_i18n(1, get_post_meta($tour_id,'start', true), false);
				$tour_end = DateBook_Utilities::datebook_date_i18n(1, get_post_meta($tour_id, 'end', true), false);

				$about_tour = get_the_content();
				$tour_payment_status = get_post_meta($tour_id, "tour_paid", true);				
		?>

		<h1><?php the_title(); ?></h1>

		<div class="row">
			<div class="col-lg-7 col-md-7 col-sm-7">
				<ul class="media-list">
					<li class="media">
						<div class="media-body">

							<p><?php echo esc_html__( 'Placed', 'datebook' ) . ': ' . DateBook_Utilities::datebook_date_i18n(1, get_the_date()); ?></p>

							<hr />

							<?php
								
							if (isset($tour_city)) {

								echo '<p><strong>' . esc_html__( 'Destination', 'datebook' ) . ':</strong> ' . esc_attr($tour_city); }
									
							if (isset($tour_city) && isset($tour_country)) { echo ", "; }

							if (isset($tour_country)) {
								echo esc_attr($tour_country) . '</p>';
							}

							if ($tour_start) {

								echo '<p><strong>' . esc_html__( 'Starts', 'datebook' ) . ':</strong> ' . esc_attr($tour_start) . '</p>';

							}

							if ($tour_end) {

								echo '<p><strong>' . esc_html__( 'Ends', 'datebook' ) . ':</strong> ' . esc_attr($tour_end) . '</p>';

							}

							?>

							<p><?php echo nl2br(get_the_content()); ?></p>

						</div>
					</li>
				</ul>
			</div>
			<div class="col-lg-5 col-md-5 col-sm-5">

				<?php
				
				if (!empty($profile_id) && $profile_id > 1 && $profile_status == 'publish') {
					
					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_avatar', $gender, true);

				?>
				
				<ul class="media-list">

					<li class="media"><a class="float-left" href="<?php echo esc_url(get_permalink($profile_id)); ?>"><img class="media-object img-rounded" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" width="<?php echo esc_attr($datebook_image_sizes['image_avatar']['width']); ?>" height="<?php echo esc_attr($datebook_image_sizes['image_avatar']['height']); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

						<div class="media-body">

							<h4 class="media-heading"><a href="<?php echo esc_url(get_permalink($profile_id)); ?>"><?php echo esc_attr($profile_title); ?></a></h4>

							<p>
							
							<?php echo esc_attr($age); ?> 
							
							<span class="label"><?php if(isset($datebook_sexualorientation_titles[$sexualorientation])){
								$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
								echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' ); } ?></span>&nbsp;
							
							<span title="<?php if(isset($datebook_gender_titles[$gender])){ echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>
							
							</p>

							<p>
							
							<?php 

							if (isset($city)) {

								echo esc_attr($city);

							}
							
							if (isset($city) && isset($country)) {

								echo ", ";
							
							}

							if (isset($country)) {

								echo esc_attr($country);

							}

							?>
							
							</p>

						</div>
					</li>
				</ul>
				
				<?php } ?>

				<?php if ($profile_email) { ?>

				<div id="datebook-contactpanel">

					<?php
						if (isset($datebook_alert_error) && $_POST['action'] == "contacting") {

							echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_error_text) . '</div>';

						}

						if (isset($alert_success) && $_POST['action'] == "contacting") {

							echo '<div class="alert alert-succes">' . esc_attr($alert_success_text) . '</div>';

						}
						
						if (of_get_option("contact_method") == "1") {
						?>

							<div id="datebook-emailpopup" class="datebook-emailpopup btn btn-primary btn-contact"><a href="<?php echo esc_url(get_permalink(of_get_option("my_messages_page")));?>?action=read&sid=<?php echo absint($post->post_author);?>&rid=<?php echo absint($current_user_id);?>" target="_blank"><i class="fa fa-envelope"></i> <?php esc_html_e( 'Write a message', 'datebook' ); ?></a></div>

						<?php } else { ?>

							<div id="datebook-emailpopup" class="btn-group">

								<button data-toggle="dropdown" class="btn btn-primary btn-message" type="button"><i class="fa fa-envelope"></i> <?php esc_html_e( 'Write a message', 'datebook' ); ?></button>

								<button data-toggle="dropdown" class="btn btn-secondary btn-message dropdown-toggle" type="button">

							<?php
								if (isset($datebook_alert_error) && $_POST['action'] == "contacting") {
									echo '<span>&#x25B2;</span>';
								} else {
									echo '<span>&#x25BC;</span>';
								}
							?>
								</button>

							</div>

						<?php

							include DateBook_Template_Loader::locate( 'profile/profile-contact-form' );

						}

						?>

					</div>

				<?php } ?>

			</div>
		</div>

		<?php endwhile; ?>

	</div>
</div>