<?php
/**
 * The default template for displaying related Profiles in sidebar. Used in widgets/widget-related-profiles-by-city.php and widgets/widget-related-profiles-by-country.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$profile_id = absint(get_the_ID());

// set up cache folder
$upload_dir = wp_upload_dir();
$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');


$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

$country_id = isset($datebook_get_data['country']) ? $datebook_get_data['country'] : '';
$region_id = isset($datebook_get_data['region']) ? $datebook_get_data['region'] : '';
$city_id = isset($datebook_get_data['city']) ? $datebook_get_data['city'] : '';

if(isset($city_id) && $city_id > 0){
	
	global $allowedposttags;

	$datebook_widget_options = get_query_var( 'datebook_widget_options' );
	if ( is_array( $datebook_widget_options ) ) { extract($datebook_widget_options); }

	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

	$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
	$country = isset($term_data->country) ? $term_data->country : '';
	$city = isset($term_data->city) ? $term_data->city : '';

	$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

	$meta_gender_array = array( 'key' => 'gender', 'value' => $gender, 'compare' => '=', 'type' => 'NUMERIC' );

	$meta_city_array = array( 'key' => 'city', 'value' => $city_id, 'compare' => '=', 'type' => 'NUMERIC' );
	$meta_country_array = array( 'key' => 'country', 'value' => $country_id, 'compare' => '=', 'type' => 'NUMERIC' );


	$related_country_url = add_query_arg( array(
		'action' => 'searchprofiles',
		'country' => $country_id,
		'gender' => $gender
	), get_permalink(of_get_option('search_results_page')) );

	// count profiles and devide on columns and rows
	$column_number = 12 / $columns; // 12 - number of bootstrap columns
	$posts_per_page = $columns * $rows;

	// Show Profiles from City of Profile
	if ($related_profiles_from_countries != 1) {

		$display_regions = 1;

		$location_title = $city;

		// 1. Search for profiles with the same gender and city
		$args = array(
			'post_type' => DATEBOOK_POST_TYPE,
			'post_status' => 'publish',
			'orderby' => $sort_by,
			'posts_per_page' => $posts_per_page,
			'post__not_in' => array($profile_id),
			'meta_query' => array(
				$meta_gender_array,
				$meta_city_array
			)
		);

		$the_query = new WP_Query( $args );

		// 2. Search for profiles with the same gender and country
		if ($the_query->have_posts()) : 

		else :

			$location_title = $country;

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => $sort_by,
				'posts_per_page' => $posts_per_page,
				'post__not_in' => array($profile_id),
				'meta_query' => array(
					$meta_gender_array,
					$meta_country_array
				)
			);

			$the_query = new WP_Query( $args );
			
		endif;

		// 3. Search for profiles with the same country
		if ($the_query->have_posts()) : 

		else :

			$location_title = $country;

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => $sort_by,
				'posts_per_page' => $posts_per_page,
				'post__not_in' => array($profile_id),
				'meta_query' => array(
					$meta_country_array
				)
			);

			$the_query = new WP_Query( $args );
			
		endif;

		// 3. Search for profiles from other countries with the same gender
		if ($the_query->have_posts()) : 

		else :
		
			$display_regions = 0;

			$location_title = esc_html__( 'other countries', 'datebook' );

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => $sort_by,
				'posts_per_page' => $posts_per_page,
				'post__not_in' => array($profile_id),
				'meta_query' => array(
					$meta_gender_array
				)
			);

			$the_query = new WP_Query( $args );

		endif;

		if ($the_query->have_posts()) : 

			if($display_regions == 1){

				$related_city_url = add_query_arg( array(
					'action' => 'searchprofiles',
					'city' => $city_id,
					'country' => $country_id,
					'gender' => $gender
				), get_permalink(of_get_option('search_results_page')) );

			} else {

				$related_city_url = add_query_arg( array(
					'action' => 'searchprofiles',
					'gender' => $gender
				), get_permalink(of_get_option('search_results_page')) );

			}

			$column_number_out = 'col-lg-' . $column_number . ' col-md-' . $column_number . ' col-sm-' . $column_number;
			
			/* Before widget (defined by themes). */
			echo $before_widget;

		?>

		<div class="card-header">
			<h6 class="card-title font-weight-light mb-0"><?php esc_html_e( 'Profiles from', 'datebook' ); ?> <a class="badge badge-info cyan shadow-none" href="<?php echo esc_url($related_city_url); ?>"><?php echo esc_attr($location_title);?></a></h6>
		</div>

		<div class="card-body">
			<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">
				<div class="row">

				<?php

				while ( $the_query->have_posts() ) : $the_query->the_post();

					$profileside_id = absint(get_the_ID());

					$get_profile_data = get_post_meta($profileside_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					$country_id = isset($datebook_get_data['country']) ? $datebook_get_data['country'] : '';
					$region_id = isset($datebook_get_data['region']) ? $datebook_get_data['region'] : '';
					$city_id = isset($datebook_get_data['city']) ? $datebook_get_data['city'] : '';

					if(isset($city_id)){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
						$country = isset($term_data->country) ? $term_data->country : '';
						$city = isset($term_data->city) ? $term_data->city : '';

					}

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

					if ($gender == 1) {
						$gender_icon = 'fa fa-venus fa-lg';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars fa-lg';
					} else {
						$gender_icon = 'fa fa-user fa-lg';
					}


					$location_tooltip = (isset($enabled_country) && $enabled_country == 1) ? ' ' . $city . ', ' . $country : '';

					$get_the_title = get_the_title();

					$title_for_alt = $get_the_title . ', ' . $age;

					if (isset($city)) {
						$title_for_alt .= esc_attr($city);
					}
					if (!empty($city) && !empty($country)) {
						$title_for_alt .= ', ';
					}
					if (isset($country)) {
						$title_for_alt .= esc_attr($country);
					}

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profileside_id, 'image_related_profiles_by_city_sidebar', $gender, true);
					
					if($thumbnail_url['image_exists'] == 'yes'){

						$profile_image_url = $thumbnail_url['img_full_url'];

					} else {

						$profile_image_url = $cache_url . 'image_related_profiles_by_city_sidebar.png';

					}

					echo '<div class="' . esc_attr($column_number_out) . ' col-4 datebook-padding-less text-center mt-1 mb-2">';

					echo '<a class="d-block" href="' . get_the_permalink() . '" title="' . esc_attr($get_the_title) . '"';

					if ($enabled_tooltip == 1) {
						echo ' data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="' . esc_attr($age) . ' ' . wp_kses( $location_tooltip, $allowedposttags ) . '"';
						//<i class='" . esc_attr($gender_icon) . "'></i>
					}

					echo ' style="background-image: url(' . esc_url($thumbnail_url['img_full_url']) . '); background-repeat: no-repeat; background-position: center; background-size: 75%">';

					echo '<img class="' . esc_attr($roundness) . ' w-100" src="' . esc_url($profile_image_url) . '" alt="' . esc_attr($title_for_alt) . '"';

					if($enable_retina_images == 1) {
						echo ' data-rjs="2"';
					}

					echo '/></a>';

					echo '</div>';

				endwhile;

				?>

				</div>
			</div>
		</div>
		
		<?php if($display_regions == 1){ ?>

		<hr />

		<div class="card-body">
			<div class="datebook-countries">

			<?php
			
			global $wpdb;
			
			$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
			
			$countries_and_cities = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $table_countries . " WHERE parent_id = %d AND counter > %d ORDER BY id ASC", $country_id, 0), ARRAY_A);

			echo '<p class="mb-1 font-weight-light small">' . esc_html__( 'Regions of', 'datebook' ) . ' <a href="'.esc_url($related_country_url).'" title="' . esc_attr($country) . '">' . esc_attr($country) . '</a></p>';

			echo '<ul class="list-inline">';
		
			foreach ($countries_and_cities as $key => $subcat_1) {
			
				if ($subcat_1['id'] == $country_id) {

					foreach ($countries_and_cities as $key => $subcat_2) {

						if ($subcat_2['id'] == $subcat_1['parent_id']) {

							$subcat_id_2 = $subcat_2['id'];

							$subcat_2 = maybe_unserialize( $subcat_2['name'] );
							// if foreign language do not exist, then show title in English (en_US)
							$subcat_name_2 = isset($subcat_2[DATEBOOK_WPLANG]) ? $subcat_2[DATEBOOK_WPLANG] : $subcat_2['en_US'];

							$related_region_url = add_query_arg( array(
								'action' => 'searchprofiles',
								'region' => (int)$subcat_id_2,
								'country' => $country_id,
								'gender' => $gender
							), get_permalink(of_get_option('search_results_page')) );

							echo '<li class="list-inline-item datebook-subcountry datebook-subcountry-' . esc_attr($subcat_id_2) . '">';
							echo '<a class="font-weight-light small" href="' . esc_url($related_region_url) . '">' . esc_attr($subcat_name_2) . '</a>';
							echo '</li>';

						}

					}

				}


				if (isset($subcat_1['parent_id']) && $subcat_1['parent_id'] == $country_id) {

					$subcat_id_1 = $subcat_1['id'];

					$subcat_1 = maybe_unserialize( $subcat_1['name'] );

					// if foreign language do not exist, then show title in English (en_US)
					$subcat_name = isset($subcat_1[DATEBOOK_WPLANG]) ? $subcat_1[DATEBOOK_WPLANG] : $subcat_1['en_US'];

					$subcat_title = esc_html__( 'Profiles from', 'datebook' ) . ' ' . esc_attr($subcat_name);
					
					$related_region_url_2 = add_query_arg( array(
						'action' => 'searchprofiles',
						'region' => (int)$subcat_id_1,
						'country' => $country_id,
						'gender' => $gender
					), get_permalink(of_get_option('search_results_page')) );

					echo '<li class="list-inline-item datebook-subcountry datebook-subcountry-' . esc_attr($subcat_id_1) . '">';
					echo '<a class="font-weight-light small" href="' . esc_url($related_region_url_2) . '" title="' . esc_attr($subcat_title) . '">' . esc_attr($subcat_name) . '</a>';
					echo '</li>';

				}

			}

			echo '</ul>';

			?>

			</div>
		</div>

		<?php } ?>

		<?php

		/* After widget (defined by themes). */
		echo $after_widget;

		endif;

		wp_reset_postdata();


	} else {

		// Show Profiles from Country of Profile
		
		$quantity_profilesbycountry = of_get_option('quantity_profilesbycountry') > 0 ? of_get_option('quantity_profilesbycountry') : 6;
		$quantity_of_rows_profilesbycountry = of_get_option('quantity_of_rows_profilesbycountry') > 0 ? of_get_option('quantity_of_rows_profilesbycountry') : 2;

		$total_quantity_bycountry = $quantity_profilesbycountry * $quantity_of_rows_profilesbycountry;
		
		$display_other_profiles = 1;

		// 1. Search for profiles with the same gender and city
		$args = array(
			'post_type' => DATEBOOK_POST_TYPE,
			'post_status' => 'publish',
			'orderby' => 'rand',
			'posts_per_page' => $total_quantity_bycountry,
			'post__not_in' => array($profile_id),
			'meta_query' => array(
				$meta_country_array
			)
		);

		$the_query = new WP_Query( $args );
		
		$location_title = $country;

		// 2. Search for profiles from other countries with the same gender
		if ($the_query->have_posts()) : 

		else :

			$display_other_profiles = 0;

			$location_title = esc_html__( 'other countries', 'datebook' );

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => 'rand',
				'posts_per_page' => $total_quantity_bycountry,
				'post__not_in' => array($profile_id),
			);

			$the_query = new WP_Query( $args );

		endif;

		if ( $the_query->have_posts()) :
		
			if($display_other_profiles == 0){
				$related_country_url = add_query_arg( array(
					'action' => 'searchprofiles',
					'gender' => $gender
				), get_permalink(of_get_option('search_results_page')) );
			}

			switch($quantity_profilesbycountry) {
				case 2 : $columns = 'col-lg-6 col-md-6 col-sm-6 col-6'; break; // 2 columns
				case 3 : $columns = 'col-lg-4 col-md-4 col-sm-4 col-4'; break; // 3 columns
				case 4 : $columns = 'col-lg-3 col-md-3 col-sm-3 col-3'; break; // 4 columns
				case 6 : $columns = 'col-lg-2 col-md-2 col-sm-4 col-4'; break; // 6 columns
				case 12 : $columns = 'col-lg-1 col-md-1 col-sm-3 col-3'; break; // 12 columns
				default: $columns = 'col-lg-2 col-md-2 col-sm-2'; break; // 1 columns
			}
			
			/* Before widget (defined by themes). */
			echo $before_widget;

			?>

			<div class="card-header">

				<h6 class="card-title mb-0"><?php esc_html_e( 'More profiles from', 'datebook' ); ?> <a class="badge badge-info cyan shadow-none" href="<?php echo esc_url($related_country_url); ?>"><?php echo esc_attr($location_title);?></a></h6>

			</div>

			<div class="container">
				<div class="row">

				<?php
		
				$i=0;

				while ( $the_query->have_posts() ) : $the_query->the_post();
				
					if ($i == 5) { $thumblast = ' last'; } else { $thumblast = ''; }

					$i++;

					$profileside_id = absint(get_the_ID());

					if($profileside_id == $profile_id) continue;

					$get_profile_data = get_post_meta($profileside_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();
			
					$country_id = isset($datebook_get_data['country']) ? $datebook_get_data['country'] : '';
					$region_id = isset($datebook_get_data['region']) ? $datebook_get_data['region'] : '';
					$city_id = isset($datebook_get_data['city']) ? $datebook_get_data['city'] : '';

					if(isset($city_id)){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
						$country = isset($term_data->country) ? $term_data->country : '';
						$city = isset($term_data->city) ? $term_data->city : '';

					}
					
					$location_tooltip = (isset($enabled_country) && $enabled_country == 1) ? '<br />' . $city . ', ' . $country : '';

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

					if ($gender == 1) {
						$gender_icon = 'fa fa-venus fa-lg';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars fa-lg';
					} else {
						$gender_icon = 'fa fa-user fa-lg';
					}


					$get_the_title = get_the_title();

					$title_for_alt = $get_the_title . ', ' . $age;

					if (isset($city)) {
						$title_for_alt .= esc_attr($city);
					}
					if (!empty($city) && !empty($country)) {
						$title_for_alt .= ', ';
					}
					if (isset($country)) {
						$title_for_alt .= esc_attr($country);
					}

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profileside_id, 'image_related_profiles_by_country_sidebar', $gender, true);
					
					if($thumbnail_url['image_exists'] == 'yes'){

						$profile_image_url = $thumbnail_url['img_full_url'];

					} else {

						$profile_image_url = $cache_url . 'image_related_profiles_by_country_sidebar.png';

					}

					?>
				
					<div class="<?php echo esc_attr($columns); ?>">
						<div class="row">
							<a class="d-block w-100<?php echo esc_attr($thumblast); ?>" href="<?php the_permalink(); ?>" <?php if ($enabled_tooltip == 1) { ?> data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="<?php echo esc_attr($age) . "<i class='" . esc_attr($gender_icon) . "'></i>" . wp_kses( $location_tooltip, $allowedposttags ); ?>"<?php } ?> title="<?php echo esc_attr($get_the_title); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 75%"><img class="img-fluid w-100" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>
						</div>
					</div>

				<?php endwhile; ?>
				
				</div>
			</div>

		<?php

		/* After widget (defined by themes). */
		echo $after_widget;

		endif;

		wp_reset_postdata();

	}
}